Rem
Rem $Header: dbgendev/src/langdata/plsql/dbassist/dbassist_pkg.sql /main/3 2025/07/01 20:37:49 pryarla Exp $
Rem
Rem dbassist_pkg.sql
Rem
Rem Copyright (c) 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      dbassist_pkg.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/plsql/dbassist/dbassist_pkg.sql
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    pryarla     06/24/25 - Search using dbassist domain
Rem    gadiga      05/20/25 - PLSQL interface which takes natural language,
Rem                           calls langdata, parses JSON and runs query
Rem    gadiga      05/20/25 - Created
Rem


create or replace package dbms_dbassist AUTHID CURRENT_USER as
  function ask (p_summ in varchar2, p_module varchar2 default '%') return SYS_REFCURSOR;
  function get_related_reports (p_summ in varchar2, p_module varchar2 default '%') return SYS_REFCURSOR;
end;
/

create or replace package body dbms_dbassist as
  function ask (p_summ in varchar2, p_module varchar2 default '%') return SYS_REFCURSOR as
    v_cursor     SYS_REFCURSOR;
    v_val varchar2(4000) := null;
    v_report_matches JSON;
    v_search_id varchar2(4512);
    V_QUERY_TEXT			VARCHAR2(4512);
    V_FEEDBACK_RATING		BOOLEAN;
    V_FEEDBACK_COMMENTS		VARCHAR2(4512);
    V_REQUIRED_FEEDBACK_ACTION	VARCHAR2(4512);
    V_FEEDBACK_ACTION_PRIORITY	VARCHAR2(4512);
    V_EXPECTED_REPORT_ID		VARCHAR2(4512);
    V_EXPECTED_DRILLDOWN_ID	VARCHAR2(4512);
    V_SEARCH_TYPE			VARCHAR2(4512);
    V_AUGMENTED_QUERY_TEXT 	VARCHAR2(4512);
    jarr json_array_t;
    jobj json_object_t;
    v_filter varchar2(1024);
    v_filter_name varchar2(1024);
    v_word1 varchar2(1024);
  begin
    lang_data_search_pkg.search_from_query(
        p_search_id       => v_search_id,
        p_query           => p_summ,
        p_domain          => 'dbassist'
    );
    lang_data_search_pkg.get_user_search_record(
        p_id      => v_search_id,
        P_QUERY_TEXT			=> V_QUERY_TEXT,
        P_REPORT_MATCHES		=> V_REPORT_MATCHES,
        P_FEEDBACK_RATING		=> V_FEEDBACK_RATING,
        P_FEEDBACK_COMMENTS		=> V_FEEDBACK_COMMENTS,
        P_REQUIRED_FEEDBACK_ACTION	=> V_REQUIRED_FEEDBACK_ACTION,
        P_FEEDBACK_ACTION_PRIORITY	=> V_FEEDBACK_ACTION_PRIORITY,
        P_EXPECTED_REPORT_ID		=> V_EXPECTED_REPORT_ID,
        P_EXPECTED_DRILLDOWN_ID	=> V_EXPECTED_DRILLDOWN_ID,
        P_SEARCH_TYPE			=> V_SEARCH_TYPE,
        P_AUGMENTED_QUERY_TEXT 	=> V_AUGMENTED_QUERY_TEXT
    );

    DBMS_OUTPUT.PUT_LINE('Report Matches: ' || JSON_SERIALIZE(v_report_matches));
    -- Capture the top matched SQL ($[0])
    for rec in (SELECT JSON_QUERY(v_report_matches, '$[0].report_match_document.sql' returning varchar2 ) sqls 
	        from DUAL)
    LOOP
      v_val := replace(rec.sqls, '"', '');
      dbms_output.put_line(v_val);
    END LOOP;

    for rec in (SELECT JSON_QUERY(v_report_matches, '$[0].report_match_document.filters[0].filter_name' returning varchar2 ) sqls 
	        from DUAL)
    LOOP
      v_filter_name := replace(rec.sqls, '"', '');
      dbms_output.put_line('FILTER = ' || v_filter_name);
    END LOOP;

    -- Capture the filter for the SQL if exists
    v_filter := null;
    for rec in (SELECT JSON_QUERY(v_report_matches, '$[0].report_filter_values.*.value' returning varchar2 ) 
	           filters from DUAL)
    LOOP
      v_filter := replace(rec.filters, '"', '');
      v_filter := substr(v_filter, instr(v_filter, ' ', -1,1)+1);
      dbms_output.put_line('FILTER VALUE ' || v_filter);
    END LOOP;

    DBMS_OUTPUT.PUT_LINE('Search ID : ' || v_search_id);
    DBMS_OUTPUT.PUT_LINE('Report ID : ' || JSON_VALUE(v_report_matches, '$[0].report_id') );
    DBMS_OUTPUT.PUT_LINE('Report (1) : ' || JSON_VALUE(v_report_matches, '$[0].report_title') );
    DBMS_OUTPUT.PUT_LINE('Distance (1) : ' || JSON_VALUE(v_report_matches, '$[0].vector_distance') );
    DBMS_OUTPUT.PUT_LINE('SQL : ' || v_val);
    DBMS_OUTPUT.PUT_LINE('Filter : ' || v_filter);
    DBMS_OUTPUT.PUT_LINE('Report (2) : ' || JSON_VALUE(v_report_matches, '$[1].report_title') );
    DBMS_OUTPUT.PUT_LINE('Distance (2) : ' || JSON_VALUE(v_report_matches, '$[1].vector_distance') );
    DBMS_OUTPUT.PUT_LINE('Report (3) : ' || JSON_VALUE(v_report_matches, '$[2].report_title') );
    DBMS_OUTPUT.PUT_LINE('Distance (3) : ' || JSON_VALUE(v_report_matches, '$[2].vector_distance') );
    DBMS_OUTPUT.PUT_LINE('Report (4) : ' || JSON_VALUE(v_report_matches, '$[3].report_title') );
    DBMS_OUTPUT.PUT_LINE('Distance (4) : ' || JSON_VALUE(v_report_matches, '$[3].vector_distance') );
    DBMS_OUTPUT.PUT_LINE('Report (5) : ' || JSON_VALUE(v_report_matches, '$[4].report_title') );
    DBMS_OUTPUT.PUT_LINE('Distance (5) : ' || JSON_VALUE(v_report_matches, '$[4].vector_distance') );

    if v_val is not null then
      if v_filter is not null then
        dbms_output.put_line('SQL ' || v_val || ' USING ' || v_filter);
	v_val := replace(v_val, ':' ||v_filter_name, '''' || v_filter || '''');
        dbms_output.put_line('SQL ' || v_val );
        OPEN v_cursor FOR v_val;
      else
        OPEN v_cursor FOR v_val;
      end if;
    else
      OPEN v_cursor FOR 'select ''Failed to find report'' from dual';
    end if;
    return v_cursor;
  exception when others then 
    dbms_Output.put_line ( DBMS_UTILITY.FORMAT_ERROR_STACK() );
    dbms_Output.put_line ( DBMS_UTILITY.FORMAT_ERROR_BACKTRACE() );
  end;

  function get_related_reports (p_summ in varchar2, p_module varchar2 default '%') return SYS_REFCURSOR as
    v_cursor     SYS_REFCURSOR;
    v_val varchar2(4000) := null;
    v_report_matches JSON;
    v_search_id varchar2(4512);
    V_QUERY_TEXT			VARCHAR2(4512);
    V_FEEDBACK_RATING		BOOLEAN;
    V_FEEDBACK_COMMENTS		VARCHAR2(4512);
    V_REQUIRED_FEEDBACK_ACTION	VARCHAR2(4512);
    V_FEEDBACK_ACTION_PRIORITY	VARCHAR2(4512);
    V_EXPECTED_REPORT_ID		VARCHAR2(4512);
    V_EXPECTED_DRILLDOWN_ID	VARCHAR2(4512);
    V_SEARCH_TYPE			VARCHAR2(4512);
    V_AUGMENTED_QUERY_TEXT 	VARCHAR2(4512);
    jarr json_array_t;
    jobj json_object_t;
    v_filter varchar2(1024);
  begin
    if p_summ like 'showsql%' then
      v_val := 'select 1 from dual where 1=0';
      OPEN v_cursor FOR v_val;
      return v_cursor;
    end if;

    lang_data_search_pkg.search_from_query(
        p_search_id       => v_search_id,
        p_query           => p_summ,
        p_domain          => 'dbassist'
    );
    lang_data_search_pkg.get_user_search_record(
        p_id      => v_search_id,
        P_QUERY_TEXT			=> V_QUERY_TEXT,
        P_REPORT_MATCHES		=> V_REPORT_MATCHES,
        P_FEEDBACK_RATING		=> V_FEEDBACK_RATING,
        P_FEEDBACK_COMMENTS		=> V_FEEDBACK_COMMENTS,
        P_REQUIRED_FEEDBACK_ACTION	=> V_REQUIRED_FEEDBACK_ACTION,
        P_FEEDBACK_ACTION_PRIORITY	=> V_FEEDBACK_ACTION_PRIORITY,
        P_EXPECTED_REPORT_ID		=> V_EXPECTED_REPORT_ID,
        P_EXPECTED_DRILLDOWN_ID	=> V_EXPECTED_DRILLDOWN_ID,
        P_SEARCH_TYPE			=> V_SEARCH_TYPE,
        P_AUGMENTED_QUERY_TEXT 	=> V_AUGMENTED_QUERY_TEXT
    );

    DBMS_OUTPUT.PUT_LINE('Search ID : ' || v_search_id);
    DBMS_OUTPUT.PUT_LINE('Report ID : ' || JSON_VALUE(v_report_matches, '$[0].report_id') );
    DBMS_OUTPUT.PUT_LINE('Report : ' || JSON_VALUE(v_report_matches, '$[0].report_title') );
    DBMS_OUTPUT.PUT_LINE('SQL : ' || v_val);
    DBMS_OUTPUT.PUT_LINE('Filter : ' || v_filter);
    DBMS_OUTPUT.PUT_LINE('Report (2) : ' || JSON_VALUE(v_report_matches, '$[1].report_title') );
    DBMS_OUTPUT.PUT_LINE('Report (3) : ' || JSON_VALUE(v_report_matches, '$[2].report_title') );
    if JSON_VALUE(v_report_matches, '$[0].report_title') = 'Database status' then
      v_val := 'select ''@ask "show blocked sessions"'' "Related Questions" from dual union '||
               'select ''@ask "list errors in db"'' "Related Questions" from dual union '||
               'select ''@ask "' || JSON_VALUE(v_report_matches, '$[1].report_title') || '"'' "Related Questions" from dual union '||
             'select ''@ask "' || JSON_VALUE(v_report_matches, '$[2].report_title') || '"'' "Related Questions" from dual';
    else
      v_val := 'select ''@ask "' || JSON_VALUE(v_report_matches, '$[1].report_title') || '"'' "Related Questions" from dual union '||
             'select ''@ask "' || JSON_VALUE(v_report_matches, '$[2].report_title') || '"'' "Related Questions" from dual';
    end if;

    OPEN v_cursor FOR v_val;
    return v_cursor;
  exception when others then 
    dbms_Output.put_line ( DBMS_UTILITY.FORMAT_ERROR_STACK() );
    dbms_Output.put_line ( DBMS_UTILITY.FORMAT_ERROR_BACKTRACE() );
  end; -- End get_related_reports function
end;
/
