Rem
Rem $Header: dbgendev/src/langdata/plsql/annotations/annotations_pkg.pks 
Rem saloshah_dbai_327/2 2024/11/13 16:18:26 saloshah Exp $
Rem
Rem annotations_pkg.pls
Rem
Rem Copyright (c) 2024, 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      annotations_pkg.pls - Package specification of annotations_pkg
Rem
Rem    DESCRIPTION
Rem      Specifies the procedures for adding and updating annotations
Rem
Rem    NOTES
Rem      NONE
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/plsql/annotations/
Rem    annotations_pkg.pks
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jiangnhu    06/03/25 - Remove g_disable_triggers
Rem    deveverm    03/11/25 - DBAI-546: added schema_name for cross_schema
Rem                           support
Rem    jiangnhu    03/07/25 - Move re_augmented_affected_texts,
Rem                           update_affected_texts to utils pkg
Rem    jiangnhu    02/14/25 - DBAI-575: Remove c_unknown_exception_code
Rem    jiangnhu    02/03/25 - DBAI-511: Update annotation workflow to both
Rem                           augment/amend queries/descriptions
Rem    jiangnhu    12/19/24 - JIRA_DBAI-383: Remove update_drilldownvalues
Rem    saloshah    12/02/24 - DBAI-439: Added edge cases error handling
Rem    saloshah    11/12/24 - Created
Rem

CREATE OR REPLACE PACKAGE lang_data_annotations_pkg IS
    /*
    ----------------------------------------------------------------------
    Package Name: annotations_pkg
    Description: This package contains procedures and triggers related to 
                 updating annotations for user_tables. The procedures and 
                 triggers are designed to handle updating annotations and 
                 all the related updating operations.
    ----------------------------------------------------------------------
    Author: Saloni Shah
    Created: 11/12/2024
    ----------------------------------------------------------------------
    Public Procedures:
    ----------------------------------------------------------------------

    PROCEDURE update_annotation_values
    ---------------------------------
    Description:
        This procedure updates the annotations of a specific column given
        the table_name and column_name and the annotation_value.

    Parameters:
        - p_table_name (IN VARCHAR2):
            The table_name for which annotation has to be updated.
        - p_column_name (IN VARCHAR2):
            The column_name for which annotation has to be updated.
        - p_annotation_value (IN VARCHAR2):
            The annotation_value to be updated.
        - p_schema_name (IN VARCHAR2):
            The schema_name in which table_name belongs, whose annotation has to be updated

    Exceptions:
        - c_invalid_parameters_code (-20002):
            Raised when the table_name, column_name or annotation_value
            parameters are invalid. 
            Logged as an error before raising.
        - c_max_text_length_exceeded(-20003):
            Raised when annotation value exceeds character limit
    */
    -- Public Procedure to update annotation values
    PROCEDURE update_annotation_values(
        p_table_name      IN VARCHAR2,
        p_column_name     IN VARCHAR2,
        p_annotation_value IN VARCHAR2,
        p_schema_name     IN VARCHAR2
    );
END lang_data_annotations_pkg;
/


