Rem
Rem $Header: dbgendev/src/langdata/install/shrink_tablespace.sql /main/1 2025/03/24 06:20:12 arevathi Exp $
Rem
Rem shrink_tablespace.sql
Rem
Rem Copyright (c) 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      shrink_tablespace.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/install/shrink_tablespace.sql
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    arevathi    03/05/25 - Create shrink Job to release the unused space
Rem    arevathi    03/05/25 - Created
Rem

DEFINE TABLESPACE_NAME = '&1'

CREATE OR REPLACE PROCEDURE shrink_tablespace(p_tablespace_name IN VARCHAR2) IS
    CURSOR ts_cur IS
        SELECT df.tablespace_name, df.file_name, df.bytes/1024/1024 
                AS current_size,
               (SELECT ROUND(SUM(fs.bytes)/1024/1024, 2)
                FROM dba_free_space fs
                WHERE fs.tablespace_name = df.tablespace_name) AS free_space
        FROM dba_data_files df
        WHERE df.tablespace_name = UPPER(p_tablespace_name);
 
    v_new_size NUMBER;
BEGIN
    FOR ts IN ts_cur LOOP
        -- Calculate the new size by subtracting free space
        v_new_size := ts.current_size - ts.free_space;
 
        -- Ensure we do not shrink below the min threshold set by us
        IF v_new_size >= 100 THEN
            BEGIN
                EXECUTE IMMEDIATE 'ALTER DATABASE DATAFILE ''' 
                || ts.file_name || ''' RESIZE ' || v_new_size || 'M';

                DBMS_OUTPUT.PUT_LINE('Shrunk ' || ts.file_name || ' to ' 
                || v_new_size || ' MB');
            EXCEPTION
                WHEN OTHERS THEN
                    DBMS_OUTPUT.PUT_LINE('Error shrinking ' || ts.file_name 
                    || ': ' || SQLERRM);
            END;
        END IF;
    END LOOP;
END shrink_tablespace;
/

BEGIN
    DBMS_SCHEDULER.create_job (
        job_name        => 'SHRINK_TABLESPACE_JOB',
        job_type        => 'PLSQL_BLOCK',
        job_action      => 'BEGIN shrink_tablespaces(&TABLESPACE_NAME); END;',
        start_date      => SYSTIMESTAMP,
        repeat_interval => 'FREQ=DAILY',
        enabled         => TRUE
    );
END;
/