Rem
Rem $Header: dbgendev/src/langdata/install/check_valid_user.sql /main/2 2025/08/05 18:08:25 dadoshi Exp $
Rem
Rem check_valid_user.sql
Rem
Rem Copyright (c) 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      check_valid_user.sql - Helper SQLcl script to validate user credentials
Rem
Rem    DESCRIPTION
Rem      This script takes in username, password, pdb and validates that no 
Rem      user with same user exists and that the password is valid password 
Rem      according to current default policy.
Rem
Rem    NOTES
Rem      Usage: 
Rem         @check_valid_user <username> <password> <pdb_name>
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/install/check_valid_user.sql
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    dadoshi     08/01/25 - Fix validation issue in case of no password 
Rem                           validation
Rem    deveverm    07/01/25 - Created
Rem

-- Accept parameters
DEFINE username = '&1';
DEFINE password = '&2';
DEFINE pdb_name = '&3';

-- Switch to the target PDB
ALTER SESSION SET CONTAINER = &pdb_name;

-- Enable output
SET SERVEROUTPUT ON

DECLARE
    v_verify_function  VARCHAR2(128);
    v_result           BOOLEAN := FALSE;
    v_user_exists      INTEGER := 0;
    v_sql              VARCHAR2(4000);
    v_old_pass         VARCHAR2(200) := NULL;
BEGIN
    -- Check if user already exists
    SELECT COUNT(*)
    INTO v_user_exists
    FROM dba_users
    WHERE username = UPPER('&username');

    -- If user exists, return USER
    IF v_user_exists > 0 THEN
            DBMS_OUTPUT.PUT_LINE('USER');
            RETURN;
    END IF;

        -- Get the password verify function for DEFAULT profile
    SELECT limit
    INTO v_verify_function
    FROM dba_profiles
    WHERE profile = 'DEFAULT' AND resource_name = 'PASSWORD_VERIFY_FUNCTION';

    -- If no verify function, treat password as valid
    IF v_verify_function = 'NULL' THEN
            v_result := TRUE;
    ELSE
            -- Dynamically call the password verify function
            v_sql := '
                DECLARE
                    res BOOLEAN;
                BEGIN
                    res := ' || v_verify_function || '(:1, :2, :3);
                    :4 := res;
                END;';

    EXECUTE IMMEDIATE v_sql
        USING '&username', '&password', v_old_pass, OUT v_result;
    END IF;

        -- Output based on result
        IF v_result THEN
            DBMS_OUTPUT.PUT_LINE('VALID');
    ELSE
            DBMS_OUTPUT.PUT_LINE('INVALID');
    END IF;

EXCEPTION
    WHEN OTHERS THEN
        -- On any error, treat as invalid
        DBMS_OUTPUT.PUT_LINE('INVALID');
END;
/