/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.generator;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.structure.DatabaseObject;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.db.VersionTracker;
import oracle.dbtools.raptor.liquibase.actionlogging.ActionLogTableManager;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.AbstractOracleStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.RunApexScriptStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.RunOracleScriptStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.RunOrdsScriptStatement;
import oracle.dbtools.raptor.liquibase.generator.SchemaGenerator;
import oracle.dbtools.raptor.liquibase.util.DbmsMetaUtils;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.liquibase.util.LiquibaseStringUtils;
import oracle.dbtools.raptor.liquibase.util.QueryUtils;
import oracle.dbtools.util.Logger;

public class MetadataSqlGenerator {
    protected static final String CREATE = "CREATE";
    protected static final String SAME_OBJECT_MESSAGE = "-- object is the same nothing to do";

    private MetadataSqlGenerator() {
    }

    public static Sql[] getCreateSqlPlSql(AbstractOracleStatement statement, Database database) {
        StringBuilder sql = new StringBuilder();
        try {
            if (!("ROLE_GRANT".equals(statement.getObjectType()) || "SYSTEM_GRANT".equals(statement.getObjectType()) || "OBJECT_GRANT".equals(statement.getObjectType()) || "JOB".equals(statement.getObjectType()) || "COMMENT".equals(statement.getObjectType()) || statement.getSource().toUpperCase().substring(0, 15).contains(CREATE) || statement.getSource().toUpperCase().substring(0, 15).contains("ALTER"))) {
                sql.append("CREATE ");
                if (null != statement.getReplaceIfExists() && statement.getReplaceIfExists().booleanValue()) {
                    sql.append("OR REPLACE ");
                }
            }
            sql.append(statement.getSource());
            String outSql = sql.toString();
            if (outSql.contains("END;/")) {
                outSql = outSql.replace("END;/", "END;");
            }
            if (outSql.contains("end;/")) {
                outSql = outSql.replace("end;/", "end;");
            }
            if (outSql.contains("\nALTER")) {
                outSql = outSql.replace("\nALTER", "\n/ \nALTER");
            }
            if (outSql.contains("\nalter")) {
                outSql = outSql.replace("\nalter", "\n/ \nalter");
            }
            if (null != (outSql = MetadataSqlGenerator.metadata_cleanup(statement, outSql, database)) && !outSql.trim().isEmpty()) {
                return new Sql[]{new UnparsedSql(outSql, new DatabaseObject[0])};
            }
            return new Sql[]{new UnparsedSql(SAME_OBJECT_MESSAGE, new DatabaseObject[0])};
        }
        catch (Exception e) {
            Logger.warn(MetadataSqlGenerator.class, (Throwable)e);
            throw e;
        }
    }

    private static String metadata_cleanup(AbstractOracleStatement stmt, String sql, Database database) {
        String schema;
        Executor exec;
        if (null == sql || sql.isEmpty()) {
            return null;
        }
        Object fixed = sql;
        if ("TABLE".equals(stmt.getObjectType())) {
            String[] sqls;
            Object changeMe;
            String[] words;
            fixed = ((String)fixed).replace(",\\s+\\);", ");\n");
            fixed = ((String)fixed).replace("COMPRESS Y ENABLE", "COMPRESS ENABLE");
            String pattern = "TABLESPACE\\s(\\S*)\\s*ALTER";
            Pattern r = Pattern.compile("TABLESPACE\\s(\\S*)\\s*ALTER");
            Matcher m = r.matcher(sql);
            if (m.find() && 3 == (words = ((String)(changeMe = m.group(0))).split("\\s+")).length) {
                changeMe = words[0] + " " + words[1] + ";\n" + words[2];
                fixed = ((String)fixed).replace(m.group(0), (CharSequence)changeMe);
            }
            if (2 == (sqls = sql.split("/")).length) {
                String cs = sqls[0].trim();
                String cs1 = sqls[1].trim();
                if (Pattern.matches("ALTER TABLE\\s\\S*\\sDROP CONSTRAINT.*", cs1) && Pattern.matches("ALTER TABLE\\s\\S*\\sDROP \\(.*", cs)) {
                    fixed = sqls[1] + System.lineSeparator() + "/" + System.lineSeparator() + sqls[0] + System.lineSeparator() + "/" + System.lineSeparator();
                }
            }
        }
        if ("DB_LINK".equals(stmt.getObjectType())) {
            fixed = ((String)fixed).replace("VALUES ':1'", "\"<PASSWORD>\"");
        }
        if ("VIEW".equals(stmt.getObjectType())) {
            fixed = ((String)fixed).replaceAll("(?s)(\\(.+?\"\".+?\\).+?)", "");
        }
        if ("TRIGGER".equals(stmt.getObjectType())) {
            Executor exec2 = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
            fixed = ((String)fixed).replace("END;\\s*ALTER TRIGGER", "END;\n/ALTER TRIGGER");
            if (exec2 instanceof LoggingExecutor && ((String)fixed).trim().endsWith("/")) {
                fixed = ((String)fixed).replaceAll("/\\s*$", "/     \n--");
            }
        }
        boolean no_edition = false;
        Version ver = VersionTracker.getDbVersion((ConnectionIdentifier)DefaultConnectionIdentifier.createIdentifier((Connection)LbUtils.getLbConnection().getUnderlyingConnection()));
        if (0 > ver.compareTo(new Version("13"))) {
            no_edition = true;
        }
        if (no_edition) {
            fixed = ((String)fixed).replace("EDITIONABLE ", "");
        }
        while (((String)fixed).trim().endsWith(";")) {
            fixed = ((String)fixed).substring(0, ((String)fixed).length() - 1);
        }
        if (SchemaGenerator.ddlChangeTypes.containsKey(stmt.getObjectType()) && !((String)fixed).trim().endsWith("/")) {
            fixed = ((String)fixed).concat(";");
        }
        if (("PROCEDURE".equals(stmt.getObjectType()) || "FUNCTION".equals(stmt.getObjectType()) || "PACKAGE_SPEC".equals(stmt.getObjectType()) || "PACKAGE_BODY".equals(stmt.getObjectType())) && (exec = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database)) instanceof LoggingExecutor) {
            fixed = ((String)fixed).trim().endsWith("/") ? ((String)fixed).replaceAll("/\\s*$", "/     \n--") : (String)fixed + "\n/     \n--";
        }
        try {
            schema = LbUtils.getLbConnection().getConnectionUserName();
        }
        catch (Exception e) {
            schema = null;
        }
        String tab = database.getDatabaseChangeLogTableName() + "_ACTIONS";
        String view = database.getDatabaseChangeLogTableName() + "_DETAILS";
        if (null != schema && !schema.isEmpty()) {
            if (tab.equals(stmt.getObjectName())) {
                return ((String)fixed).replace("TABLE \"\".", "TABLE ");
            }
            if (view.equals(stmt.getObjectName())) {
                return ((String)fixed).replace("VIEW \"\".", "VIEW ");
            }
        } else {
            if (tab.equals(stmt.getObjectName())) {
                return fixed;
            }
            if (view.equals(stmt.getObjectName())) {
                return fixed;
            }
        }
        if (null != schema && !Objects.equals(stmt.getOwnerName(), schema)) {
            fixed = ((String)fixed).replaceAll("(\"?)" + stmt.getOwnerName() + "(\"?)(\\.\"?" + stmt.getObjectName() + "\"?)", "$1%USER_NAME%$2$3");
        }
        return fixed;
    }

    public static Sql[] getCreateSqlSxml(AbstractOracleStatement stmt, Database database) throws Exception {
        try {
            String sql;
            Connection conn = LbUtils.getLbConnection().getUnderlyingConnection();
            String oName = stmt.getObjectName();
            String oType = stmt.getObjectType();
            String destXml = stmt.getSource();
            boolean exists = QueryUtils.doesObjectExist(conn, oName, oType, LbUtils.getUserSchema(stmt.getOwnerName(), database.getDefaultSchemaName()));
            if (!"VIEW".equalsIgnoreCase(oType) && exists) {
                String sourceXml = DbmsMetaUtils.getSxmlFromDb(conn, stmt.getObjectType(), stmt.getObjectName());
                sql = DbmsMetaUtils.getAlterDdl(conn, sourceXml, destXml, stmt.getObjectType());
                Pattern p = Pattern.compile("(?s)^--\\s(ORA-[1-9][1-9][1-9][1-9][1-9]):\\s(.*)/");
                Matcher m = p.matcher(Objects.requireNonNullElse(sql, ""));
                if (m.find()) {
                    String err = m.group(1);
                    String msg = m.group(2);
                    throw new SQLException(msg, err);
                }
                if (sql == null) {
                    sql = "-- Objects are the the same, no work to do";
                }
            } else {
                sql = DbmsMetaUtils.getDdlFromXmlorSxml(conn, destXml, oType, "sxml");
            }
            sql = MetadataSqlGenerator.metadata_cleanup(stmt, sql, database);
            if (null == sql || sql.isEmpty()) {
                sql = SAME_OBJECT_MESSAGE;
            }
            sql = LiquibaseStringUtils.trimEndofSql(sql);
            return new Sql[]{new UnparsedSql(sql, new DatabaseObject[0])};
        }
        catch (Exception e) {
            Logger.warn(MetadataSqlGenerator.class, (Throwable)LbUtils.getRoot(e));
            throw LbUtils.getRoot(e);
        }
    }

    public static Sql[] getDropSqlPlSql(AbstractOracleStatement statement, Database database) throws SQLException, IOException, DatabaseException {
        String oName = null;
        StringBuilder sql = new StringBuilder();
        if (statement instanceof RunOracleScriptStatement || statement instanceof RunApexScriptStatement || statement instanceof RunOrdsScriptStatement) {
            return new Sql[0];
        }
        try {
            String outSql;
            String action;
            if (null != statement.getObjectName() && !"%OBJECT_NAME%".equals(statement.getObjectName())) {
                oName = statement.getObjectName();
            }
            if (null == (action = MetadataSqlGenerator.getAction(statement, database)) || action.isEmpty()) {
                if ("JOB".equals(statement.getObjectType())) {
                    String subType = QueryUtils.getSchedulerObjectType(oName, database);
                    if (null != subType) {
                        sql.append("BEGIN DBMS_SCHEDULER.drop_").append(subType.toLowerCase()).append(" (").append(subType.toLowerCase()).append("_name => '").append(oName).append("' ,FORCE=>TRUE); end;");
                    }
                } else if ("COMMENT".equals(statement.getObjectType())) {
                    if (null != statement.getSource()) {
                        sql.append(LiquibaseStringUtils.trimEndofSql(statement.getSource().replaceAll("'.*'", "''")));
                    }
                } else if ("REFCONSTRAINT".equalsIgnoreCase(statement.getObjectType())) {
                    String dropsql = statement.getSource();
                    if (null != dropsql) {
                        dropsql = dropsql.replace("ADD", "DROP");
                        int loc = dropsql.indexOf("FOREIGN KEY");
                        sql.append(dropsql, 0, loc - 1);
                    }
                } else if ("GRANT".equalsIgnoreCase(statement.getObjectType())) {
                    String dropsql = statement.getSource();
                    if (null != dropsql) {
                        dropsql = dropsql.replace("GRANT", "REVOKE");
                        dropsql = dropsql.replace("TO", "FROM");
                        sql.append(dropsql);
                    }
                } else {
                    sql.append(MetadataSqlGenerator.getDrop(statement, database));
                }
                outSql = sql.toString();
            } else if ("DB_LINK".equals(statement.getObjectType())) {
                outSql = null;
            } else {
                if (Boolean.TRUE.equals(statement.getReplaceIfExists()) && !action.toUpperCase().contains("CREATE OR REPLACE")) {
                    action = action.replace(CREATE, "CREATE OR REPLACE");
                }
                action = MetadataSqlGenerator.metadata_cleanup(statement, action, database);
                sql.append(action);
                outSql = sql.toString();
            }
            if (null == outSql || "null".equals(outSql)) {
                return new Sql[]{new UnparsedSql(SAME_OBJECT_MESSAGE, new DatabaseObject[0])};
            }
            return new Sql[]{new UnparsedSql(outSql, new DatabaseObject[0])};
        }
        catch (Exception e) {
            Logger.warn(MetadataSqlGenerator.class, (Throwable)e);
            throw e;
        }
    }

    private static String getDrop(AbstractOracleStatement statement, Database database) {
        if (!(database instanceof OracleDatabase)) {
            return null;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("DROP ");
        if (SchemaGenerator.typeNameTransform.containsKey(statement.getObjectType())) {
            sql.append(SchemaGenerator.typeNameTransform.get(statement.getObjectType())).append(" ");
        } else {
            sql.append(statement.getObjectType()).append(" ");
        }
        sql.append("\"").append("%USER_NAME%").append("\".");
        sql.append("\"").append(statement.getObjectName()).append("\"");
        if ("TABLE".equals(statement.getObjectType())) {
            sql.append(" CASCADE CONSTRAINTS");
        }
        return sql.toString();
    }

    public static Sql[] getDropSqlSxml(AbstractOracleStatement statement, Database database) throws SQLException, IOException, DatabaseException {
        StringBuilder sql = new StringBuilder();
        try {
            String outSql;
            Connection conn = ((JdbcConnection)database.getConnection()).getUnderlyingConnection();
            String oType = statement.getObjectType();
            if ("MATERIALIZED_VIEW_LOG".equals(oType)) {
                String create = DbmsMetaUtils.getDdlFromXmlorSxml(conn, statement.getSource(), statement.getObjectType(), "sxml");
                if (create == null) {
                    throw new DatabaseException("Unable top produce drop sql;");
                }
                String drop = create.replace(CREATE, "DROP");
                int loc = LiquibaseStringUtils.nthOccurrence(drop, '\"', 4);
                outSql = drop = drop.substring(0, loc + 1);
            } else {
                String destXml = DbmsMetaUtils.getDdlFromDb(((JdbcConnection)database.getConnection()).getUnderlyingConnection(), statement.getObjectType(), statement.getObjectName());
                String logSxml = MetadataSqlGenerator.getAction(statement, database);
                if (null == logSxml || logSxml.trim().isEmpty()) {
                    sql.append(MetadataSqlGenerator.getDrop(statement, database));
                } else {
                    String sourceXml = logSxml;
                    sql.append(DbmsMetaUtils.getAlterDdl(conn, destXml, sourceXml, statement.getObjectType()));
                }
                outSql = MetadataSqlGenerator.metadata_cleanup(statement, sql.toString(), database);
            }
            if (null == outSql || "null".equals(outSql)) {
                return new Sql[]{new UnparsedSql(SAME_OBJECT_MESSAGE, new DatabaseObject[0])};
            }
            return new Sql[]{new UnparsedSql(outSql, new DatabaseObject[0])};
        }
        catch (Exception e) {
            Logger.warn(MetadataSqlGenerator.class, (Throwable)e);
            throw e;
        }
    }

    private static String getAction(AbstractOracleStatement statement, Database database) throws DatabaseException, SQLException, IOException {
        ActionLogTableManager tm = new ActionLogTableManager(database);
        return tm.getActionFromActionLog(statement.getId(), statement.getAuthor(), statement.getFile());
    }
}

