/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.ext.ora.change;

import com.google.common.base.Throwables;
import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.CheckSum;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.statement.SqlStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.change.AbstractCommonPlSqlChange;
import oracle.dbtools.raptor.liquibase.ext.ora.change.AbstractOracleChange;
import oracle.dbtools.raptor.liquibase.ext.ora.generator.RunInternalScriptGenerator;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.RunOracleScriptStatement;
import oracle.dbtools.util.Logger;

@DatabaseChange(name="runOracleScript", description="Run Oracle Script", priority=1)
public class RunOracleScriptChange
extends AbstractCommonPlSqlChange {
    public RunOracleScriptChange() {
        this.setObjectType("SCRIPT");
    }

    public RunOracleScriptChange(AbstractOracleChange change) {
        super(change);
        this.setObjectType("SCRIPT");
    }

    protected Change[] createInverses() {
        return null;
    }

    public SqlStatement[] generateStatements(Database database) {
        RunOracleScriptStatement stmt = new RunOracleScriptStatement(this);
        return new SqlStatement[]{stmt};
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Script executed successfully {0}", this.getObjectName());
    }

    public boolean supportsRollback(Database database) {
        return false;
    }

    public CheckSum generateCheckSum() {
        try {
            RunInternalScriptGenerator generator = new RunInternalScriptGenerator();
            String sql = generator.getSqlString(this);
            return CheckSum.compute((String)sql);
        }
        catch (LiquibaseException e) {
            Logger.warn(RunOracleScriptChange.class, (Throwable)e);
            throw new RuntimeException(Throwables.getStackTraceAsString((Throwable)e));
        }
    }
}

