/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.ext.ora.change;

import liquibase.Scope;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.sql.Sql;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RuntimeStatement;
import liquibase.util.StringUtil;
import oracle.dbtools.raptor.liquibase.util.LbUtils;

@DatabaseChange(name="output", description="Logs a message and continues execution.", priority=1000)
public class OutputChange
extends AbstractChange {
    private String message;
    private String target;

    public ValidationErrors validate(Database database) {
        ValidationErrors validate = new ValidationErrors((Change)this);
        validate.checkRequiredField("message", (Object)this.getMessage());
        return validate;
    }

    @DatabaseChangeProperty(description="Message to send to output", exampleValue="Make sure you feed the cat", serializationType=LiquibaseSerializable.SerializationType.DIRECT_VALUE)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = StringUtil.trimToNull((String)message);
    }

    protected Change[] createInverses() {
        return EMPTY_CHANGE;
    }

    public Object getSerializableFieldValue(String field) {
        Object value = super.getSerializableFieldValue(field);
        if ("target".equals(field) && "".equals(value)) {
            return null;
        }
        return value;
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog-ext";
    }

    public String getConfirmationMessage() {
        return "Output: " + this.getMessage();
    }

    private void write() {
        if (LbUtils.getContext() != null && LbUtils.getContext().getOutputStream() != null) {
            LbUtils.getContext().consumerRuning(true);
            LbUtils.getContext().writeln(this.getMessage());
        } else {
            Scope.getCurrentScope().getUI().sendMessage(this.getMessage());
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("output buffer or context not set outputing thru liquibase scope");
        }
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new RuntimeStatement(){

            public Sql[] generate(Database database) {
                if (OutputChange.this.target == null) {
                    OutputChange.this.target = "SQLCL";
                }
                if ("STDOUT".equalsIgnoreCase(OutputChange.this.target)) {
                    OutputChange.this.write();
                } else if ("STDERR".equalsIgnoreCase(OutputChange.this.target)) {
                    OutputChange.this.write();
                } else if ("SQLCL".equalsIgnoreCase(OutputChange.this.target)) {
                    OutputChange.this.write();
                } else if ("DEBUG".equalsIgnoreCase(OutputChange.this.target)) {
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).fine(OutputChange.this.getMessage());
                } else if ("INFO".equalsIgnoreCase(OutputChange.this.target)) {
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info(OutputChange.this.getMessage());
                } else if ("WARN".equalsIgnoreCase(OutputChange.this.target) || "WARNING".equalsIgnoreCase(OutputChange.this.target)) {
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning(OutputChange.this.getMessage());
                } else if ("SEVERE".equalsIgnoreCase(OutputChange.this.target) || "FATAL".equalsIgnoreCase(OutputChange.this.target) || "ERROR".equalsIgnoreCase(OutputChange.this.target)) {
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).severe(OutputChange.this.getMessage());
                } else {
                    throw new UnexpectedLiquibaseException("Unknown target: " + OutputChange.this.target);
                }
                return null;
            }
        }};
    }

    public boolean supports(Database database) {
        return super.supports(database);
    }

    @DatabaseChangeProperty(description="Target for message. Possible values: SQLCL, STDOUT, STDERR, FATAL, WARN, INFO, DEBUG. Default: SQLCL", exampleValue="SQLCL")
    public String getTarget() {
        if (this.target == null) {
            return "SQLCL";
        }
        return this.target;
    }

    public void setTarget(String target) {
        this.target = StringUtil.trimToNull((String)target);
    }
}

