/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.ext.ora.change;

import java.nio.file.Paths;
import java.util.Objects;
import liquibase.change.AbstractChange;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import lombok.Generated;
import oracle.dbtools.raptor.liquibase.util.LbFileUtils;

public abstract class AbstractOracleChange
extends AbstractChange {
    private Boolean replaceIfExists = false;
    private String sourceType = null;
    private String objectName = null;
    private String objectType = null;
    private String ownerName = null;
    private String source = null;
    private String id = null;
    private String author = null;
    private String file = null;
    private String relativeToChangelogFile = null;

    AbstractOracleChange() {
    }

    AbstractOracleChange(AbstractOracleChange change) {
        this.id = change.getId();
        this.author = change.getAuthor();
        if (change.getFile() != null) {
            this.file = LbFileUtils.cleanPath(Paths.get(change.getFile(), new String[0]).normalize().toString());
        }
        this.replaceIfExists = change.getReplaceIfExists();
        this.sourceType = change.getSourceType();
        this.objectName = change.getObjectName();
        this.objectType = change.getObjectType();
        this.ownerName = change.getOwnerName();
        this.source = change.getSource();
        this.relativeToChangelogFile = change.getRelativeToChangelogFile();
        super.setChangeSet(change.getChangeSet());
    }

    public String getFile() {
        return LbFileUtils.cleanPath(this.file);
    }

    public void setFile(String file) {
        this.file = LbFileUtils.cleanPath(Paths.get(file, new String[0]).normalize().toString());
    }

    public void setReplaceIfExists(String replace) {
        this.replaceIfExists = Boolean.parseBoolean(replace);
    }

    public boolean supports(Database database) {
        return database instanceof OracleDatabase;
    }

    public String getRelativeToChangelogFile() {
        return Objects.requireNonNullElse(this.relativeToChangelogFile, "false");
    }

    public void setChangeSet(ChangeSet changeSet) {
        if (changeSet.getFilePath() != null) {
            changeSet.setFilePath(Paths.get(changeSet.getFilePath(), new String[0]).normalize().toString());
        }
        super.setChangeSet(changeSet);
    }

    @Generated
    public Boolean getReplaceIfExists() {
        return this.replaceIfExists;
    }

    @Generated
    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    @Generated
    public String getSourceType() {
        return this.sourceType;
    }

    @Generated
    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    @Generated
    public String getObjectName() {
        return this.objectName;
    }

    @Generated
    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    @Generated
    public String getObjectType() {
        return this.objectType;
    }

    @Generated
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    @Generated
    public String getOwnerName() {
        return this.ownerName;
    }

    @Generated
    public void setSource(String source) {
        this.source = source;
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public String getAuthor() {
        return this.author;
    }

    @Generated
    public void setAuthor(String author) {
        this.author = author;
    }

    @Generated
    public void setRelativeToChangelogFile(String relativeToChangelogFile) {
        this.relativeToChangelogFile = relativeToChangelogFile;
    }
}

