/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.diff.output.changelog.orcl;

import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.AbstractChangeGenerator;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.ChangedObjectChangeGenerator;
import liquibase.diff.output.changelog.MissingObjectChangeGenerator;
import liquibase.diff.output.changelog.UnexpectedObjectChangeGenerator;
import liquibase.structure.DatabaseObject;
import oracle.dbtools.raptor.liquibase.ext.ora.change.CreateOracleSxmlChange;
import oracle.dbtools.raptor.liquibase.ext.ora.change.DropOracleSxmlChange;
import oracle.dbtools.raptor.liquibase.structure.orcl.OrclTable;

public class OrclTableChangeGenerator
extends AbstractChangeGenerator
implements MissingObjectChangeGenerator,
ChangedObjectChangeGenerator,
UnexpectedObjectChangeGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (OrclTable.class.isAssignableFrom(objectType)) {
            return 1;
        }
        return -1;
    }

    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return null;
    }

    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return null;
    }

    public Change[] fixMissing(DatabaseObject missingObject, DiffOutputControl control, Database referenceDatabase, Database comparisionDatabase, ChangeGeneratorChain chain) {
        OrclTable tab = (OrclTable)missingObject;
        CreateOracleSxmlChange change = new CreateOracleSxmlChange();
        change.setObjectName(tab.getName());
        change.setObjectType("TABLE ");
        change.setOwnerName(referenceDatabase.getDefaultSchemaName());
        change.setSource(tab.getSxml());
        return new Change[]{change};
    }

    public Change[] fixUnexpected(DatabaseObject unexpectedObject, DiffOutputControl control, Database referenceDatabase, Database comparisionDatabase, ChangeGeneratorChain chain) {
        OrclTable tab = (OrclTable)unexpectedObject;
        DropOracleSxmlChange change = new DropOracleSxmlChange();
        change.setObjectName(tab.getName());
        change.setObjectType(null);
        change.setOwnerName(referenceDatabase.getDefaultSchemaName());
        change.setSource(tab.getSxml());
        return new Change[]{change};
    }

    public Change[] fixChanged(DatabaseObject changedObject, ObjectDifferences differences, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        OrclTable tab = (OrclTable)changedObject;
        CreateOracleSxmlChange change = new CreateOracleSxmlChange();
        change.setObjectName(tab.getName());
        change.setObjectType("TABLE");
        change.setOwnerName(referenceDatabase.getDefaultSchemaName());
        change.setSource(tab.getSxml());
        return new Change[]{change};
    }
}

