/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.core;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import liquibase.exception.LiquibaseException;
import oracle.dbtools.extension.apex.command.ApexOptions;
import oracle.dbtools.extension.apex.command.MutableCommand;
import oracle.dbtools.extension.apex.core.APEXExport;
import oracle.dbtools.raptor.liquibase.actionlogging.ActionLogTableManager;
import oracle.dbtools.raptor.liquibase.core.ActiveCommand;
import oracle.dbtools.raptor.liquibase.generator.SchemaGenerator;
import oracle.dbtools.raptor.liquibase.generator.changesets.data.ChangeData;
import oracle.dbtools.raptor.liquibase.util.ApexUtils;
import oracle.dbtools.raptor.liquibase.util.LbFileUtils;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LBOptions;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.Messages;
import org.apache.commons.io.FileUtils;

public class CommandGenerator {
    private CommandGenerator() {
    }

    public static void calculateCheckSumCommand() throws Exception {
        LbUtils.getCommand().runCommand();
        LbUtils.getContext().getOutputStream().flush();
    }

    public static void changeLogSyncCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void changeLogSyncSqlCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    private static void setupOutFileRun() throws Exception {
        String outFile = (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.OUTPUT_FILE);
        if (null != outFile && !outFile.isEmpty()) {
            outFile = LbFileUtils.getFileString((Boolean)LbUtils.getCommand().getOptionValue(LBOptions.Options.OVERWRITE_OUTPUT_FILE), outFile);
            FileOutputStream writer = new FileOutputStream(outFile);
            LbUtils.getCommand().getCommandScope().setOutput((OutputStream)writer);
            LbUtils.getCommand().runCommand();
            try {
                writer.flush();
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LbUtils.getContext().write(Messages.format("FILE_GENERATED", outFile));
        } else {
            LbUtils.getCommand().runCommand();
        }
    }

    public static void changeLogSyncToTagCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void changeLogSyncToTagSqlCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void clearCheckSumsCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void dataCommand() throws Exception {
        String outputDir = (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.DATA_OUTPUT_DIRECTORY);
        if (null != outputDir && !outputDir.isEmpty()) {
            File directory = new File(outputDir);
            if (!directory.isAbsolute()) {
                directory = new File(LbUtils.getCWD(), outputDir);
            }
            String absolutePath = directory.getCanonicalFile().getPath();
            if (!directory.exists()) {
                if (!directory.mkdirs()) {
                    throw new Exception(Messages.format("LB_DATA_OUTPUT_DIRECTORY_CREATION_FAILED", absolutePath));
                }
            } else if (!directory.isDirectory()) {
                throw new Exception(Messages.format("LB_DATA_OUTPUT_DIRECTORY_NOT_A_DIRECTORY", absolutePath));
            }
            LbUtils.getCommand().setOptionValue(LBOptions.Options.DATA_OUTPUT_DIRECTORY, absolutePath);
            LbUtils.getCommand().getCommandScope().addArgumentValue("dataOutputDirectory", (Object)absolutePath);
        }
        CommandGenerator.setupOutFileRun();
    }

    public static void dbDocCommand() throws LiquibaseException {
        String outputDir = (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.OUTPUT_DIRECTORY);
        File directory = new File(outputDir);
        if (!directory.isAbsolute()) {
            directory = new File(LbUtils.getCWD(), outputDir);
        }
        String absolutePath = directory.getAbsolutePath();
        if (!directory.exists()) {
            if (!directory.mkdirs()) {
                throw new LiquibaseException(Messages.format("LB_DBDOC_DIRECTORY_CREATION_FAILED", absolutePath));
            }
        } else if (!directory.isDirectory()) {
            throw new LiquibaseException(Messages.format("LB_DBDOC_NOT_A_DIRECTORY", absolutePath));
        }
        LbUtils.getCommand().setOptionValue(LBOptions.Options.OUTPUT_DIRECTORY, absolutePath);
        LbUtils.getCommand().getCommandScope().addArgumentValue("outputDirectory", (Object)absolutePath);
        LbUtils.getCommand().runCommand();
    }

    public static void diffChangelogCommand() throws Exception {
        String diffChangelogFile = (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.CHANGELOG_FILE);
        if (null != diffChangelogFile && !diffChangelogFile.isEmpty()) {
            File ChangeLogFile = new File(diffChangelogFile);
            if (!ChangeLogFile.isAbsolute()) {
                ChangeLogFile = new File(LbUtils.getCWD(), diffChangelogFile);
            }
            String absolutePath = ChangeLogFile.getCanonicalFile().getPath();
            LbUtils.getCommand().setOptionValue(LBOptions.Options.CHANGELOG_FILE, absolutePath);
            LbUtils.getCommand().getCommandScope().addArgumentValue("changelogFile", (Object)absolutePath);
            LbUtils.getCommand().runCommand();
            if (ChangeLogFile.getCanonicalFile().exists() && ChangeLogFile.getCanonicalFile().isFile()) {
                LbUtils.getContext().write(Messages.format("FILE_GENERATED", absolutePath));
            } else {
                LbUtils.getContext().write(Messages.format("LB_DIFF_CHANGELOG_FILE_NOT_GENERATED_NO_DIFFS", new Object[0]));
            }
        }
    }

    public static void diffCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void dropAllCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void futureRollbackCountSqlCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void futureRollbackSqlCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void futureRollbackTagSqlCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void generateChangelogCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void listLocksCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void markNextChangesetRanCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void markNextChangesetRanSqlCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void releaseLocksCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void rollbackCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void rollbackSqlCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void rollbackCountCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void rollbackCountSqlCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void rollbackToDateCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void rollbackToDateSqlCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void setCommand(ParsedCommand command) throws IOException {
        String name = (String)command.getParameterValue((Id)LBOptions.Options.PARAMETER);
        String value = (String)command.getParameterValue((Id)LBOptions.Options.VALUE);
        List<String> pList = Arrays.asList("ON", "OFF");
        List<String> engines = Arrays.asList("JDBC", "SQLCL");
        List<String> parms = Arrays.asList(LBOptions.parameters);
        if ("RESET".equalsIgnoreCase(name) && "ON".equalsIgnoreCase(value)) {
            LbUtils.resetParameters();
        } else if ("ENGINE".equalsIgnoreCase(name) && engines.contains(value)) {
            LbUtils.setParameter(name.toUpperCase(), value);
        } else if ("ENGINE".equalsIgnoreCase(name) && !engines.contains(value)) {
            LbUtils.getContext().writeln("Invalid value for ENGINE must be JDBC or SQLCL");
        } else if (parms.contains(name) && pList.contains(value)) {
            LbUtils.setParameter(name.toUpperCase(), value);
        } else if (parms.contains(name) && !pList.contains(value)) {
            LbUtils.getContext().writeln("Invalid value for " + name.toUpperCase() + " must be ON or OFF");
        } else {
            LbUtils.getContext().writeln("Invalid parameter was specified");
        }
    }

    public static void showCommand() throws IOException {
        LbUtils.showParameters();
    }

    public static void snapShotCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void snapShotReferenceCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void statusCommand() throws Exception {
        LbUtils.getCommand().addArgumentValue("VERBOSE", true);
        LbUtils.getCommand().runCommand();
    }

    public static void tagCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void tagExistsCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void unexpectedChangessetsCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void updateCommand() throws Exception {
        ActionLogTableManager tm = new ActionLogTableManager(LbUtils.getCommand().getDb());
        tm.createUpdateLogTable();
        LbUtils.getCommand().runCommand();
    }

    public static void updateSqlCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void updateCountCommand() throws Exception {
        CommandGenerator.updateCommand();
    }

    public static void updateCountSqlCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void updateTestingRollbackCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void updateToTagCommand() throws Exception {
        CommandGenerator.updateCommand();
    }

    public static void updateToTagSqlCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void validateCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void historyCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static String generateApexObjectCommand(Connection conn) throws Exception {
        Map<String, APEXExport.RowDetails> changes = CommandGenerator.getApexChangeLogsOrApexList(LbUtils.getCommand(), conn);
        if (LbUtils.getCommand().getOptionValue(LBOptions.Options.LIST).equals(true) && changes.isEmpty()) {
            return null;
        }
        if (null == changes || changes.isEmpty()) {
            LbUtils.getContext().write(Messages.format("NO_APEX", new Object[0]));
            return null;
        }
        LinkedList<APEXExport.RowDetails> installFiles = new LinkedList<APEXExport.RowDetails>();
        for (Map.Entry<String, APEXExport.RowDetails> entry : changes.entrySet()) {
            String fileName;
            File file;
            String key = entry.getKey();
            APEXExport.RowDetails curRow = entry.getValue();
            if (key.equals("screenoutput.log")) continue;
            if (null != LbUtils.getCommand().getOptionValue((Id)ApexOptions.Symbol.DIR) && !LbUtils.getCommand().getOptionValue((Id)ApexOptions.Symbol.DIR).toString().isEmpty()) {
                file = Paths.get((String)LbUtils.getCommand().getOptionValue((Id)ApexOptions.Symbol.DIR), key).toFile();
                fileName = key;
            } else {
                file = Paths.get(key, new String[0]).toFile();
                fileName = file.toString();
            }
            LbFileUtils.writeFile(file.toString(), entry.getValue().getContents());
            if (!fileName.startsWith("f") || !fileName.endsWith(".sql")) continue;
            if (fileName.contains("/") || fileName.contains("\\")) {
                int slashorbackslash = -1;
                if (fileName.contains("/")) {
                    slashorbackslash = fileName.indexOf(47);
                } else if (fileName.contains("\\")) {
                    slashorbackslash = fileName.indexOf(92);
                }
                String digits = fileName.substring(1, slashorbackslash);
                String installFile = fileName.substring(slashorbackslash + 1);
                if (!installFile.equals("install.sql") || digits.isEmpty() || !digits.chars().allMatch(Character::isDigit)) continue;
                installFiles.add(curRow);
                continue;
            }
            String digits = fileName.substring(1, fileName.length() - 4);
            if (digits.isEmpty() || !digits.chars().allMatch(Character::isDigit)) continue;
            installFiles.add(curRow);
        }
        return Messages.format("FILE_GENERATED", LbFileUtils.writeApexInstallFile("apex_install.xml", ApexUtils.genApexController(installFiles, conn)));
    }

    private static Map<String, APEXExport.RowDetails> getApexChangeLogsOrApexList(ActiveCommand command, Connection conn) throws Exception {
        MutableCommand mutableCommand = new MutableCommand(command.getParsedCommand());
        APEXExport apexExport = new APEXExport(mutableCommand, LbUtils.getContext(), conn, true);
        if (((Boolean)LbUtils.getCommand().getOptionValue(LBOptions.Options.LIST)).booleanValue()) {
            apexExport.list();
            return new LinkedHashMap<String, APEXExport.RowDetails>();
        }
        apexExport.doCapture();
        return apexExport.getResults();
    }

    public static void generateControlFileCommand() throws Exception {
        Path path = LbFileUtils.getPath((Boolean)LbUtils.getCommand().getOptionValue(LBOptions.Options.OVERWRITE_OUTPUT_FILE), (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.OUTPUT_FILE));
        SchemaGenerator.writeMasterLog(path);
        LbUtils.getContext().write(Messages.format("CONTROLLER_CREATED", path.toString()));
    }

    public static String generateDbObjectCommand() throws LiquibaseException {
        ChangeData data = null;
        try {
            SchemaGenerator gen = new SchemaGenerator();
            data = new ChangeData(LbUtils.getCommand());
            String change = gen.getChangeLog(data);
            data.setCHANGELOG(change);
            LbFileUtils.writeFile(data);
            if (data.isSQL()) {
                LbFileUtils.writeSqlFile(data, LbUtils.getLbConnection().getUnderlyingConnection());
            }
            return data.getFILENAME();
        }
        catch (Exception e) {
            if (data != null) {
                FileUtils.deleteQuietly((File)data.getFILE());
            }
            throw new LiquibaseException(Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    public static String generateOrdsModuleCommand() throws LiquibaseException {
        String file = null;
        try {
            SchemaGenerator gen = new SchemaGenerator();
            String change = gen.getOrdsModuleChangeLog();
            if (null == change || change.isEmpty()) {
                return null;
            }
            String module = (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.MODULE_NAME);
            String fileName = "ords_rest_module_" + module.toLowerCase() + ".xml";
            file = LbFileUtils.writeFile(fileName, change);
            return Messages.format("FILE_GENERATED", CommandGenerator.cleanFileName(file));
        }
        catch (Exception e) {
            Path path;
            if (file != null && (path = Paths.get(file, new String[0])).toFile().exists()) {
                FileUtils.deleteQuietly((File)path.toFile());
            }
            throw new LiquibaseException(Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private static String cleanFileName(String file) {
        String cleanFileName = file;
        if (file.contains(LbUtils.getCWD())) {
            cleanFileName = file.replace(LbUtils.getCWD(), "");
            cleanFileName = cleanFileName.substring(1);
        }
        return cleanFileName.replace("\\", "/");
    }

    public static String generateOrdsSchemaCommand() throws Exception {
        String file = null;
        try {
            SchemaGenerator gen = new SchemaGenerator();
            String change = gen.getOrdsSchemaChangeLog();
            if (null == change || change.isEmpty()) {
                return null;
            }
            String fileName = "ords_rest_schema.xml";
            file = LbFileUtils.writeFile("ords_rest_schema.xml", change);
            return Messages.format("FILE_GENERATED", CommandGenerator.cleanFileName(file));
        }
        catch (Exception e) {
            Path path;
            if (file != null && (path = Paths.get(file, new String[0])).toFile().exists()) {
                FileUtils.deleteQuietly((File)path.toFile());
            }
            throw new LiquibaseException(Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    public static void generateSchemaCommand() throws Exception {
        SchemaGenerator gen = new SchemaGenerator();
        gen.doSchemaExport(true);
    }
}

