/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.actionlogging;

import java.io.IOException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.change.core.RawSQLChange;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.statement.SqlStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.change.CreateInternalSxmlChange;
import oracle.dbtools.raptor.liquibase.ext.ora.change.RunInternalScriptChange;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.AbstractOracleStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.RollbackOraclePlSqlStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.RollbackOracleSxmlStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.RunApexScriptStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.RunOracleScriptStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.RunOrdsScriptStatement;
import oracle.dbtools.raptor.liquibase.util.DbmsMetaUtils;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.liquibase.util.LiquibaseStringUtils;
import oracle.dbtools.raptor.liquibase.util.QueryUtils;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LBOptions;
import oracle.dbtools.util.Logger;

public class ActionLogTableManager {
    protected static final String DATABASECHANGELOG = "%DATABASECHANGELOG%";
    final String schema;
    private final CreateInternalSxmlChange CreateorUpdateLogTableChange = new CreateInternalSxmlChange();
    private final RunInternalScriptChange CreateorUpdateLogTableTriggerChange = new RunInternalScriptChange();
    private final RunInternalScriptChange UpdateLogDataChange = new RunInternalScriptChange();
    private final RunInternalScriptChange CreatePkChange = new RunInternalScriptChange();
    private final CreateInternalSxmlChange CreateorUpdateLogViewChange = new CreateInternalSxmlChange();
    private final String baseName;
    private final Database database;
    private final String addLogRecordComment;
    private final String MergeSqlv1;
    private final String MergeSqlv2a;
    private final String MergeSqlv2b;
    private boolean skip = false;

    public ActionLogTableManager(Database database) throws DatabaseException {
        this.database = database;
        this.baseName = database.getDatabaseChangeLogTableName();
        this.schema = this.getLiquibaseSchema(database);
        this.addLogRecordComment = "-- Logging Oracle Liquibase Extension actions to " + this.schema + "." + this.baseName + "_ACTIONS";
        this.MergeSqlv1 = "MERGE INTO " + this.schema + "." + this.baseName + "_ACTIONS tt USING " + this.schema + "." + this.baseName + " st ON ( tt.id = st.id )\r\nWHEN MATCHED THEN UPDATE SET tt.author = st.author,tt.filename = st.filename where tt.author is null or tt.filename is null;";
        this.MergeSqlv2a = "update " + this.schema + "." + this.baseName + "_ACTIONS SET status = 'SKIPPED' where sql is null or DBMS_LOB.SUBSTR(sql,9) = '--skipped';";
        this.MergeSqlv2b = "update " + this.schema + "." + this.baseName + "_ACTIONS SET status = 'RAN' where sql is not null and  DBMS_LOB.SUBSTR(sql,9) != '--skipped';";
        String LogTriggerSource = this.getLogTriggerSource();
        String LogViewsource = this.getLogViewsource();
        Object LogTableSource = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><TABLE xmlns=\"http://xmlns.oracle.com/ku\" version=\"1.0\">\r\n";
        LogTableSource = (String)LogTableSource + "   <SCHEMA>" + this.schema + "</SCHEMA>\n";
        LogTableSource = (String)LogTableSource + "   <NAME>%DATABASECHANGELOG%_ACTIONS</NAME>\r\n   <RELATIONAL_TABLE>\r\n      <COL_LIST>\r\n         <COL_LIST_ITEM>\r\n            <NAME>ID</NAME>\r\n            <DATATYPE>VARCHAR2</DATATYPE>\r\n            <LENGTH>255</LENGTH>\r\n            <NOT_NULL/>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>SEQUENCE</NAME>\r\n            <DATATYPE>NUMBER</DATATYPE>\r\n            <NOT_NULL/>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>SQL</NAME>\r\n            <DATATYPE>CLOB</DATATYPE>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>SXML</NAME>\r\n            <DATATYPE>CLOB</DATATYPE>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>AUTHOR</NAME>\r\n            <DATATYPE>VARCHAR2</DATATYPE>\r\n            <LENGTH>255</LENGTH>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>FILENAME</NAME>\r\n            <DATATYPE>VARCHAR2</DATATYPE>\r\n            <LENGTH>255</LENGTH>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>DEPLOYMENT_ID</NAME>\r\n            <DATATYPE>VARCHAR2</DATATYPE>\r\n            <LENGTH>10</LENGTH>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>STATUS</NAME>\r\n            <DATATYPE>VARCHAR2</DATATYPE>\r\n            <LENGTH>20</LENGTH>\r\n         </COL_LIST_ITEM>\r\n      </COL_LIST>\r\n      %PHYSICAL_PROPERTIES%   </RELATIONAL_TABLE>\r\n</TABLE>";
        LogTableSource = ((String)LogTableSource).replace(DATABASECHANGELOG, this.baseName);
        Object PkSql = "ALTER TABLE " + this.schema + ".%DATABASECHANGELOG%_ACTIONS ADD  CONSTRAINT %DATABASECHANGELOG%_ACTIONS_PK PRIMARY KEY (id,author,filename,sequence);";
        PkSql = ((String)PkSql).replace(DATABASECHANGELOG, this.baseName);
        String props_ts = " <PHYSICAL_PROPERTIES>\n    <HEAP_TABLE>\n         <SEGMENT_ATTRIBUTES>\n               <SEGMENT_CREATION_DEFERRED>\n               </SEGMENT_CREATION_DEFERRED>\n               <PCTFREE>10</PCTFREE>\n               <PCTUSED>40</PCTUSED>\n               <INITRANS>1</INITRANS>\n               <MAXTRANS>255</MAXTRANS>\n               <TABLESPACE>%TABLESPACE%</TABLESPACE>\n               <LOGGING>Y</LOGGING>\n       </SEGMENT_ATTRIBUTES>\n       <COMPRESS>N</COMPRESS>\n    </HEAP_TABLE>\n </PHYSICAL_PROPERTIES>\n";
        if (null != LbUtils.getCommand().getOptionValue(LBOptions.Options.LIQUIBASE_TABLESPACE_NAME) && !"".equals(LbUtils.getCommand().getOptionValue(LBOptions.Options.LIQUIBASE_TABLESPACE_NAME))) {
            props_ts = props_ts.replaceAll("%TABLESPACE%", Objects.requireNonNullElse((String)LbUtils.getCommand().getOptionValue(LBOptions.Options.LIQUIBASE_TABLESPACE_NAME), ""));
            LogTableSource = ((String)LogTableSource).replaceAll("%PHYSICAL_PROPERTIES%", props_ts);
        } else {
            String props_no_ts = "      <PHYSICAL_PROPERTIES>\r\n         <HEAP_TABLE/>\r\n      </PHYSICAL_PROPERTIES>\r\n";
            LogTableSource = ((String)LogTableSource).replaceAll("%PHYSICAL_PROPERTIES%", "      <PHYSICAL_PROPERTIES>\r\n         <HEAP_TABLE/>\r\n      </PHYSICAL_PROPERTIES>\r\n");
        }
        this.CreateorUpdateLogTableChange.setSource((String)LogTableSource);
        this.CreateorUpdateLogTableChange.setOwnerName(this.schema);
        this.CreateorUpdateLogTableChange.setObjectType("TABLE");
        this.CreateorUpdateLogTableChange.setObjectName(this.baseName + "_ACTIONS");
        this.CreateorUpdateLogTableTriggerChange.setSource(LogTriggerSource);
        this.CreateorUpdateLogTableTriggerChange.setOwnerName(this.schema);
        this.CreateorUpdateLogTableTriggerChange.setSourceType("STRING");
        this.CreateorUpdateLogTableTriggerChange.setObjectName(this.baseName + "_TRG");
        this.CreateorUpdateLogViewChange.setSource(LogViewsource);
        this.CreateorUpdateLogViewChange.setOwnerName(this.schema);
        this.CreateorUpdateLogViewChange.setObjectType("VIEW");
        this.CreateorUpdateLogViewChange.setObjectName(this.baseName + "_DETAILS");
        this.CreatePkChange.setSource((String)PkSql);
        this.CreatePkChange.setOwnerName(this.schema);
        this.CreatePkChange.setSourceType("STRING");
        this.CreatePkChange.setObjectName(this.baseName + "_PK");
        this.createUpdateLogTable();
    }

    private String getLiquibaseSchema(Database database) {
        String def_schema = (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.DEFAULT_SCHEMA_NAME);
        String lb_schema = (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.LIQUIBASE_SCHEMA_NAME);
        if (null == lb_schema || lb_schema.isEmpty()) {
            if (null == def_schema || def_schema.isEmpty()) {
                return LbUtils.getSchema(database);
            }
            return def_schema.replace("\"", "");
        }
        return lb_schema.replace("\"", "");
    }

    private String getLogTriggerSource() {
        Object LogTriggerSource = "--create log table trigger\nCREATE OR REPLACE TRIGGER " + this.schema + ".%DATABASECHANGELOG%_ACTIONS_TRG BEFORE\r\n    INSERT ON " + this.schema + ".%DATABASECHANGELOG%_ACTIONS\r\n    FOR EACH ROW\r\nDECLARE\r\n    new_seq  NUMBER;\r\nBEGIN\r\n    SELECT\r\n        nvl(MAX(sequence + 1), 0)\r\n    INTO new_seq\r\n    FROM\r\n        " + this.schema + ".%DATABASECHANGELOG%_ACTIONS\r\n    WHERE\r\n            id = :new.id\r\n        AND author = :new.author\r\n        AND filename = :new.filename;\r\n\r\n    :new.sequence := new_seq;\r\nEND;\n/\n-- end trigger\n";
        LogTriggerSource = null == this.schema || this.schema.isEmpty() ? ((String)LogTriggerSource).replaceAll(".%DATABASECHANGELOG%", this.baseName) : ((String)LogTriggerSource).replaceAll(DATABASECHANGELOG, this.baseName);
        return LogTriggerSource;
    }

    private String getLogViewsource() {
        Object LogViewsource = " <VIEW xmlns=\"http://xmlns.oracle.com/ku\" version=\"1.0\">\n";
        LogViewsource = (String)LogViewsource + "   <SCHEMA>%USER_NAME%</SCHEMA>\n";
        LogViewsource = (String)LogViewsource + "   <NAME>%DATABASECHANGELOG%_DETAILS</NAME>\n   <COL_LIST>\n      <COL_LIST_ITEM>\n         <NAME>DEPLOYMENT_ID</NAME>\n      </COL_LIST_ITEM>\n      <COL_LIST_ITEM>\n         <NAME>ID</NAME>\n      </COL_LIST_ITEM>\n      <COL_LIST_ITEM>\n         <NAME>AUTHOR</NAME>\n      </COL_LIST_ITEM>\n      <COL_LIST_ITEM>\n         <NAME>FILENAME</NAME>\n      </COL_LIST_ITEM>\n      <COL_LIST_ITEM>\n         <NAME>SQL</NAME>\n      </COL_LIST_ITEM>\n      <COL_LIST_ITEM>\n         <NAME>SXML</NAME>\n      </COL_LIST_ITEM>\n      <COL_LIST_ITEM>\n         <NAME>DATEEXECUTED</NAME>\n      </COL_LIST_ITEM>\n      <COL_LIST_ITEM>\n         <NAME>EXECTYPE</NAME>\n      </COL_LIST_ITEM>\n      <COL_LIST_ITEM>\n         <NAME>MD5SUM</NAME>\n      </COL_LIST_ITEM>\n      <COL_LIST_ITEM>\n         <NAME>DESCRIPTION</NAME>\n      </COL_LIST_ITEM>\n      <COL_LIST_ITEM>\n         <NAME>COMMENTS</NAME>\n      </COL_LIST_ITEM>\n      <COL_LIST_ITEM>\n         <NAME>LIQUIBASE</NAME>\n      </COL_LIST_ITEM>\n      <COL_LIST_ITEM>\n         <NAME>CONTEXTS</NAME>\n      </COL_LIST_ITEM>\n      <COL_LIST_ITEM>\n         <NAME>LABELS</NAME>\n      </COL_LIST_ITEM>\n   </COL_LIST>\n   <SUBQUERY>SELECT  da.deployment_id,    da.id,    da.author,    da.filename,  da.sql,     da.sxml,    d.dateexecuted,    d.exectype,    d.md5sum,  d.description,    d.comments,    d.liquibase,    d.contexts,    d.labels \nFROM ";
        if (null != this.schema && !this.schema.isEmpty()) {
            LogViewsource = (String)LogViewsource + this.schema + ".";
        }
        LogViewsource = (String)LogViewsource + "%DATABASECHANGELOG% d   LEFT JOIN ";
        if (null != this.schema && !this.schema.isEmpty()) {
            LogViewsource = (String)LogViewsource + this.schema + ".";
        }
        LogViewsource = (String)LogViewsource + "%DATABASECHANGELOG%_ACTIONS da ON d.id = da.id AND d.author = da.author AND d.filename = da.filename ORDER BY   1,7</SUBQUERY>\n</VIEW>";
        LogViewsource = ((String)LogViewsource).replaceAll(DATABASECHANGELOG, this.baseName);
        return LogViewsource;
    }

    public void createUpdateLogTable() throws DatabaseException {
        if (this.skip) {
            return;
        }
        Connection con = ((JdbcConnection)this.database.getConnection()).getUnderlyingConnection();
        try {
            int cols = 0;
            try {
                Object sql = "select count(*) from all_tab_columns where table_name='%DATABASECHANGELOG%_ACTIONS' and owner = '" + this.schema + "'";
                sql = ((String)sql).replaceAll(DATABASECHANGELOG, this.baseName);
                String cnt = DbmsMetaUtils.executeSql((String)sql, con);
                if (null != cnt && !cnt.isEmpty()) {
                    cols = Integer.parseInt(cnt);
                }
            }
            catch (Exception sql) {
                // empty catch block
            }
            if (8 == cols) {
                this.skip = true;
                return;
            }
            Executor exec = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", this.database);
            exec.execute((Change)this.CreateorUpdateLogTableChange);
            if (0 < cols) {
                this.UpdateLogDataChange.setSource(this.MergeSqlv1);
                this.UpdateLogDataChange.setSourceType("STRING");
                exec.execute((Change)this.UpdateLogDataChange);
                this.UpdateLogDataChange.setSource(this.MergeSqlv2a);
                this.UpdateLogDataChange.setSourceType("STRING");
                exec.execute((Change)this.UpdateLogDataChange);
                this.UpdateLogDataChange.setSource(this.MergeSqlv2b);
                this.UpdateLogDataChange.setSourceType("STRING");
                exec.execute((Change)this.UpdateLogDataChange);
            }
            exec.execute((Change)this.CreatePkChange);
            exec.execute((Change)this.CreateorUpdateLogTableTriggerChange);
            exec.execute((Change)this.CreateorUpdateLogViewChange);
        }
        catch (DatabaseException e) {
            Logger.warn(ActionLogTableManager.class, (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getActionFromActionLog(String changeId, String author, String filename) throws SQLException, IOException, DatabaseException {
        Connection conn = ((JdbcConnection)this.database.getConnection()).getUnderlyingConnection();
        String actionLogSxmlQuery = QueryUtils.getXMLQueries().getQuery("actionLogSxmlQuery", conn).getSql();
        actionLogSxmlQuery = actionLogSxmlQuery.replaceAll(DATABASECHANGELOG, this.baseName);
        StringBuilder sb = new StringBuilder();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        this.createUpdateLogTable();
        stmt = conn.prepareStatement(actionLogSxmlQuery);
        stmt.setString(1, changeId);
        stmt.setString(2, author);
        stmt.setString(3, filename);
        rs = stmt.executeQuery();
        while (rs.next()) {
            Clob sxml = rs.getClob(1);
            if (null == sxml) {
                String string = null;
                return string;
            }
            sb.append(LiquibaseStringUtils.clobToString(sxml));
        }
        String string = sb.toString();
        return string;
        finally {
            try {
                if (null != rs) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            if (null != stmt) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public String getActionLogSql(RawSQLChange change, String sqltorun) {
        String s = sqltorun;
        StringBuilder sb = new StringBuilder();
        if (change == null) {
            return null;
        }
        if (32768 < s.length()) {
            s = "Not capturing long script";
        }
        sb.append(this.genActionLoggingSql(change.getChangeSet().getId(), change.getChangeSet().getAuthor(), change.getChangeSet().getFilePath(), s, null));
        return sb.toString();
    }

    private String genActionLoggingSql(String id, String author, String filename, String actions, String sxml) {
        try {
            StringBuilder sb = new StringBuilder();
            Executor exec = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", this.database);
            String rawAction = "";
            String rawSxml = "";
            if (null != actions) {
                rawAction = new String(Base64.getEncoder().encode(actions.getBytes()));
            }
            if (null != sxml) {
                rawSxml = new String(Base64.getEncoder().encode(sxml.getBytes()));
            }
            sb.append(this.addLogRecordComment);
            sb.append("\n DECLARE ");
            sb.append("\n id varchar2(2000) := '").append(id).append("';");
            sb.append("\n status varchar2(2000) := 'PREPARING';");
            sb.append("\n rawAction clob;");
            sb.append("\n rawSxml clob;");
            sb.append("\n myrow varchar2(2000);");
            sb.append("\n action clob := '';");
            sb.append("\n sxml clob := '';");
            sb.append("\n dep varchar2(2000) := '").append(((ChangeLogHistoryServiceFactory)Scope.getCurrentScope().getSingleton(ChangeLogHistoryServiceFactory.class)).getChangeLogService(this.database).getDeploymentId()).append("';");
            sb.append("\n author varchar2(2000) := '").append(author).append("';");
            sb.append("\n filename varchar2(2000) := '").append(filename).append("';");
            sb.append("\n insertlog varchar2(2000) := 'insert into ").append(this.schema).append(".%DATABASECHANGELOG%_ACTIONS ").append("(id,author,filename,sql,sxml,deployment_id,").append("status) values (:id,:author,:filename,:action,").append(":sxml,:dep,:status) returning rowid into :out';");
            sb.append("\n updateaction varchar2(2000) := 'update ").append(this.schema).append(".%DATABASECHANGELOG%_ACTIONS ").append("set sql = sql ||:action where rowid = :myrow ';");
            sb.append("\n updatesxml varchar2(2000) := 'update ").append(this.schema).append(".%DATABASECHANGELOG%_ACTIONS ").append("set sxml = sxml ||:sxml where rowid = :myrow ';");
            sb.append("\n begin ");
            if (null == actions) {
                sb.append("\n action := '';");
            } else if (32000 > rawAction.length() && 32000 > rawSxml.length()) {
                if (!rawAction.isEmpty()) {
                    sb.append("\naction := utl_raw.cast_to_varchar2(utl_encode.base64_decode(utl_raw.cast_to_raw(q'{").append(rawAction).append("}')));");
                }
                if (!rawSxml.isEmpty()) {
                    sb.append("\nsxml := utl_raw.cast_to_varchar2(utl_encode.base64_decode(utl_raw.cast_to_raw(q'{").append(rawSxml).append("}')));");
                }
                sb.append("\n execute immediate insertlog using id,author,filename,action,sxml,dep,status returning into myrow;");
            } else {
                List<String> actionchunks = LiquibaseStringUtils.splitString(rawAction, 32000);
                List<String> sxmlchunks = LiquibaseStringUtils.splitString(rawSxml, 32000);
                boolean first = true;
                for (String piece : actionchunks) {
                    sb.append("\n rawAction := '").append(piece).append("';");
                    sb.append("\n action := utl_raw.cast_to_varchar2(utl_encode.base64_decode(utl_raw.cast_to_raw(rawAction)));");
                    if (first) {
                        sb.append("\n execute immediate insertlog using id,author,filename,action,sxml,dep,status returning into myrow;");
                        first = false;
                        continue;
                    }
                    sb.append("\n execute immediate updateaction using action,myrow;");
                }
                for (String piece : sxmlchunks) {
                    sb.append("\n rawSxml := '").append(piece).append("';");
                    sb.append("\n sxml := utl_raw.cast_to_varchar2(utl_encode.base64_decode(utl_raw.cast_to_raw(rawSxml)));");
                    sb.append("\n execute immediate updatesxml using sxml,myrow;\n");
                }
            }
            sb.append("\nend;");
            if (exec instanceof LoggingExecutor) {
                sb.append("\n/        \n--\n");
            }
            String ret = sb.toString();
            ret = null == this.schema || this.schema.isEmpty() ? ret.replaceAll(".%DATABASECHANGELOG%", this.baseName) : ret.replaceAll(DATABASECHANGELOG, this.baseName);
            return ret;
        }
        catch (Exception e) {
            Logger.warn(ActionLogTableManager.class, (Throwable)e);
            throw e;
        }
    }

    public String getActionLogSql(SqlStatement statement, String sqltorun) throws DatabaseException {
        String s = sqltorun;
        StringBuilder sb = new StringBuilder();
        if (!(statement instanceof AbstractOracleStatement)) {
            return null;
        }
        AbstractOracleStatement st = (AbstractOracleStatement)statement;
        if (statement instanceof RollbackOraclePlSqlStatement || statement instanceof RollbackOracleSxmlStatement) {
            sb.append(this.genRollbackActionLogging(st.getId(), st.getAuthor(), st.getFile()));
        } else {
            if ((statement instanceof RunOracleScriptStatement || statement instanceof RunApexScriptStatement || statement instanceof RunOrdsScriptStatement) && 32768 < s.length()) {
                s = "Not capturing long script";
            }
            sb.append(this.genActionLoggingSql(st.getId(), st.getAuthor(), st.getFile(), s, DbmsMetaUtils.getDdlFromDb(((JdbcConnection)this.database.getConnection()).getUnderlyingConnection(), st.getObjectType(), st.getObjectName())));
        }
        return sb.toString();
    }

    private String genRollbackActionLogging(String id, String author, String filename) {
        Object sb = "delete from " + this.schema + ".%DATABASECHANGELOG%_ACTIONS  where id = '" + id + "' and filename = '" + filename + "' and author ='" + author + "' and sequence = (select Max(sequence) from " + this.schema + ".%DATABASECHANGELOG%_ACTIONS  where id = '" + id + "' and filename = '" + filename + "' and author ='" + author + "')";
        sb = null == this.schema || this.schema.isEmpty() ? ((String)sb).replaceAll(".%DATABASECHANGELOG%", this.baseName) : ((String)sb).replaceAll(DATABASECHANGELOG, this.baseName);
        return sb;
    }
}

