/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlcl.commands.dg;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.sqlcl.commands.dg.DgCmdBase;
import oracle.dbtools.sqlcl.commands.dg.DgConfig;
import oracle.dbtools.sqlcl.commands.dg.DgDBUtils;
import oracle.dbtools.sqlcl.commands.dg.DgStatus;
import oracle.dbtools.sqlcl.commands.dg.Messages;

public class DgCmdRole
extends DgCmdBase {
    protected static final Logger LOGGER = Logger.getLogger(DgCmdRole.class.getName());

    public DgCmdRole(ScriptRunnerContext scriptCtx, Connection sqlConn) {
        super(scriptCtx, sqlConn);
    }

    public void runSwitchover(String dbun, int wait, int wait_time) {
        if (!this.checkConnection()) {
            return;
        }
        int objid = DgDBUtils.getObjectIdMember(this.sqlConn, dbun);
        if (objid == 0) {
            this.printOraError(16596);
            return;
        }
        try {
            boolean status = false;
            DgConfig dgConfig = DgConfig.readConfig(this.sqlConn);
            if (wait > 0) {
                if (wait_time > 0) {
                    this.scriptCtx.write(MessageFormat.format(Messages.getString("DGCmd.17143"), wait_time));
                } else {
                    this.scriptCtx.write(Messages.getString("DGCmd.17142"));
                }
                this.ctxFlush();
                String indoc = String.format("<DO_CONTROL version=\"%s\"> <DO_MOVE type=\"Switchover\" site_id=\"%d\" level=\"session-drain\" time=\"%d\"/></DO_CONTROL>", "23.1.0.0.0", objid, wait);
                LOGGER.info("indoc: " + indoc);
                DgStatus out = this.sendAnalyz(dgConfig, indoc, null);
                if (out.severity == 0 && out.dmonError == 16805) {
                    this.scriptCtx.write(Messages.getString("DGCmd.17391"));
                    status = false;
                }
            }
            String old_primary = DgDBUtils.queryPrimary(this.sqlConn);
            if (!status) {
                String indoc = String.format("<DO_CONTROL version=\"%s\"> <DO_MOVE type=\"Switchover\" site_id=\"%d\"/></DO_CONTROL>", "23.1.0.0.0", objid);
                LOGGER.info("indoc: " + indoc);
                DgStatus out = this.sendAnalyz(dgConfig, indoc, "IGNORE_SESSION");
                if (out.severity == 0 && out.dmonError == 16523) {
                    this.scriptCtx.write(Messages.getString("DGCmd.17392"));
                    out = this.sendAnalyz(dgConfig, indoc, "IGNORE_SESSION");
                }
                if (out.severity == 0 && (out.dmonError == 0 || out.dmonError == 16570)) {
                    this.scriptCtx.write(MessageFormat.format(Messages.getString("DGCmd.16941"), dbun));
                    this.scriptCtx.write(MessageFormat.format(Messages.getString("DGCmd.17467"), "Switchover"));
                } else {
                    this.scriptCtx.write(MessageFormat.format(Messages.getString("DGCmd.16948"), old_primary));
                    if (out.severity != 0) {
                        this.printOraError(out.severity);
                    } else if (out.dmonError != 0) {
                        this.printOraError(out.dmonError);
                    }
                }
            }
        }
        catch (SQLException ex) {
            this.printException(ex);
        }
    }

    public void runFailover(String dbun, String fo_type) {
        int objid = DgDBUtils.getObjectIdMember(this.sqlConn, dbun);
        if (objid == 0) {
            this.printOraError(16596);
            return;
        }
        DgConfig dgConfig = DgConfig.readConfig(this.sqlConn);
        String indoc = String.format("<DO_CONTROL version=\"%s\"><DO_MOVE type=\"Failover\" site_id=\"%d\" level=\"%s\"/></DO_CONTROL>", "23.1.0.0.0", objid, "graceful");
        this.scriptCtx.write(Messages.getString("DGCmd.16950"));
        this.ctxFlush();
        LOGGER.info("indoc: " + indoc);
        DgStatus out = this.sendAnalyz(dgConfig, indoc, "IGNORE_SESSION");
        if (out.severity == 0 && (out.dmonError == 0 || out.dmonError == 16570)) {
            this.scriptCtx.write(MessageFormat.format(Messages.getString("DGCmd.16944"), dbun));
        } else {
            this.scriptCtx.write(Messages.getString("DGCmd.16951"));
            if (out.severity != 0) {
                this.printOraError(out.severity);
            } else if (out.dmonError != 0) {
                this.printOraError(out.dmonError);
            }
        }
    }

    public void runReinstate(String dbun) {
        if (!this.checkConnection()) {
            return;
        }
        int objid = DgDBUtils.getObjectIdMember(this.sqlConn, dbun);
        if (objid == 0) {
            this.printOraError(16596);
            return;
        }
        DgConfig dgConfig = DgConfig.readConfig(this.sqlConn);
        DgConfig config = DgConfig.readConfig(this.sqlConn);
        this.scriptCtx.write(MessageFormat.format(Messages.getString("DGCmd.16980"), dbun));
        String indoc = String.format("<DO_CONTROL version=\"%s\"><DO_COMMAND type=\"Reinst-Enable\" object_id=\"%d\" args=\"%s\"/></DO_CONTROL>", "23.1.0.0.0", objid, "manual");
        LOGGER.info("indoc: " + indoc);
        DgStatus out = this.sendAnalyz(dgConfig, indoc, null);
        if (out.severity == 0 && (out.dmonError == 16631 || out.dmonError == 16570)) {
            this.scriptCtx.write(MessageFormat.format(Messages.getString("DGCmd.16982"), dbun));
            out = this.sendAnalyz(dgConfig, indoc, null);
        }
        if (out.severity == 0 && out.dmonError == 0) {
            this.scriptCtx.write(MessageFormat.format(Messages.getString("DGCmd.16984"), dbun));
        } else if (out.severity == 0 && out.dmonError == 16657) {
            this.scriptCtx.write(MessageFormat.format(Messages.getString("DGCmd.17283"), dbun));
        } else if (out.severity != 0 || out.dmonError != 16631 && out.dmonError != 16570) {
            this.scriptCtx.write(MessageFormat.format(Messages.getString("DGCmd.16986"), dbun));
            if (out.severity != 0) {
                this.printOraError(out.severity);
            } else if (out.dmonError != 0) {
                this.printOraError(out.dmonError);
            }
        }
    }
}

