/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.langdata.core.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.common.utils.PlatformUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extension.langdata.commands.InitMessages;
import oracle.dbtools.extension.langdata.commands.UtilsMessages;
import oracle.dbtools.extension.langdata.core.LangDataConfig;
import oracle.dbtools.extension.langdata.core.exceptions.LangDataException;
import oracle.dbtools.extension.langdata.core.exceptions.OracleHomeNotFound;
import oracle.dbtools.extension.langdata.core.utils.LangDataQueryUtils;
import oracle.dbtools.extension.langdata.core.utils.LangUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.WindowsUtility;

public class InitUtils {
    public static final String ENV_OH = "ORACLE_HOME";

    public static String getOH() throws OracleHomeNotFound {
        boolean isWindows = PlatformUtils.isWindows();
        String oh = System.getenv().get(ENV_OH);
        if (oh == null && isWindows) {
            try {
                String key = "SOFTWARE\\ORACLE";
                List oracle_keys = WindowsUtility.readStringSubKeys((int)-2147483646, (String)key);
                String homeKey = null;
                if (oracle_keys != null) {
                    for (String oracle_key : oracle_keys) {
                        String temp = key + "\\" + oracle_key;
                        homeKey = WindowsUtility.readString((int)-2147483646, (String)temp, (String)"ORACLE_HOME_KEY");
                        if (homeKey == null) continue;
                        oh = WindowsUtility.readString((int)-2147483646, (String)homeKey, (String)ENV_OH);
                    }
                }
            }
            catch (Exception e) {
                throw new OracleHomeNotFound(UtilsMessages.getString("ORACLE_HOME_NOT_FOUND_EXCEPTION"), e);
            }
        }
        if (oh == null) {
            throw new OracleHomeNotFound(UtilsMessages.getString("ORACLE_HOME_NOT_FOUND_EXCEPTION"));
        }
        return oh;
    }

    public static boolean isOHReal(ScriptRunnerContext ctx) throws OracleHomeNotFound {
        String oh = InitUtils.getOH();
        File oracleHomedir = new File(oh);
        if (!oracleHomedir.exists()) {
            return false;
        }
        File omlDir = new File(oh + File.separator + "oml4py" + File.separator + "server");
        if (!omlDir.exists()) {
            if (LangDataConfig.isDebug()) {
                ctx.writeln(UtilsMessages.getString("ORACLE_HOME_OML_NOT_FOUND"));
            }
            return false;
        }
        File oracleHomePythonDir = new File(oh + File.separator + "python" + File.separator + "bin" + File.separator + "pip");
        if (!oracleHomePythonDir.exists()) {
            if (LangDataConfig.isDebug()) {
                ctx.writeln(UtilsMessages.getString("ORACLE_HOME_PYTHON_NOT_FOUND"));
            }
            return false;
        }
        return true;
    }

    public static Boolean isADB(Connection conn) {
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        String result = dbUtil.executeReturnOneCol(LangDataQueryUtils.getXMLQueries().getQuery("langdata.adbsetup", conn).getSql());
        return "OLTP".equalsIgnoreCase(result) || "DWCS".equalsIgnoreCase(result) || "JDCS".equalsIgnoreCase(result);
    }

    public static Boolean isSYSDBA(Connection conn) {
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        String result = dbUtil.executeReturnOneCol(LangDataQueryUtils.getXMLQueries().getQuery("langdata.checksysdba", conn).getSql());
        return "TRUE".equalsIgnoreCase(result);
    }

    public static Boolean isADMIN(Connection conn) {
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        String result = dbUtil.executeReturnOneCol(LangDataQueryUtils.getXMLQueries().getQuery("langdata.checkADMIN", conn).getSql());
        return "ADMIN".equalsIgnoreCase(result);
    }

    public static Boolean checkOMF(Connection conn) {
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        String result = dbUtil.executeReturnOneCol(LangDataQueryUtils.getXMLQueries().getQuery("langdata.checkOMF", conn).getSql());
        if (result == null || result.isEmpty()) {
            return false;
        }
        return true;
    }

    public static void createCloudServiceSchema(String oracleHome) throws IOException, InterruptedException {
        block16: {
            List<String> command = Arrays.asList(oracleHome + "/perl/bin/perl", oracleHome + "/rdbms/admin/catcon.pl", "-u", "sys/knl_test7", "-force_pdb_mode", "READ WRITE", "-b", "dbms_cloud_install", "-d", oracleHome + "/rdbms/admin/", "-l", "/tmp", "catclouduser.sql");
            if (LangDataConfig.isDebug()) {
                LangDataConfig.getCurrentContext().writeln("Running the command: " + String.join((CharSequence)" ", command));
            }
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            processBuilder.redirectErrorStream(true);
            try {
                Process process = processBuilder.start();
                int exitCode = process.waitFor();
                if (LangDataConfig.isDebug()) {
                    if (exitCode != 0) {
                        LangDataConfig.getCurrentContext().writeln(InitMessages.format("PERL_SCRIPT_FAILED", oracleHome + "/rdbms/admin/catcon.pl", "catclouduser.sql", exitCode));
                    } else {
                        LangDataConfig.getCurrentContext().writeln(InitMessages.format("PERL_SCRIPT_SUCCESSFUL", oracleHome + "/rdbms/admin/catcon.pl"));
                    }
                } else if (LangDataConfig.isVerbose()) {
                    if (exitCode != 0) {
                        LangDataConfig.getCurrentContext().writeln(InitMessages.getString("CLOUD_SCHEMA_CREATION_FAILED"));
                    } else {
                        LangDataConfig.getCurrentContext().writeln(InitMessages.getString("CLOUD_SCHEMA_CREATION_SUCCESSFUL"));
                    }
                }
                if (!LangDataConfig.isDebug()) break block16;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        LangDataConfig.getCurrentContext().writeln(line);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void runDbmsCloudInstall(String oracleHome) throws IOException, InterruptedException {
        List<String> command = Arrays.asList("perl", oracleHome + "/rdbms/admin/catcon.pl", "-u", "sys/knl_test7", "-force_pdb_mode", "READ WRITE", "-b", "dbms_cloud_install", "-d", oracleHome + "/rdbms/admin/", "-l", "/tmp", "dbms_cloud_install.sql");
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        if (LangDataConfig.isDebug()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    LangDataConfig.getCurrentContext().writeln(line);
                }
            }
        }
        int exitCode = process.waitFor();
        if (LangDataConfig.isDebug()) {
            if (exitCode != 0) {
                LangDataConfig.getCurrentContext().writeln(InitMessages.format("PERL_SCRIPT_FAILED", oracleHome + "/rdbms/admin/catcon.pl", "dbms_cloud_install.sql", exitCode));
            } else {
                LangDataConfig.getCurrentContext().writeln(InitMessages.format("PERL_SCRIPT_SUCCESSFUL", oracleHome + "/rdbms/admin/catcon.pl"));
            }
        } else if (LangDataConfig.isVerbose()) {
            if (exitCode != 0) {
                LangDataConfig.getCurrentContext().writeln(InitMessages.getString("DBMS_CLOUD_INSTALLATION_FAILED"));
            } else {
                LangDataConfig.getCurrentContext().writeln(InitMessages.getString("DBMS_CLOUD_INSTALLATION_SUCCESSFUL"));
            }
        }
    }

    public static void addOCIDomain(Connection conn) {
        block4: {
            DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
            HashMap binds = new HashMap();
            try {
                dbUtil.execute(LangDataQueryUtils.getXMLQueries().getQuery("langdata.addocidomain", conn).getSql(), binds);
                if (LangDataConfig.isVerbose()) {
                    LangDataConfig.getCurrentContext().writeln(InitMessages.getString("OCI_DOMAIN_ADDITION_SUCCESSFUL"));
                }
            }
            catch (Exception e) {
                if (LangDataConfig.isDebug()) {
                    LangDataConfig.getCurrentContext().writeln(Arrays.toString(e.getStackTrace()));
                }
                if (!LangDataConfig.isVerbose()) break block4;
                LangDataConfig.getCurrentContext().writeln(InitMessages.getString("OCI_DOMAIN_ADDITION_FAILED"));
            }
        }
    }

    public static void installOMLDependencies(String mountDir, String installOML4pyshFile, String logDirectory) throws LangDataException {
        try {
            String line;
            ProcessBuilder processBuilder = new ProcessBuilder("bash", installOML4pyshFile, "", "", "", "", mountDir);
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            ArrayList<String> stderrLines = new ArrayList<String>();
            Object out = "";
            while ((line = reader.readLine()) != null) {
                if (LangDataConfig.isDebug()) {
                    LangDataConfig.getCurrentContext().writeln("[STDOUT] " + line);
                    continue;
                }
                if (logDirectory == null || logDirectory.isEmpty()) continue;
                out = (String)out + line + "\n";
            }
            while ((line = errorReader.readLine()) != null) {
                if (LangDataConfig.isDebug()) {
                    LangDataConfig.getCurrentContext().writeln(line);
                } else if (logDirectory != null && !logDirectory.isEmpty()) {
                    out = (String)out + line + "\n";
                }
                stderrLines.add(line);
            }
            if (logDirectory != null && !logDirectory.isEmpty()) {
                LangUtils.storeToLogFile("oml4py_dependency_installation.sql", (String)out, logDirectory);
            }
            int exitCode = process.waitFor();
            if (LangDataConfig.isDebug()) {
                LangDataConfig.getCurrentContext().writeln(InitMessages.format("OML4PY_INSTALL_EXIT_CODE", exitCode));
            }
            if (exitCode != 0 || stderrLines.stream().anyMatch(l -> l.toLowerCase().contains("error"))) {
                throw new LangDataException(InitMessages.getString("OML4PY_INSTALL_ERROR"));
            }
        }
        catch (IOException | InterruptedException e) {
            if (LangDataConfig.isDebug()) {
                LangDataConfig.getCurrentContext().writeln(Arrays.toString(e.getStackTrace()));
            }
            LangDataConfig.getCurrentContext().writeln(e.getLocalizedMessage());
        }
    }

    public static void copyAskSqlToOracleHomeAdmin(String sourceDirPath) throws LangDataException {
        try {
            String oracleHome = InitUtils.getOH();
            if (oracleHome == null || oracleHome.isEmpty()) {
                LangDataConfig.getCurrentContext().writeln("ORACLE_HOME environment variable is not set.");
                return;
            }
            Path sourceFile = Paths.get(sourceDirPath, "ask.sql");
            Path targetDir = Paths.get(oracleHome, "admin");
            Path targetFile = targetDir.resolve("ask.sql");
            if (!Files.exists(sourceFile, new LinkOption[0])) {
                LangDataConfig.getCurrentContext().writeln("Source file not found: " + sourceFile.toString());
                return;
            }
            if (!Files.exists(targetDir, new LinkOption[0])) {
                Files.createDirectories(targetDir, new FileAttribute[0]);
            }
            Files.copy(sourceFile, targetFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException | OracleHomeNotFound e) {
            throw new LangDataException("Error in setting up DBAssist: " + e.getMessage());
        }
    }
}

