/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.langdata.commands.init;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import oracle.dbtools.extension.langdata.commands.InitMessages;
import oracle.dbtools.extension.langdata.core.LangDataConfig;
import oracle.dbtools.extension.langdata.core.exceptions.LangDataException;
import oracle.dbtools.extension.langdata.core.exceptions.OracleHomeNotFound;
import oracle.dbtools.extension.langdata.core.messages.GeneralMessages;
import oracle.dbtools.extension.langdata.core.utils.InitUtils;
import oracle.dbtools.extension.langdata.core.utils.LangUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.runner.SqlClCommandsRunner;
import oracle.dbtools.util.SpinningWheel;

public class InitCommandCore {
    private final Path installTempDir = Paths.get(LangUtils.getTempDir(), new String[0]).resolve("langdata").resolve("install");
    private final Path plsqlTempDir = Paths.get(LangUtils.getTempDir(), new String[0]).resolve("langdata").resolve("plsql");
    private final String mountDir;
    private final Path pythonPkgsDir;
    private final Path pythonLibsDir;
    private final Path modelsDir;
    private final Path checkTablespaceFile;
    private final Path createTablespaceFile;
    private final Path shrinkTablespaceFile;
    private final Path setupDBFSFile;
    private final Path createLangDataUserFile;
    private final Path installOML4pyFile;
    private final Path installOML4pyshFile;
    private final Path installLangdataFile;
    private final String logDirectory;
    private final String pdbName;
    private final ScriptRunnerContext ctx;
    private final Connection conn;
    private final Boolean isAutonomousDB;
    private final SqlClCommandsRunner sqlClCommandsRunner;
    private final String langdataUserPassword;
    private final String utilityDirectory;
    private final Path createAppUserFile;
    private final Path createUserGrantsFile;
    private final Path createUserSynonymsFile;
    private static int stepCount = 0;
    private static int totalSteps = 0;

    private void startSpinningWheel(ScriptRunnerContext ctx) {
        SpinningWheel.start((ScriptRunnerContext)ctx);
    }

    private void stopSpinningWheel() {
        SpinningWheel.stop();
    }

    public InitCommandCore(Connection conn, ScriptRunnerContext ctx, SqlClCommandsRunner sqlClCommandsRunner, String logDirectory, Boolean isAutonomousDB, String pdbName, String langdataUserPassword, String utilityDirectory, String mountDir) {
        this.pythonPkgsDir = isAutonomousDB == false ? Paths.get(utilityDirectory, new String[0]).resolve("python_pkgs") : null;
        this.modelsDir = isAutonomousDB == false ? Paths.get(utilityDirectory, new String[0]).resolve("models") : null;
        this.pythonLibsDir = isAutonomousDB == false ? Paths.get(utilityDirectory, new String[0]).resolve("python_libs") : null;
        this.checkTablespaceFile = this.installTempDir.resolve("check_langdata_tablespace.sql");
        this.createTablespaceFile = this.installTempDir.resolve("create_langdata_tablespace.sql");
        this.shrinkTablespaceFile = this.installTempDir.resolve("shrink_tablespace.sql");
        this.createLangDataUserFile = this.installTempDir.resolve("create_langdata_user.sql");
        this.setupDBFSFile = this.installTempDir.resolve("setup_dbfs.sql");
        this.installOML4pyFile = this.installTempDir.resolve("install_oml4py.sql");
        this.installOML4pyshFile = this.installTempDir.resolve("install_oml4py.sh");
        this.installLangdataFile = this.plsqlTempDir.resolve("install.sql");
        this.createAppUserFile = this.installTempDir.resolve("create_app_user.sql");
        this.createUserGrantsFile = this.installTempDir.resolve("create_user_grants.sql");
        this.createUserSynonymsFile = this.installTempDir.resolve("create_user_synonyms.sql");
        this.logDirectory = logDirectory;
        this.conn = conn;
        this.ctx = ctx;
        this.isAutonomousDB = isAutonomousDB;
        this.sqlClCommandsRunner = sqlClCommandsRunner;
        this.pdbName = pdbName;
        this.langdataUserPassword = langdataUserPassword;
        this.mountDir = mountDir;
        this.utilityDirectory = utilityDirectory;
        totalSteps = isAutonomousDB != false ? 2 : 6;
        stepCount = 0;
    }

    public void setupLangData() throws InterruptedException, OracleHomeNotFound, IOException, LangDataException {
        try {
            if (!this.isAutonomousDB.booleanValue()) {
                this.createLangDataTablespace();
                this.setupDBFS();
                this.installOML4PY();
                this.installDBMSCloud();
            }
            this.createLangDataUser();
            this.installLangDataPackages();
        }
        catch (LangDataException e) {
            throw new LangDataException(e.getLocalizedMessage());
        }
    }

    private String getStep() {
        return "[" + ++stepCount + "/" + totalSteps + "]";
    }

    private void checkSqlRunErrors(String step, String logMessage) throws LangDataException {
        boolean err = (Boolean)this.ctx.getProperty("sqldev.error");
        if (err) {
            GeneralMessages.printErrorStatus(step, logMessage, InitMessages.getString("STEP_FAILED"));
            throw new LangDataException(logMessage + " step: " + InitMessages.getString("STEP_FAILED"));
        }
    }

    private void createLangDataTablespace() throws LangDataException {
        long startTime = System.currentTimeMillis();
        String sqlOutput = "";
        String step = this.getStep();
        this.startSpinningWheel(this.ctx);
        if (!this.isAutonomousDB.booleanValue()) {
            String[] lines;
            if (this.checkTablespaceFile.toFile().exists()) {
                sqlOutput = this.sqlClCommandsRunner.run("@" + String.valueOf(this.checkTablespaceFile) + " " + this.pdbName + " LANGDATA");
                LangUtils.storeToLogFile("check_langdata_tablespace.sql", sqlOutput, this.logDirectory);
                this.checkSqlRunErrors(step, InitMessages.getString("TABLESPACE_SETUP_LOG"));
            }
            if ("skip".equalsIgnoreCase((lines = sqlOutput.split("\\R"))[lines.length - 4])) {
                this.stopSpinningWheel();
                if (LangDataConfig.isVerbose()) {
                    this.ctx.writeln(InitMessages.getString("TABLESPACE_ALREADY_EXISTS_VERBOSE"));
                }
                GeneralMessages.printSkippedStatus(step, InitMessages.getString("TABLESPACE_SETUP_LOG"), InitMessages.getString("STEP_SKIPPED"));
            } else {
                sqlOutput = this.sqlClCommandsRunner.run("@" + String.valueOf(this.createTablespaceFile) + " " + this.pdbName + " LANGDATA");
                LangUtils.storeToLogFile("create_langdata_tablespace.sql", sqlOutput, this.logDirectory);
                this.checkSqlRunErrors(step, InitMessages.getString("TABLESPACE_SETUP_LOG"));
                if (LangDataConfig.isDebug()) {
                    this.ctx.writeln(sqlOutput);
                }
                sqlOutput = this.sqlClCommandsRunner.run("@" + String.valueOf(this.shrinkTablespaceFile) + " LANGDATA");
                LangUtils.storeToLogFile("shrink_tablespace.sql", sqlOutput, this.logDirectory);
                this.checkSqlRunErrors(step, InitMessages.getString("TABLESPACE_SETUP_LOG"));
                this.stopSpinningWheel();
                if (LangDataConfig.isDebug()) {
                    this.ctx.writeln(sqlOutput);
                }
                if (LangDataConfig.isVerbose()) {
                    this.ctx.writeln(InitMessages.getString("TABLESPACE_SETUP_VERBOSE"));
                } else {
                    long endTime = System.currentTimeMillis();
                    GeneralMessages.printSuccessStatus(step, InitMessages.getString("TABLESPACE_SETUP_LOG"), InitMessages.getString("STEP_OK"), LangUtils.getTimeInMilliSeconds(startTime, endTime));
                }
            }
        }
    }

    private void createLangDataUser() throws LangDataException {
        long startTime = System.currentTimeMillis();
        String step = this.getStep();
        this.startSpinningWheel(this.ctx);
        String tablespaceName = this.isAutonomousDB != false ? "DATA" : "LANGDATA";
        String createLangDataUserScriptOutput = this.sqlClCommandsRunner.run("@" + String.valueOf(this.createLangDataUserFile) + " " + this.pdbName + " " + tablespaceName + " LANGDATA " + this.langdataUserPassword);
        if (LangDataConfig.isDebug()) {
            this.ctx.writeln(createLangDataUserScriptOutput);
        }
        LangUtils.storeToLogFile("create_langdata_user.sql", createLangDataUserScriptOutput, this.logDirectory);
        this.stopSpinningWheel();
        this.checkSqlRunErrors(step, InitMessages.getString("LANGDATA_USER_SETUP_LOG"));
        if (LangDataConfig.isVerbose()) {
            this.ctx.writeln(InitMessages.getString("LANGDATA_USER_SETUP_VERBOSE"));
        } else {
            long endTime = System.currentTimeMillis();
            GeneralMessages.printSuccessStatus(step, InitMessages.getString("LANGDATA_USER_SETUP_LOG"), InitMessages.getString("STEP_OK"), LangUtils.getTimeInMilliSeconds(startTime, endTime));
        }
    }

    private void installLangDataPackages() throws LangDataException {
        long startTime = System.currentTimeMillis();
        String step = this.getStep();
        this.startSpinningWheel(this.ctx);
        String modelPath = String.valueOf(this.plsqlTempDir) + File.separator + "models";
        String installLangDataOutput = this.sqlClCommandsRunner.run("@" + String.valueOf(this.installLangdataFile) + " " + String.valueOf(this.plsqlTempDir) + " " + this.mountDir + "/langdata/langdata_mnt LANGDATA");
        if (LangDataConfig.isDebug()) {
            this.ctx.writeln(installLangDataOutput);
        }
        LangUtils.storeToLogFile("install.sql", installLangDataOutput, this.logDirectory);
        this.checkSqlRunErrors(step, InitMessages.getString("LANGDATA_PACKAGES_LOG"));
        this.stopSpinningWheel();
        if (LangDataConfig.isVerbose()) {
            this.ctx.writeln(InitMessages.getString("LANGDATA_PACKAGES_VERBOSE"));
        } else {
            long endTime = System.currentTimeMillis();
            GeneralMessages.printSuccessStatus(step, InitMessages.getString("LANGDATA_PACKAGES_LOG"), InitMessages.getString("STEP_OK"), LangUtils.getTimeInMilliSeconds(startTime, endTime));
        }
    }

    private void setupDBFS() throws LangDataException {
        long startTime = System.currentTimeMillis();
        String sqlOutput = "";
        String step = this.getStep();
        this.startSpinningWheel(this.ctx);
        if (!this.isAutonomousDB.booleanValue()) {
            try {
                Path langdatamntDir = Paths.get(this.mountDir, "langdata", "langdata_mnt");
                if (!Files.exists(langdatamntDir, new LinkOption[0])) {
                    Files.createDirectories(langdatamntDir, new FileAttribute[0]);
                }
                if (this.setupDBFSFile.toFile().exists()) {
                    sqlOutput = this.sqlClCommandsRunner.run("@" + String.valueOf(this.setupDBFSFile) + " " + this.mountDir + " " + this.pdbName + " LANGDATA_REQUIREMENTS LANGDATA");
                    LangUtils.storeToLogFile("setup_dbfs.sql", sqlOutput, this.logDirectory);
                    this.checkSqlRunErrors(step, InitMessages.getString("DBFS_SETUP_LOG"));
                    if (LangDataConfig.isDebug()) {
                        this.ctx.writeln(sqlOutput);
                    }
                    if (LangDataConfig.isVerbose()) {
                        this.ctx.writeln(InitMessages.getString("DBFS_SETUP_VERBOSE"));
                    }
                }
                Path pkgDirPath = langdatamntDir.resolve("python_pkgs");
                Path modelsDirPath = langdatamntDir.resolve("models");
                Path pyLibsDirPath = langdatamntDir.resolve("python_libs");
                if (!Files.exists(pkgDirPath, new LinkOption[0])) {
                    Files.createDirectories(pkgDirPath, new FileAttribute[0]);
                }
                if (!Files.exists(modelsDirPath, new LinkOption[0])) {
                    Files.createDirectories(modelsDirPath, new FileAttribute[0]);
                }
                if (!Files.exists(pyLibsDirPath, new LinkOption[0])) {
                    Files.createDirectories(pyLibsDirPath, new FileAttribute[0]);
                }
                LangUtils.copyDirectoryContents(this.pythonPkgsDir, pkgDirPath);
                LangUtils.copyDirectoryContents(this.modelsDir, modelsDirPath);
                LangUtils.copyDirectoryContents(this.pythonLibsDir, pyLibsDirPath);
                if (LangDataConfig.isDebug()) {
                    this.ctx.writeln("Copied python_pkgs from: " + String.valueOf(this.pythonPkgsDir) + " to: " + String.valueOf(pkgDirPath));
                    this.ctx.writeln("Copied models from: " + String.valueOf(this.modelsDir) + " to: " + String.valueOf(modelsDirPath));
                    this.ctx.writeln("Copied python_libs from: " + String.valueOf(this.pythonLibsDir) + " to: " + String.valueOf(pyLibsDirPath));
                }
                if (LangDataConfig.isVerbose()) {
                    this.ctx.writeln(InitMessages.getString("DBFS_COPY_VERBOSE"));
                }
                long endTime = System.currentTimeMillis();
                GeneralMessages.printSuccessStatus(step, InitMessages.getString("DBFS_SETUP_LOG"), InitMessages.getString("STEP_OK"), LangUtils.getTimeInMilliSeconds(startTime, endTime));
            }
            catch (IOException e) {
                this.stopSpinningWheel();
                GeneralMessages.printErrorStatus(step, InitMessages.getString("DBFS_SETUP_LOG"), InitMessages.getString("STEP_FAILED"));
                throw new LangDataException(e.getLocalizedMessage());
            }
        }
    }

    private void installOML4PY() throws OracleHomeNotFound, LangDataException {
        String ORACLE_HOME = this.isAutonomousDB != false ? "" : InitUtils.getOH();
        long startTime = System.currentTimeMillis();
        String step = this.getStep();
        this.startSpinningWheel(this.ctx);
        if (!this.isAutonomousDB.booleanValue()) {
            String langdatamntDir = this.mountDir + "/langdata/langdata_mnt";
            String pkgDirPath1 = langdatamntDir + "python_pkgs";
            InitUtils.installOMLDependencies(langdatamntDir, this.installOML4pyshFile.toString(), this.logDirectory);
            String installOML4pyScriptOutput = this.sqlClCommandsRunner.run("@" + String.valueOf(this.installOML4pyFile) + " " + this.pdbName + " " + this.logDirectory + " " + ORACLE_HOME + File.separator + "python " + ORACLE_HOME + File.separator + "oml4py" + File.separator + "server");
            if (LangDataConfig.isDebug()) {
                this.ctx.writeln(installOML4pyScriptOutput);
            }
            LangUtils.storeToLogFile("install_oml4py.sql", installOML4pyScriptOutput, this.logDirectory);
            this.checkSqlRunErrors(step, InitMessages.getString("OML4PY_INSTALL_LOG"));
            this.stopSpinningWheel();
            if (LangDataConfig.isVerbose()) {
                this.ctx.writeln(InitMessages.getString("OML4PY_INSTALL_VERBOSE"));
            } else {
                long endTime = System.currentTimeMillis();
                GeneralMessages.printSuccessStatus(step, InitMessages.getString("OML4PY_INSTALL_LOG"), InitMessages.getString("STEP_OK"), LangUtils.getTimeInMilliSeconds(startTime, endTime));
            }
        }
    }

    private void installDBMSCloud() throws LangDataException, OracleHomeNotFound {
        long startTime = System.currentTimeMillis();
        String step = this.getStep();
        this.startSpinningWheel(this.ctx);
        if (!this.isAutonomousDB.booleanValue()) {
            try {
                InitUtils.createCloudServiceSchema(InitUtils.getOH());
                InitUtils.runDbmsCloudInstall(InitUtils.getOH());
                InitUtils.addOCIDomain(this.conn);
                this.stopSpinningWheel();
                if (LangDataConfig.isVerbose()) {
                    this.ctx.writeln(InitMessages.getString("INSTALL_DBMS_CLOUD_VERBOSE"));
                } else {
                    long endTime = System.currentTimeMillis();
                    GeneralMessages.printSuccessStatus(step, InitMessages.getString("INSTALL_DBMS_CLOUD_LOG"), InitMessages.getString("STEP_OK"), LangUtils.getTimeInMilliSeconds(startTime, endTime));
                }
            }
            catch (IOException | InterruptedException e) {
                this.stopSpinningWheel();
                GeneralMessages.printErrorStatus(step, InitMessages.getString("INSTALL_DBMS_CLOUD_LOG"), InitMessages.getString("STEP_FAILED"));
                throw new LangDataException(e.getLocalizedMessage());
            }
        }
    }
}

