/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.langdata.commands.config.subcommand;

import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extension.langdata.commands.ConfigMessages;
import oracle.dbtools.extension.langdata.commands.handler.CommandInterface;
import oracle.dbtools.extension.langdata.commands.handler.LangDataOptions;
import oracle.dbtools.extension.langdata.core.LangDataConfig;
import oracle.dbtools.extension.langdata.core.messages.GeneralMessages;
import oracle.dbtools.extension.langdata.core.utils.LangDataQueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ConfigSetCommand
implements CommandInterface {
    @Override
    public void run(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand parsedCommand) {
        LangDataConfig.setupDebugVerbose(parsedCommand);
        String name = (String)parsedCommand.getOptionValue((Id)LangDataOptions.Symbols.NAME);
        String value = (String)parsedCommand.getOptionValue((Id)LangDataOptions.Symbols.VALUE);
        if (name == null || name.isEmpty()) {
            GeneralMessages.errorMessage(ConfigMessages.getString("NULL_CONFIG_NAME"));
        } else {
            DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
            HashMap<String, String> binds = new HashMap<String, String>();
            binds.put("config_name", name);
            binds.put("config_value", value);
            try {
                dbUtil.execute(LangDataQueryUtils.getXMLQueries().getQuery("langdata.updateconfig", conn).getSql(), binds);
                GeneralMessages.successMessage(ConfigMessages.format("SET_SUCCESS", name, value));
            }
            catch (Exception e) {
                GeneralMessages.errorMessage(ConfigMessages.format("UPDATE_ERROR", name));
                if (LangDataConfig.isDebug()) {
                    LangDataConfig.getCurrentContext().writeln(Arrays.toString(e.getStackTrace()));
                }
                LangDataConfig.getCurrentContext().writeln(e.getLocalizedMessage());
            }
        }
    }
}

