/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.importer.readers;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.cmdline.Messages;
import oracle.dbtools.importer.readers.DataReader;
import oracle.dbtools.importer.readers.DataReaderException;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class XLSReader
extends DataReader {
    private static final String PATTERN_TIMESTAMP = "YYYY-MM-DD HH24:MI";
    private static final String PATTERN_SHORT_DATE = "MM/dd/yyyy";
    private static final String PATTERN_LONG_DATE = "MMM/dd/yyyy";
    private Map<Sheet, Map<Integer, Integer>> sheetWidths = new HashMap<Sheet, Map<Integer, Integer>>();
    private Map<Integer, Integer> colwidths;
    public static String NAME = Messages.getString("XLSReader.0");
    public static final String FORMAT = "XLS";
    public static final String EXT = "xls";
    public static final String KEY_HEADER = "IMPORT_XLS_HEADER";
    private String _fileName;
    private FileInputStream _xlsFileReader;
    private Workbook _workbook;
    private FormulaEvaluator _evaluator;
    private int _skipRows = 0;
    private Sheet currentSheet;
    private Row headerRow;
    private int currentRow = 0;
    private int _colCount = 0;
    private static char _decimalSeparator = ((DecimalFormat)DecimalFormat.getInstance()).getDecimalFormatSymbols().getDecimalSeparator();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getType() {
        return EXT;
    }

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public List<Object[]> getPreviewRows() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        Object[] row = null;
        try {
            int last = this.currentSheet.getLastRowNum();
            int skipRows = this.getSkipRows();
            int first = this.getFirstNonEmptyRowNumber(skipRows);
            this._colCount = 0;
            for (int i = first; i <= last; ++i) {
                row = this.getRow(i);
                if (row == null) continue;
                if (row.length > this._colCount) {
                    this._colCount = row.length;
                }
                rows.add(row);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rows;
    }

    @Override
    public int getColumnCount() {
        int retVal = 0;
        short first = 0;
        short last = 0;
        if (this.isHeader()) {
            int skipRows = this.getSkipRows();
            int headerRowNumber = this.getFirstNonEmptyRowNumber(skipRows);
            this.headerRow = this.getHeaderRow();
            this.currentSheet.getRow(headerRowNumber);
            if (this.headerRow != null) {
                first = this.headerRow.getFirstCellNum();
                last = this.headerRow.getLastCellNum();
                retVal = first == 0 ? (int)last : last - first;
            }
            return retVal;
        }
        return this._colCount;
    }

    @Override
    public String[] getColumnNames() {
        int first = 0;
        short last = 0;
        if (this.isHeader()) {
            if (this.m_headerRowColumnNames == null) {
                if (this.headerRow == null) {
                    this.headerRow = this.getHeaderRow();
                }
                if (this.headerRow != null) {
                    first = this.headerRow.getFirstCellNum();
                    last = this.headerRow.getLastCellNum();
                }
                ArrayList<CallSite> names = new ArrayList<CallSite>();
                HashMap<CallSite, Integer> map = new HashMap<CallSite, Integer>();
                for (int i = first; i < last; ++i) {
                    String obStr;
                    int colNameIdx = i + 1;
                    Cell cell = this.headerRow.getCell(i);
                    Object ob = cell != null ? this.Value(cell) : null;
                    String string = obStr = ob != null ? ob.toString().toUpperCase().replaceAll(" ", "_") : this.getDefColumn() + colNameIdx;
                    if (cell != null) {
                        if (map.containsKey(obStr)) {
                            map.put((CallSite)((Object)obStr), (Integer)map.get(obStr) + 1);
                            names.add((CallSite)((Object)(obStr.toString() + String.valueOf(map.get(obStr)))));
                            continue;
                        }
                        map.put((CallSite)((Object)obStr), 1);
                        names.add((CallSite)((Object)obStr));
                        continue;
                    }
                    names.add((CallSite)((Object)(this.getDefColumn() + colNameIdx)));
                }
                this.m_headerRowColumnNames = names.toArray(new String[names.size()]);
            }
            return this.m_headerRowColumnNames;
        }
        return this.getDefaultColumnNames();
    }

    private Row getHeaderRow() {
        int skipRows = this.getSkipRows();
        int headerRowNumber = this.getFirstNonEmptyRowNumber(skipRows);
        return this.currentSheet.getRow(headerRowNumber);
    }

    private Object[] getRow(int rowNum) {
        Row row = this.currentSheet.getRow(rowNum);
        int lastCol = 0;
        String[] retVal = null;
        ArrayList<Object> objRow = new ArrayList<Object>();
        if (row != null) {
            boolean hasValue = false;
            lastCol = this.headerRow == null ? row.getLastCellNum() : this.headerRow.getLastCellNum();
            for (int i = 0; i < lastCol; ++i) {
                Cell cell = row.getCell(i);
                if (cell == null) {
                    objRow.add(null);
                    continue;
                }
                Object value = this.Value(cell);
                if (value != null) {
                    objRow.add(value);
                    hasValue = true;
                    continue;
                }
                objRow.add(null);
            }
            if (hasValue) {
                retVal = objRow.toArray(new String[objRow.size()]);
            }
        }
        return retVal;
    }

    @Override
    public boolean hasMoreRows() {
        return this.currentSheet != null && this.currentRow < this.currentSheet.getLastRowNum() + 1;
    }

    @Override
    public String getType(int columnPosition) {
        return null;
    }

    @Override
    public int getWidth(int columnPosition) {
        int startRow;
        this.colwidths = this.sheetWidths.get(this.currentSheet) != null ? this.sheetWidths.get(this.currentSheet) : new HashMap<Integer, Integer>();
        if (this.colwidths.get(columnPosition) != null) {
            return this.colwidths.get(columnPosition);
        }
        int width = 0;
        Row row = null;
        int skipRows = this.getSkipRows();
        for (int i = startRow = this.getFirstNonEmptyRowNumber(skipRows); i == 0 || i < this.currentSheet.getLastRowNum() + 1; ++i) {
            row = this.currentSheet.getRow(i);
            int tmpwidth = 1;
            if (row == null) continue;
            Cell cell = row.getCell(columnPosition);
            String tempVal = "";
            if (cell != null) {
                switch (cell.getCellType()) {
                    case STRING: {
                        if (cell.getStringCellValue() == null) {
                            tmpwidth = 0;
                            break;
                        }
                        tempVal = cell.getStringCellValue();
                        tmpwidth = tempVal != null ? tempVal.length() : 0;
                        break;
                    }
                    case FORMULA: {
                        short dataFormat;
                        double val;
                        CellValue cellValue = this._evaluator.evaluate(cell);
                        switch (cellValue.getCellType()) {
                            case BOOLEAN: {
                                tmpwidth = 0;
                                break;
                            }
                            case NUMERIC: {
                                val = cellValue.getNumberValue();
                                tempVal = DateUtil.isCellDateFormatted((Cell)cell) ? this.handleNumberValue(cell, val) : Double.toString(val);
                                tmpwidth = tempVal.length();
                                dataFormat = cell.getCellStyle().getDataFormat();
                                if (dataFormat != 0 && dataFormat != 49 || !tempVal.endsWith(".0")) break;
                                tmpwidth -= 2;
                                break;
                            }
                            case STRING: {
                                if (cellValue.getStringValue() == null) {
                                    tmpwidth = 0;
                                    break;
                                }
                                tempVal = cellValue.getStringValue();
                                tmpwidth = tempVal != null ? tempVal.length() : 0;
                                break;
                            }
                            case BLANK: {
                                tmpwidth = 0;
                                break;
                            }
                            case ERROR: {
                                tmpwidth = 0;
                            }
                        }
                        break;
                    }
                    case NUMERIC: {
                        double val = cell.getNumericCellValue();
                        tempVal = DateUtil.isCellDateFormatted((Cell)cell) ? this.handleNumberValue(cell, val) : Double.toString(val);
                        tmpwidth = tempVal.length();
                        short dataFormat = cell.getCellStyle().getDataFormat();
                        if (dataFormat != 0 && dataFormat != 49 || !tempVal.endsWith(".0")) break;
                        tmpwidth -= 2;
                        break;
                    }
                    default: {
                        tmpwidth = 0;
                    }
                }
            }
            if (tmpwidth <= width) continue;
            width = tmpwidth;
        }
        this.colwidths.put(columnPosition, width);
        this.sheetWidths.put(this.currentSheet, this.colwidths);
        return width;
    }

    @Override
    public int getNosPages() {
        try {
            if (this._workbook == null) {
                throw new DataReaderException(Messages.getString("XLSReader.2"));
            }
        }
        catch (DataReaderException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        try {
            return this._workbook.getNumberOfSheets();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public String[] getPageNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this._workbook.getNumberOfSheets(); ++i) {
            list.add(this._workbook.getSheetName(i));
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public String getPageLabel() {
        return Messages.getString("XLSReader.3");
    }

    public Sheet getCurrentPage() {
        return this.currentSheet;
    }

    @Override
    public void openFile(String filename) throws DataReaderException {
        Workbook workbook = null;
        try {
            this.closeFile();
            this._xlsFileReader = new FileInputStream(filename);
            workbook = this.newWorkbook(this._xlsFileReader);
            this.currentSheet = workbook.getSheetAt(0);
        }
        catch (DataReaderException dre) {
            this.closeFile();
            throw dre;
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            throw new DataReaderException(e.getMessage());
        }
        this._workbook = workbook;
        this._evaluator = this._workbook.getCreationHelper().createFormulaEvaluator();
        this._fileName = filename;
    }

    protected Workbook newWorkbook(FileInputStream reader) throws DataReaderException {
        try {
            return new HSSFWorkbook((InputStream)reader);
        }
        catch (Throwable e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            throw new DataReaderException(e.getMessage());
        }
    }

    @Override
    public void closeFile() {
        try {
            if (this._xlsFileReader != null) {
                this._xlsFileReader.close();
            }
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        this._xlsFileReader = null;
        this._workbook = null;
    }

    @Override
    public void start() throws DataReaderException {
        this.currentRow = 0;
        if (this._xlsFileReader == null) {
            this.openFile(this._fileName);
        }
    }

    private Object Value(Cell cell) {
        if (cell != null) {
            switch (cell.getCellType()) {
                case STRING: {
                    return cell.getStringCellValue() == null ? "" : cell.getStringCellValue();
                }
                case FORMULA: {
                    CellValue cellValue = this._evaluator.evaluate(cell);
                    switch (cellValue.getCellType()) {
                        case BOOLEAN: {
                            if (cellValue.getBooleanValue()) {
                                return "true";
                            }
                            return "false";
                        }
                        case NUMERIC: {
                            return this.handleNumberValue(cell, cellValue.getNumberValue());
                        }
                        case STRING: {
                            return cellValue.getStringValue() == null ? "" : cellValue.getStringValue();
                        }
                        case BLANK: 
                        case ERROR: {
                            return "";
                        }
                    }
                }
                case NUMERIC: {
                    return this.handleNumberValue(cell, cell.getNumericCellValue());
                }
                case BOOLEAN: {
                    if (cell.getBooleanCellValue()) {
                        return "true";
                    }
                    return "false";
                }
            }
            return null;
        }
        return null;
    }

    private String handleNumberValue(Cell cell, double d) {
        Object cellValueString = "";
        if (DateUtil.isCellDateFormatted((Cell)cell)) {
            short formatIndex = cell.getCellStyle().getDataFormat();
            Date date = cell.getDateCellValue();
            DataFormat dataFormat = this._workbook.createDataFormat();
            String dtFormat = dataFormat.getFormat(formatIndex);
            SimpleDateFormat format = new SimpleDateFormat();
            String javaPattern = this.getJavaPatternFromXLSDateFormat(dtFormat);
            if (dtFormat.equals("m/d/yy")) {
                javaPattern = PATTERN_SHORT_DATE;
            }
            try {
                if (javaPattern == null || javaPattern.isEmpty()) {
                    javaPattern = this.getDefaultJavaPattern(dtFormat);
                }
                format.applyPattern(javaPattern);
                cellValueString = format.format(date);
            }
            catch (Exception e) {
                try {
                    format.applyPattern(this.getDefaultJavaPattern(dtFormat));
                    cellValueString = format.format(date);
                }
                catch (Exception e2) {
                    cellValueString = date.toString();
                }
            }
        } else {
            Double val = d;
            short dataFormat = cell.getCellStyle().getDataFormat();
            cellValueString = val.toString();
            long intPart = val.longValue();
            double fracPart = val - (double)intPart;
            if ((dataFormat == 0 || dataFormat == 1 || dataFormat == 49) && fracPart == 0.0) {
                cellValueString = "" + intPart;
                return cellValueString;
            }
            cellValueString = ((String)cellValueString).replace('.', _decimalSeparator);
        }
        return cellValueString;
    }

    private String getDefaultJavaPattern(String xlsDtFormat) {
        if (xlsDtFormat.contains("h")) {
            return PATTERN_TIMESTAMP;
        }
        if (xlsDtFormat.contains("mmm")) {
            return PATTERN_LONG_DATE;
        }
        return PATTERN_SHORT_DATE;
    }

    private String getJavaPatternFromXLSDateFormat(String xlsDtFormat) {
        String javaPattern = xlsDtFormat.replace(";@", "");
        int localeSymbol = javaPattern.indexOf("]");
        if (localeSymbol != -1) {
            javaPattern = javaPattern.substring(localeSymbol + 1, javaPattern.length());
        }
        javaPattern = javaPattern.replace("m", "M");
        javaPattern = javaPattern.replace("MMMMM", "MMM");
        javaPattern = javaPattern.replace(":MM", ":mm");
        javaPattern = javaPattern.replace(":M", ":m");
        javaPattern = javaPattern.replace("dddd", "EEEE");
        javaPattern = javaPattern.replace("ddd", "EEE");
        javaPattern = javaPattern.replace("AM/PM", "a");
        if (!(javaPattern = javaPattern.replace("\\", "")).contains("a")) {
            javaPattern = javaPattern.replace("hh", "HH");
            javaPattern = javaPattern.replace("h", "HH");
        }
        return javaPattern;
    }

    @Override
    public void setPage(int pageid) throws DataReaderException {
        if (this._workbook == null) {
            this.openFile(this.getFileName());
        }
        this.currentSheet = this._workbook.getSheetAt(pageid);
    }

    @Override
    public Object[] readline() {
        if (this.isHeader()) {
            ++this.currentRow;
        }
        Object[] o = this.getRow(this.currentRow);
        ++this.currentRow;
        return o;
    }

    private int getFirstNonEmptyDataRowNumber(int skipRows) {
        int retVal = this.getFirstNonEmptyRowNumber(skipRows);
        if (retVal != -1 && this.isHeader()) {
            retVal = this.getFirstNonEmptyRowNumber(retVal + 1);
        }
        return retVal;
    }

    private int getFirstNonEmptyRowNumber(int skipRows) {
        Row row = null;
        int retVal = -1;
        for (int i = skipRows; i == 0 || this.currentSheet != null && i <= this.currentSheet.getLastRowNum(); ++i) {
            if (this.currentSheet != null) {
                row = this.currentSheet.getRow(i);
            }
            if (row == null) continue;
            retVal = i;
            break;
        }
        return retVal;
    }

    private Row getFirstNonEmptyRow() {
        Row row = null;
        for (int i = 0; (i == 0 || this.currentSheet != null && i < this.currentSheet.getLastRowNum()) && (row = this.currentSheet.getRow(i)) == null; ++i) {
        }
        return row;
    }

    @Override
    public boolean isOracleLoaderReadable() {
        return false;
    }

    @Override
    public boolean isEncodingAllowed() {
        return false;
    }

    public String getHeaderConfigKey() {
        return KEY_HEADER;
    }

    @Override
    public int getHeaderLocation() {
        return 0;
    }

    @Override
    public void setHeaderLocation(int headerLocation) {
    }

    public int getSkipRows() {
        return this._skipRows;
    }

    @Override
    public boolean isHeader() {
        return this.currentRow == 0;
    }
}

