/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.formatter;

import java.awt.Font;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Connection;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.format.FormatterService;
import oracle.dbtools.raptor.format.IResultFormatter;
import oracle.dbtools.raptor.format.Messages;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.sql.DATE;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class XLSFormatter
extends ResultsFormatter
implements FormatterService {
    public static String TYPE = "XLS";
    public static String EXT = "xls";
    public static String XLS_HEADER = "EXPORT_XLS_HEADER";
    public static String XLS_SAVE_QUERY = "EXPORT_XLS_SAVE_QUERY";
    public static String XLS_QUERY_WS_NAME = "EXPORT_XLS_QUERY_WS_NAME";
    public static String XLS_WS_NAME = "EXPORT_XLS_WS_NAME";
    protected Workbook workbook;
    protected Sheet sheet;
    protected CreationHelper _creationHelper;
    protected int _sheetIndex = 0;
    protected long _rownum;
    protected Row _currRow;
    private Cell _currCell;
    private CellStyle _rightAlign;
    private CellStyle _fullDateStyle;
    private CellStyle _shortDateStyle;
    private long _cell;
    private boolean _isHeader;
    private boolean _saveQuery;
    private boolean _isDataNameUser = false;
    private String _queryName;
    private String _dataName;
    private String _dataNameUser;
    private String _tableName;

    public XLSFormatter() {
        super(TYPE, "XLSXFormatter.0", EXT);
    }

    public XLSFormatter(String type, String filter, String ext) {
        super(type, filter, ext);
    }

    protected Workbook newWorkbook() {
        return new HSSFWorkbook();
    }

    protected void createWorkBook() {
        if (this._sheetIndex == 0) {
            this.workbook = this.newWorkbook();
        }
        this._dataName = this._isDataNameUser ? this._dataNameUser : (this.isNotNullAndNotBlack(this._tableName) ? this._tableName : Messages.getString((String)"ExcelFormatter.3"));
        this._dataName = this.getUniqueSheetName(this._dataName);
        this.sheet = this.workbook.createSheet(this._dataName);
        this._creationHelper = this.workbook.getCreationHelper();
    }

    private String getUniqueSheetName(String sheetName) {
        Integer suffix = new Integer(1);
        Object name = sheetName.replaceAll("[\\\\\\[\\]\\?\\*\\:\\/]", "");
        int len = sheetName.length();
        if (len > 30) {
            name = sheetName.substring(0, 30);
        }
        String origname = name;
        Sheet sheet = this.workbook.getSheet((String)name);
        while (sheet != null) {
            name = origname + "_" + (suffix = Integer.valueOf(suffix + 1)).toString();
            sheet = this.workbook.getSheet((String)name);
            if (sheet != null || ((String)name).length() <= 30) continue;
            if ((origname = origname.substring(0, origname.length() - 1)).length() < 2) {
                return origname;
            }
            suffix = 1;
            name = origname;
            sheet = this.workbook.getSheet((String)name);
        }
        return name;
    }

    public void setTableName(String tName) {
    }

    public void start() throws IOException {
        this.createWorkBook();
        this._rightAlign = this.workbook.createCellStyle();
        this._rightAlign.setAlignment(HorizontalAlignment.RIGHT);
        org.apache.poi.ss.usermodel.Font font = this.workbook.createFont();
        font.setFontName(Font.decode(null).getName());
        this._rightAlign.setFont(font);
        this._fullDateStyle = this.workbook.createCellStyle();
        this._fullDateStyle.setDataFormat(this._creationHelper.createDataFormat().getFormat("m/d/yyyy h:mm AM/PM"));
        this._shortDateStyle = this.workbook.createCellStyle();
        this._shortDateStyle.setDataFormat(this._creationHelper.createDataFormat().getFormat("m/d/yyyy"));
        this._currRow = null;
        this._currCell = null;
        if (this.isHeader()) {
            this._rownum = 0L;
            short s = Short.valueOf("" + this._rownum);
            this._currRow = this.sheet.createRow((int)s);
            int cell = 0;
            int size = this.getColumnCount();
            for (int i = 0; i < size; ++i) {
                this._currCell = this._currRow.createCell(cell);
                this._currCell.setCellValue(this.getColumnName(i));
                ++cell;
            }
            this.sheet.createFreezePane(0, 1, 0, 1);
        } else {
            this._rownum = -1L;
        }
    }

    public void startRow() throws IOException {
        if (this._rownum > (long)this.getRowLimit()) {
            this.sheet = this.workbook.createSheet();
            this._rownum = 0L;
        }
        ++this._rownum;
        int s = Integer.valueOf(new String("" + this._rownum));
        this._currRow = this.sheet.createRow(s);
    }

    protected int getRowLimit() {
        return 65000;
    }

    public void printColumn(Object col, int viewIndex, int modelIndex) throws IOException {
        try {
            this._currCell = this._currRow.createCell(viewIndex);
            ++this._cell;
            int type = 0;
            try {
                type = this.getDataType(viewIndex);
            }
            catch (Exception e) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            switch (type) {
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: {
                    BigDecimal bd = null;
                    if (col != null) {
                        this._currCell.setCellStyle(this._rightAlign);
                        try {
                            bd = new BigDecimal(col.toString());
                        }
                        catch (Exception bde) {
                            bd = new BigDecimal(this.getValue(col).replace(",", "."));
                        }
                        NLSUtils.format((Connection)this.getConnection(), (Object)bd);
                        this._currCell.setCellValue(bd.doubleValue());
                        break;
                    }
                    this._currCell.setCellValue("");
                    break;
                }
                case 91: {
                    if (col != null) {
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(((DATE)col).dateValue());
                        int hour = cal.get(11);
                        this._currCell.setCellStyle(hour != 0 ? this._fullDateStyle : this._shortDateStyle);
                        this._currCell.setCellValue(cal);
                    }
                    break;
                }
                default: {
                    if (col != null) {
                        this._currCell.setCellValue(this.getValue(col));
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public void endRow() throws IOException {
        this._cell = 0L;
    }

    public void end() throws IOException {
        String sql;
        if (this._saveQuery && (sql = this.getWrapper().getSQL()) != null) {
            this.sheet = this.workbook.getSheetAt(this._sheetIndex);
            this.sheet.setFitToPage(true);
            if (this._queryName == null || this._queryName.trim().length() == 0) {
                this._queryName = "SQL";
            }
            this.sheet = this.workbook.getSheet(this._queryName);
            if (this.sheet == null) {
                this.sheet = this.workbook.createSheet(this._queryName);
            }
            this._currRow = this.sheet.createRow(this._sheetIndex + 1);
            int s = 0;
            this._currCell = this._currRow.createCell(s);
            this._currCell.setCellValue(sql);
            boolean bl = true;
        }
        ++this._sheetIndex;
        this.write();
    }

    public boolean allowsLobs() {
        return true;
    }

    public boolean isHeaderOptionSupported() {
        return true;
    }

    public void isHeader(boolean isHeader) {
        this._isHeader = isHeader;
    }

    public boolean isHeader() {
        return this._isHeader;
    }

    public boolean isDataNameSupported() {
        return true;
    }

    public String getDataName() {
        return this._dataName;
    }

    public void setDataName(String name) {
        if (this.isNotNullAndNotBlack(name)) {
            this._isDataNameUser = true;
            this._dataNameUser = name;
        }
    }

    public boolean isQuerySupported() {
        return true;
    }

    public boolean isQuerySaved() {
        return this._saveQuery;
    }

    public void isQuerySaved(boolean value) {
        this._saveQuery = value;
    }

    public String getQueryName() {
        return this._queryName;
    }

    public void setQueryName(String name) {
        this._queryName = name;
    }

    public String getHeaderConfigKey() {
        return XLS_HEADER;
    }

    public String getDataNameConfigKey() {
        return XLS_WS_NAME;
    }

    public String getQueryConfigKey() {
        return XLS_SAVE_QUERY;
    }

    public String getQueryNameConfigKey() {
        return XLS_QUERY_WS_NAME;
    }

    public int validateOptions() {
        int status = 0;
        try {
            if (this._saveQuery && this._queryName != null && this.isNotNullAndNotBlack(this._dataName) && this._queryName.trim().equals(this._dataName.trim())) {
                this.setValidationMessage(Messages.getString((String)"XLSFormatter.NameError"));
                status = 1;
            }
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, e.getStackTrace()[0].toString(), e);
        }
        return status;
    }

    protected String getValue(Object col) {
        try {
            if (col instanceof Clob) {
                Clob clob = (Clob)col;
                int length = 4000;
                StringBuffer value = new StringBuffer();
                while ((long)value.length() < clob.length()) {
                    value.append(clob.getSubString(value.length() + 1, length));
                }
                return value.toString();
            }
            return super.getValue(col).toString();
        }
        catch (Exception e) {
            Logger.getLogger(DataTypesUtil.class.getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            return null;
        }
    }

    protected void write() throws IOException {
        if (null != this.workbook) {
            this.workbook.write(this.getOutputStream());
        }
    }

    protected boolean isNotNullAndNotBlack(String s) {
        return s != null && !s.isBlank();
    }

    public Class<? extends IResultFormatter> getFormatterClass() {
        return ((Object)((Object)this)).getClass();
    }
}

