/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.cmdline;

import java.io.OutputStream;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.arbori.util.DbObjNames;
import oracle.dbtools.cmdline.ExportCL;
import oracle.dbtools.cmdline.ExportToolRunModeCL;
import oracle.dbtools.cmdline.Messages;
import oracle.dbtools.common.ddl.DDLFormat;
import oracle.dbtools.common.ddl.DDLTypes;
import oracle.dbtools.common.ddl.TargetFormat;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.loadservice.LoadParmsAPI;
import oracle.dbtools.data.readservice.ReadParmsDelimitedAPI;
import oracle.dbtools.datatools.BaseDataFormat;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.export.ExportResources;
import oracle.dbtools.export.service.ExportParms;
import oracle.dbtools.export.service.ExportServiceType;
import oracle.dbtools.extract.ExtractReconciler;
import oracle.dbtools.extract.models.ExtractDataFormat;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.http.CloudStorageUrl;
import oracle.dbtools.net.commands.CloudStorageCommand;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.Connected;
import oracle.dbtools.raptor.newscriptrunner.commands.SetLoadFormat;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.utils.IToolRunMode;
import oracle.dbtools.raptor.utils.ToolLogger;

public class UnLoadCommand
extends CommandListener
implements IHelp,
IShowCommand,
Connected {
    private static final String LIST = "list";
    private static final String SCHEMA = "$$schema";
    private static final String TABLE = "table";
    private static final String CLOUD_STORAGE = "cloud_storage";
    private static final String CLOUDSTORAGE = "cloudstorage";
    private static final String CLOUD_URL = "cloud_url";
    private static final String OCI_PROFILE_NAME = "oci.profile.name";
    private static final String CS = "cs";
    private static final String DIRECTORY = "directory";
    private static final String DIR = "dir";
    private static final String DQUOTE = "\"";
    private static final String NL = "\n";
    private static final String SPACE = " ";
    private static final String SQUOTE = "'";
    private CloudStorageUrl _cloudStorageUrl;
    private String _filename;
    private String _responseName;
    private Connection _conn;
    private ScriptRunnerContext _ctx;
    private Map<String, Object> _csProps;
    private String _schema;
    private String _table;
    private String _qualifier;
    private TargetFormat _targetFormat;
    private static final String DEFAULT_LANG = "en";
    private static final String DEFAULT_COUNTRY = "US";

    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return false;
    }

    public String getCommand() {
        return "UNLOAD";
    }

    public String getHelp() {
        return CommandsHelp.getString((String)this.getCommand());
    }

    public boolean isSqlPlus() {
        return false;
    }

    public String getDescription() {
        return Messages.get("UNLOAD_DESCRIPTION");
    }

    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("unload")) {
            return false;
        }
        boolean isValid = true;
        boolean isSchemaUnload = false;
        boolean isTableUnload = false;
        boolean isListUnload = false;
        this._cloudStorageUrl = null;
        this._ctx = ctx;
        this._table = null;
        this._schema = null;
        this._qualifier = null;
        String sql = cmd.getSql().trim();
        String[] cmds = sql.split(SPACE);
        try {
            if (conn != null) {
                this._conn = conn;
                this._filename = (String)ctx.getMap().get(ScriptRunnerContext.SqlplusVariable._PWD.toString());
                this._targetFormat = new TargetFormat();
                this._targetFormat.isCloudStorage(false);
                this._targetFormat.setSaveAs(this._filename);
                this._targetFormat.setSaveAsType(1);
                String connNamex = DQUOTE + String.valueOf(ctx.getProperty("cli.conn.name")) + DQUOTE;
                String connName = ConnectionResolver.getConnectionName((Connection)this._conn);
                int length = cmds.length;
                String format = (String)ctx.getProperty("load.format");
                if (format == null) {
                    format = ExtractDataFormat.CSV;
                    ctx.putProperty("load.format", (Object)ExtractDataFormat.CSV);
                }
                String[] bits = sql.split(" (?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)");
                ExtractReconciler.ReconcileType reconcilerType = ExtractReconciler.ReconcileType.NONE;
                int skip = 1;
                while (bits != null && bits.length > 0) {
                    String str = "";
                    int i = skip;
                    String opt = bits[skip].toLowerCase();
                    try {
                        switch (bits[skip].toLowerCase()) {
                            case "$$schema": {
                                reconcilerType = ExtractReconciler.ReconcileType.TYPES_AND_OBJECTS;
                                isSchemaUnload = true;
                                if (bits.length < skip + 2 || this.isOption(bits[skip + 1])) {
                                    this._schema = ConnectionResolver.getConnection((String)connName).getSchema();
                                    bits = this.nextBits(bits, skip + 1);
                                    break;
                                }
                                if (!this.validateSchema(bits[skip + 1])) {
                                    isValid = false;
                                    this.writeValueBad(ctx, bits[skip] + SPACE + bits[skip + 1]);
                                }
                                bits = this.nextBits(bits, skip + 2);
                                break;
                            }
                            case "table": {
                                List objectNameTokens = Lexer.parse((String)bits[2]);
                                if (bits.length < skip + 2 || this.isOption(bits[skip + 1])) {
                                    this.writeValueMissing(ctx, bits[skip]);
                                    return false;
                                }
                                if (!this.setTable(objectNameTokens)) {
                                    isValid = false;
                                    ctx.write(NL + MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOAD_TABLE_ERR"), this._schema + "." + this._table) + NL);
                                }
                                if (this._schema == null || this._schema.trim().isEmpty()) {
                                    this._schema = ConnectionResolver.getConnection((String)connName).getSchema();
                                }
                                isTableUnload = true;
                                bits = this.nextBits(bits, skip + 2);
                                break;
                            }
                            case "list": {
                                bits = this.nextBits(bits, skip + 1);
                            }
                            case "cloudstorage": 
                            case "cloud_storage": 
                            case "cs": {
                                if (format.equals("loader")) {
                                    ctx.write(MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"CS_FORMAT_NS"), format) + NL);
                                    return true;
                                }
                                this._csProps = (Map)ctx.getProperty("cloud.storage");
                                CloudStorageUrl csUrl = null;
                                if (this._csProps != null) {
                                    csUrl = (CloudStorageUrl)this._csProps.get(CLOUD_URL);
                                }
                                this._csProps.remove("qualifier");
                                if (bits.length > skip + 1) {
                                    try {
                                        this._qualifier = bits[1];
                                        if (csUrl == null) {
                                            this._cloudStorageUrl = new CloudStorageUrl(bits[1]);
                                        } else {
                                            this._cloudStorageUrl = new CloudStorageUrl(csUrl.getFinalUrl());
                                            this._cloudStorageUrl.qualifiedUrl(bits[1]);
                                        }
                                    }
                                    catch (Exception e) {
                                        String msg = e.getLocalizedMessage();
                                        ctx.write(MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"CS_INVALID_CS"), msg) + NL);
                                        isValid = false;
                                    }
                                    bits = this.nextBits(bits, skip + 2);
                                } else {
                                    if (csUrl != null) {
                                        this._cloudStorageUrl = new CloudStorageUrl(csUrl.getFinalUrl());
                                    }
                                    bits = this.nextBits(bits, skip + 1);
                                }
                                ctx.write(NL);
                                CloudStorageCommand.showParms((ScriptRunnerContext)ctx, this._csProps);
                                if (this._qualifier != null) {
                                    ctx.write(MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"CS_QUALIFIER"), this._qualifier) + NL);
                                }
                                if (this._cloudStorageUrl != null) {
                                    ctx.write(MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"CS_TARGET"), this._cloudStorageUrl.getFinalUrl()) + NL);
                                } else {
                                    ctx.write(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"CS_NO_OBJECT") + NL);
                                    isValid = false;
                                }
                                String profile = (String)this._ctx.getProperty(OCI_PROFILE_NAME);
                                if (!isValid) break;
                                try {
                                    this._cloudStorageUrl.validateUrlAsBucket();
                                }
                                catch (Exception e) {
                                    String msg = e.getLocalizedMessage();
                                    ctx.write(MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"CS_INVALID_CS"), msg) + NL);
                                    isValid = false;
                                }
                                this._targetFormat.isCloudStorage(true);
                                this._targetFormat.setCloudStorageAuth(profile);
                                this._csProps.put("qualifier", this._qualifier);
                                this._targetFormat.setSaveAs(this._cloudStorageUrl.getFinalUrl().toString());
                                this._targetFormat.setCloudStorageProps(this._csProps);
                                break;
                            }
                            case "directory": 
                            case "dir": {
                                if (bits.length < skip + 2) {
                                    this.writeValueMissing(ctx, bits[skip]);
                                    return true;
                                }
                                this._filename = bits[skip + 1];
                                this._targetFormat.setSaveAs(this._filename);
                                if (!this.validateFile()) {
                                    isValid = false;
                                }
                                bits = this.nextBits(bits, skip + 2);
                                break;
                            }
                            default: {
                                if (this._table != null) {
                                    this.writeValueBad(ctx, bits.length > skip ? bits[skip] : "");
                                    return true;
                                }
                                List objectNameTokens = Lexer.parse((String)bits[1]);
                                if (!this.setTable(objectNameTokens)) {
                                    isValid = false;
                                    ctx.write(NL + MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOAD_TABLE_ERR"), this._schema + "." + this._table) + NL);
                                }
                                if (this._schema == null || this._schema.trim().isEmpty()) {
                                    this._schema = ConnectionResolver.getConnection((String)connName).getSchema();
                                }
                                isTableUnload = true;
                                bits = this.nextBits(bits, skip + 1);
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        this.writeValueBad(ctx, bits.length > skip ? bits[skip] : "");
                        return true;
                    }
                    skip = 0;
                }
                if (isValid) {
                    ReadParmsDelimitedAPI.Builder delimParmsBuilder = (ReadParmsDelimitedAPI.Builder)ctx.getProperty("load.format.options");
                    ReadParmsDelimitedAPI delimParms = null;
                    if (delimParmsBuilder != null) {
                        delimParms = delimParmsBuilder.build();
                        SetLoadFormat.showParmsUnload((ScriptRunnerContext)ctx, (ReadParmsDelimitedAPI)delimParms);
                    } else {
                        delimParms = new ReadParmsDelimitedAPI.Builder().build();
                        SetLoadFormat.showParmsUnload((ScriptRunnerContext)ctx, (ReadParmsDelimitedAPI)delimParms);
                    }
                    LoadParmsAPI.Builder loadParmsBuilder = (LoadParmsAPI.Builder)ctx.getProperty("load.method.insert");
                    LoadParmsAPI loadParms = null;
                    if (loadParmsBuilder != null && (loadParms = loadParmsBuilder.build()).getLocale() == null) {
                        loadParmsBuilder.locale(UnLoadCommand.getLocale());
                        loadParms = loadParmsBuilder.build();
                    }
                    ExtractDataFormat dataFormat = new ExtractDataFormat(BaseDataFormat.EXPORT_WIZARD);
                    dataFormat.setFormat(format);
                    dataFormat.setDelimiter(delimParms.getDelimiter());
                    dataFormat.setEnclosureLeft(delimParms.getEnclosureLeft());
                    dataFormat.setEnclosureRight(delimParms.getEnclosureRight());
                    dataFormat.setEncoding(delimParms.getEncoding());
                    this._targetFormat.setEncoding(dataFormat.getEncoding());
                    dataFormat.isHeader(delimParms.isHeader());
                    if (delimParms.getTerminator() != null) {
                        dataFormat.setRecordTerminator(delimParms.getTerminator());
                    }
                    ExtractListModel listModel = new ExtractListModel();
                    listModel.setSourceConnName(connName);
                    listModel.setReconcileType(reconcilerType);
                    DDLFormat ddlFormat = new DDLFormat();
                    ddlFormat.setAllOptionsEnabled(false);
                    listModel.setDDLFormat(ddlFormat);
                    DDLTypes types = new DDLTypes();
                    types.setEnable(false);
                    types.setTable(true);
                    listModel.setDDLTypes(types);
                    listModel.setDataFormat(dataFormat);
                    boolean doUnload = true;
                    if (isTableUnload) {
                        BasicDBObject dbo = BasicDBObject.builder().connName(connName).schema(this._schema).objectType("TABLE").objectName(this._table).build();
                        dbo.setConnection(this._conn);
                        listModel.getOrAddExtractObject(dbo);
                        for (ExtractObject eo : listModel.getList(0)) {
                            if (ExtractReconciler.reconcileExistence(eo)) {
                                eo.isExtractData(true);
                                continue;
                            }
                            ctx.write(MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"UNLOAD_TABLE_NOT_EXISTS"), dbo.getObjectType(), this._schema + "." + this._table) + NL);
                            doUnload = false;
                        }
                    } else if (isSchemaUnload) {
                        listModel.setSchemas(new String[]{this._schema});
                    }
                    if (!doUnload) {
                        return true;
                    }
                    ExportParms eParms = new ExportParms();
                    eParms.setDataFormat(dataFormat);
                    eParms.setDDLFormat(ddlFormat);
                    eParms.setDestConnName("");
                    eParms.setDestSchema(this._schema);
                    eParms.setListModel(listModel);
                    eParms.setName("UNLOAD");
                    eParms.setTargetFormat(this._targetFormat);
                    eParms.setSaveAs(this._filename);
                    eParms.setSaveAsType(1);
                    eParms.setServiceType(ExportServiceType.STANDARD);
                    eParms.isLogTimings(ctx.getTiming());
                    ExportToolRunModeCL tRunMode = new ExportToolRunModeCL();
                    tRunMode.setRunMode(IToolRunMode.RunMode.NO_GUI);
                    tRunMode.setParms(eParms);
                    tRunMode.setEncoding(ctx.getEncoding());
                    tRunMode.setLineTerminator(System.getProperty("line.separator"));
                    tRunMode.isShowELog(false);
                    tRunMode.setToolLogger(new ToolLogger((OutputStream)ctx.getOutputStream()));
                    eParms.setToolRunMode(tRunMode);
                    ExportCL export = new ExportCL();
                    ExitCode exitCode = export.run(eParms);
                    if (exitCode == ExitCode.EXIT_WARNING) {
                        ctx.write(ExportResources.get("EXIT_WARNING_UNLOAD") + NL);
                    } else if (exitCode == ExitCode.EXIT_ERROR) {
                        ctx.write(ExportResources.get("EXIT_ERROR_UNLOAD") + NL);
                    } else if (exitCode == ExitCode.EXIT_SEVERE) {
                        ctx.write(ExportResources.get("EXIT_SEVERE_UNLOAD") + NL);
                    }
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            String msg = e.getLocalizedMessage();
            ctx.write(msg + NL);
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, msg);
            return true;
        }
    }

    private boolean isOption(String word) {
        try {
            switch (word) {
                case "dir": 
                case "directory": 
                case "list": 
                case "$$schema": 
                case "table": {
                    return true;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private String[] nextBits(String[] bits, int skip) {
        if (bits.length > skip) {
            String[] rtn = new String[bits.length - skip];
            for (int j = 0; rtn.length > j; ++j) {
                rtn[j] = bits[j + skip];
            }
            return rtn;
        }
        return null;
    }

    private boolean validateFile() {
        int valResult = this._targetFormat.validateSaveAsDir(null, true);
        switch (valResult) {
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
        }
        return true;
    }

    private boolean validateSchema(String schema) {
        this._schema = schema;
        this._schema = this._schema != null && !this._schema.startsWith(DQUOTE) && !this._schema.endsWith(DQUOTE) ? this._schema.toUpperCase() : schema;
        return ExtractReconciler.isExistsSchema(this._conn, this._schema);
    }

    private boolean setTable(List<LexerToken> objectNameTokens) {
        this._schema = this.getObjectOwner(objectNameTokens);
        this._table = this.getObjectName(objectNameTokens);
        return true;
    }

    private String getObjectName(List<LexerToken> objectNameTokens) {
        if (objectNameTokens.size() == 1) {
            return DbObjNames.handleMixedCase((String)objectNameTokens.get((int)0).content.toString());
        }
        if (objectNameTokens.size() == 3) {
            return DbObjNames.handleMixedCase((String)objectNameTokens.get((int)2).content.toString());
        }
        return "";
    }

    private String getObjectOwner(List<LexerToken> objectNameTokens) {
        if (objectNameTokens.size() == 1) {
            return "";
        }
        if (objectNameTokens.size() == 3) {
            return DbObjNames.handleMixedCase((String)objectNameTokens.get((int)0).content.toString());
        }
        return "";
    }

    private static Locale getLocale() {
        String lang = DEFAULT_LANG;
        String country = DEFAULT_COUNTRY;
        if (System.getProperty("user.language") != null && !System.getProperty("user.language").trim().equals("")) {
            lang = System.getProperty("user.language");
        }
        if (System.getProperty("user.country") != null && !System.getProperty("user.country").trim().equals("")) {
            country = System.getProperty("user.country");
        }
        Locale locale = new Locale(lang, country);
        return locale;
    }

    private void writeValueBad(ScriptRunnerContext ctx, String option) {
        ctx.write(NL + MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOADBADVALUE"), option) + NL);
    }

    private void writeValueMissing(ScriptRunnerContext ctx, String option) {
        ctx.write(NL + MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOADMISSINGVALUE"), option) + NL);
    }

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public String[] getShowAliases() {
        return new String[]{this.getCommand()};
    }

    public boolean needsDatabase() {
        return false;
    }

    public boolean inShowAll() {
        return false;
    }

    public boolean needsConnection() {
        return true;
    }
}

