/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.cmdline;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipFile;
import oracle.dbtools.cmdline.Messages;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.loadservice.LoadAPI;
import oracle.dbtools.data.loadservice.LoadParmsAPI;
import oracle.dbtools.data.readservice.ReadParmsAPI;
import oracle.dbtools.data.readservice.ReadParmsDelimitedAPI;
import oracle.dbtools.extract.ExtractReconciler;
import oracle.dbtools.http.CloudStorageUrl;
import oracle.dbtools.importer.readers.ReadParmsXLSAPI;
import oracle.dbtools.importer.readers.XLSReaderService;
import oracle.dbtools.importer.readers.XLSXReader;
import oracle.dbtools.net.commands.CSCommon;
import oracle.dbtools.net.commands.CloudStorageCommand;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.Connected;
import oracle.dbtools.raptor.newscriptrunner.commands.SetLoad;
import oracle.dbtools.raptor.newscriptrunner.commands.SetLoadFormat;
import oracle.dbtools.raptor.utils.ToolLogger;
import oracle.dbtools.raptor.utils.ToolLoggerResources;
import oracle.dbtools.transfer.location.Location;

public class LoadCommand
extends CommandListener
implements IHelp,
Connected {
    private static final String CSV = "csv";
    private static final String CS = "cs";
    private static final String CLOUDSTORAGE = "cloudstorage";
    private static final String CLOUD_STORAGE = "cloud_storage";
    private static final String CREATE = "create";
    private static final String CREATE_DDL = "create_ddl";
    private static final String NEW = "new";
    private static final String SHOW = "show";
    private static final String SHOW_DDL = "show_ddl";
    private static final String TABLE = "table";
    private static final String NL = "\n";
    private static final String SPACE = " ";
    private CloudStorageUrl _cloudStorageUrl;
    private String _qualifier;
    private String _fileName;
    private String _execPath;
    private Connection _conn;
    private ScriptRunnerContext _ctx;
    private Map<String, Object> _csProps;
    private String _schema;
    private String _table;
    private File _loadFile;
    private File _responseFile;
    private InputStream _input;
    private ZipFile _zipFile;
    private OutputStream _output;
    private Location _location;
    private boolean _isNew;
    private boolean _isDdlCreate;
    private boolean _isDdlShow;
    private boolean _isLoad;
    private static final String DEFAULT_LANG = "en";
    private static final String DEFAULT_COUNTRY = "US";

    public String getCommand() {
        return "LOAD";
    }

    public String getHelp() {
        return CommandsHelp.getString((String)this.getCommand());
    }

    public boolean isSqlPlus() {
        return false;
    }

    public String getDescription() {
        return Messages.get("LOAD_DESCRIPTION");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("load")) {
            return false;
        }
        boolean isValid = true;
        this._ctx = ctx;
        String sql = cmd.getSql().trim();
        String[] cmds = sql.split(SPACE);
        int length = cmds.length;
        this._conn = conn;
        if (cmds.length < 2 || cmds.length == 2 && cmds[1].equalsIgnoreCase("help")) {
            ctx.write(this.getHelp());
            return true;
        }
        if (length == 1) {
            ctx.write(this.getHelp());
            return true;
        }
        if (length > 7) {
            ctx.write(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOAD_INCOMPLETE_CMD") + NL);
            ctx.write(this.getHelp());
            return false;
        }
        if (conn == null) {
            ctx.write(NL + oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOAD_TABLE_CONN_ERR") + NL);
            ScriptUtils.doWhenever((ScriptRunnerContext)ctx, (ISQLCommand)cmd, (Connection)ctx.getCurrentConnection(), (boolean)false);
            return true;
        }
        this._conn = conn;
        this._cloudStorageUrl = null;
        this._fileName = null;
        this._qualifier = null;
        this._isLoad = true;
        this._isNew = false;
        this._isDdlCreate = false;
        this._isDdlShow = false;
        String process = oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOAD_DATA");
        int next = 1;
        try {
            if (length > next && cmds[next].equalsIgnoreCase(TABLE)) {
                ++next;
            }
            String object = null;
            if (length > next) {
                object = cmds[next];
                if (!this.validateTable(object)) {
                    isValid = false;
                    ctx.write(MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOAD_TABLE_ERR"), this._schema + "." + this._table) + NL);
                }
                ++next;
            } else {
                ctx.write(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOAD_INCOMPLETE_CMD") + SPACE + oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOAD_TABLE_MISSING") + NL);
                isValid = false;
            }
            if (length > next && (cmds[next].equalsIgnoreCase(CLOUDSTORAGE) || cmds[next].equalsIgnoreCase(CS) || cmds[next].equalsIgnoreCase(CLOUD_STORAGE))) {
                if (length > ++next) {
                    this._qualifier = cmds[next];
                    ++next;
                }
                isValid = this.handleCloudStorage(this._qualifier);
            } else if (length > next) {
                Path cwd;
                this._fileName = cmds[next];
                if (!Paths.get(this._fileName, new String[0]).toFile().exists() && !this._fileName.startsWith((cwd = Paths.get(ctx.prependCD(""), new String[0])).toString())) {
                    Path searchFile = Paths.get(cwd.toString(), this._fileName);
                    if (!searchFile.toFile().exists()) {
                        Path _execPath = Paths.get(ctx.getSourceRef(), new String[0]).getParent();
                        if (!this._fileName.startsWith(_execPath.toString())) {
                            searchFile = Paths.get(_execPath.toString(), this._fileName);
                            if (!searchFile.toFile().exists()) throw new IOException("FILE NAME NOT FOUND");
                            this._fileName = searchFile.toString();
                        }
                    } else {
                        this._fileName = searchFile.toString();
                    }
                }
                ++next;
                if (!this.validateFile(this._fileName)) {
                    isValid = false;
                    ctx.write(MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOAD_FILE_ERR"), this._fileName) + NL);
                }
            } else {
                isValid = false;
                ctx.write(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOAD_FILE_MISSING") + NL);
            }
            if (length > next && cmds[next].equalsIgnoreCase(NEW)) {
                this._isNew = true;
                process = oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOAD_NEW");
                ++next;
            } else if (length > next && (cmds[next].equalsIgnoreCase(SHOW) || cmds[next].equalsIgnoreCase(SHOW_DDL))) {
                this._isDdlShow = true;
                process = oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOAD_SHOW_DDL");
                this._isLoad = false;
                ++next;
            } else if (length > next && (cmds[next].equalsIgnoreCase(CREATE) || cmds[next].equalsIgnoreCase(CREATE_DDL))) {
                this._isDdlCreate = true;
                process = oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOAD_CREATE_DDL");
                this._isLoad = false;
                ++next;
            } else if (length > next) {
                ctx.write(MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"UNLOAD_UNKNOWN_OPT"), cmds[next]) + NL);
                return true;
            }
            String format = (String)ctx.getProperty("load.format");
            if (format == null) {
                format = CSV;
                ctx.putProperty("load.format", (Object)CSV);
            }
            if (this.isUnSupportedFormat(format)) {
                isValid = false;
                ctx.write(MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOAD_FORMAT_ERR"), format) + NL);
                return true;
            }
            if (this._isNew || this._isDdlCreate) {
                if (ExtractReconciler.isExistsObject(this._conn, this._schema, this._table, "TABLE")) {
                    ctx.write(MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOAD_TABLE_EXISTS"), this._schema + "." + this._table) + NL);
                    isValid = false;
                }
            } else if (!this._isDdlShow && !ExtractReconciler.isExistsObject(this._conn, this._schema, this._table, "TABLE")) {
                ctx.write(MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOAD_TABLE_NOT_EXISTS"), this._schema + "." + this._table) + NL);
                isValid = false;
            }
            ExitCode exitCode = ExitCode.EXIT_SUCCESS;
            if (isValid) {
                Object readParmsAPI;
                if (this._fileName != null && this.formatDoesNotMatchFileExtension(this._fileName, format)) {
                    ctx.writeln(Messages.getString("DATA_FILE_DOES_NOT_MATCH_FORMAT"));
                    return true;
                }
                if (this.isExcelFormat(format)) {
                    if (this._cloudStorageUrl != null) {
                        ctx.writeln(Messages.format("UNSUPPORTED_FORMAT", format));
                        return true;
                    }
                    readParmsAPI = new ReadParmsXLSAPI.Builder().readServiceBuilder(XLSReaderService.builder(this._fileName, format)).build();
                } else {
                    ReadParmsDelimitedAPI.Builder delimParmsBuilder = (ReadParmsDelimitedAPI.Builder)ctx.getProperty("load.format.options");
                    if (delimParmsBuilder == null) {
                        delimParmsBuilder = new ReadParmsDelimitedAPI.Builder();
                        delimParmsBuilder.enclosureRightDouble(true);
                    }
                    readParmsAPI = delimParmsBuilder.build();
                    SetLoadFormat.showParms((ScriptRunnerContext)ctx, (ReadParmsDelimitedAPI)readParmsAPI);
                }
                this._ctx.write(NL + process + SPACE + this.getTableName() + NL);
                this._ctx.getOutputStream().flush();
                long start = System.currentTimeMillis();
                exitCode = this.doLoad((ReadParmsAPI)readParmsAPI);
                if (ctx.getTiming()) {
                    ctx.write(ToolLoggerResources.format((String)"TIMINGELAPSEDTOTAL", (Object[])new Object[]{ToolLogger.getElapsedTime((long)start)}) + NL);
                }
                if (exitCode != ExitCode.EXIT_SEVERE) return true;
                ScriptUtils.doWhenever((ScriptRunnerContext)ctx, (ISQLCommand)cmd, (Connection)ctx.getCurrentConnection(), (boolean)false);
                return true;
            }
            ScriptUtils.doWhenever((ScriptRunnerContext)ctx, (ISQLCommand)cmd, (Connection)ctx.getCurrentConnection(), (boolean)false);
            return true;
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, e.getLocalizedMessage());
            return true;
        }
    }

    private boolean isExcelFormat(String format) {
        return format.equalsIgnoreCase(XLSXReader.EXT) || format.equalsIgnoreCase("xls");
    }

    private boolean formatDoesNotMatchFileExtension(String fileName, String format) {
        String[] fileParts = fileName.split("\\.");
        String fileExtension = fileParts[fileParts.length - 1];
        return !fileExtension.equalsIgnoreCase(format);
    }

    private boolean isUnSupportedFormat(String format) {
        return format != null && !format.equalsIgnoreCase(CSV) && !format.equalsIgnoreCase("xls") && !format.equalsIgnoreCase(XLSXReader.EXT);
    }

    private boolean validateFile(String fileName) {
        this._loadFile = new File(fileName);
        return this._loadFile.exists() && !this._loadFile.isDirectory();
    }

    private boolean validateTable(String table) {
        this._schema = this.getObjectOwner(table);
        if (this._schema != null && !this._schema.startsWith("\"") && !this._schema.endsWith("\"")) {
            this._schema = this._schema.toUpperCase();
        } else {
            try {
                this._schema = this._conn.getSchema();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this._table = this.getObjectName(table);
        if (this._table != null && !this._table.startsWith("\"") && !this._table.endsWith("\"")) {
            this._table = this._table.toUpperCase();
        }
        return this._table != null && !this._table.isEmpty();
    }

    private String getObjectName(String object) {
        String[] names = object.split("\\.");
        if (names.length == 1) {
            return names[0];
        }
        if (names.length == 2) {
            return names[1];
        }
        return object;
    }

    private String getObjectOwner(String object) {
        String[] names = object.split("\\.");
        if (names.length == 1) {
            return null;
        }
        if (names.length == 2) {
            return names[0];
        }
        return null;
    }

    private static Locale getLocale() {
        String lang = DEFAULT_LANG;
        String country = DEFAULT_COUNTRY;
        if (System.getProperty("user.language") != null && !System.getProperty("user.language").trim().equals("")) {
            lang = System.getProperty("user.language");
        }
        if (System.getProperty("user.country") != null && !System.getProperty("user.country").trim().equals("")) {
            country = System.getProperty("user.country");
        }
        Locale locale = new Locale(lang, country);
        return locale;
    }

    private boolean handleCloudStorage(String qualifier) {
        boolean isValid = true;
        this._csProps = (Map)this._ctx.getProperty("cloud.storage");
        CloudStorageUrl csUrl = null;
        if (this._csProps != null) {
            csUrl = (CloudStorageUrl)this._csProps.get("cloud_url");
        }
        try {
            if (qualifier != null) {
                if (csUrl == null) {
                    this._cloudStorageUrl = new CloudStorageUrl(qualifier);
                } else {
                    this._cloudStorageUrl = new CloudStorageUrl(csUrl.getFinalUrl());
                    this._cloudStorageUrl.qualifiedUrl(qualifier);
                }
                this._cloudStorageUrl.validateUrlAsObject();
            } else if (csUrl != null) {
                try {
                    csUrl.validateUrlAsObject();
                }
                catch (Exception e) {
                    String msg = e.getLocalizedMessage();
                    this._ctx.write(NL + MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"CS_INVALID_CS"), msg) + SPACE + String.valueOf(csUrl.getFinalUrl()) + NL);
                    isValid = false;
                }
                this._cloudStorageUrl = csUrl;
            }
            this._ctx.write(NL);
            CloudStorageCommand.showParms((ScriptRunnerContext)this._ctx, this._csProps);
            if (this._qualifier != null) {
                this._ctx.write(MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"CS_QUALIFIER"), this._qualifier) + NL);
            }
            if (this._cloudStorageUrl != null) {
                this._ctx.write(MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"CS_TARGET"), this._cloudStorageUrl.getFinalUrl()) + NL);
            } else {
                this._ctx.write(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"CS_NO_OBJECT") + NL);
                isValid = false;
            }
        }
        catch (Exception e) {
            try {
                isValid = false;
                this._ctx.write(NL + MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"CS_INVALID_CS"), e.getLocalizedMessage()) + NL);
            }
            catch (Exception e2) {
                this._ctx.write(NL + MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"CS_INVALID_CS"), e.getLocalizedMessage()) + NL);
                isValid = false;
            }
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ExitCode doLoad(ReadParmsAPI readParms) {
        BufferedReader tmp;
        ExitCode exitCode;
        Object handler;
        block142: {
            handler = null;
            this._responseFile = File.createTempFile("sqlcl_load", ".tmp");
            this._responseFile.deleteOnExit();
            this.getNewInputSteam();
            this._output = new FileOutputStream(this._responseFile);
            String msg = MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOAD_START"), this._schema + "." + this._table, this._fileName);
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, msg);
            LoadParmsAPI.Builder loadParmsBuilder222222 = (LoadParmsAPI.Builder)this._ctx.getProperty("load.method.insert");
            LoadParmsAPI loadParms = null;
            if (loadParmsBuilder222222 != null) {
                loadParms = loadParmsBuilder222222.build();
                if (loadParms.getLocale() == null) {
                    loadParmsBuilder222222.locale(LoadCommand.getLocale());
                }
                if (loadParms.getCleanNames() == null) {
                    loadParmsBuilder222222.cleanNames(LoadParmsAPI.CLEAN_NAMES.TRANSFORM);
                }
                SetLoad.showParms((ScriptRunnerContext)this._ctx, (LoadParmsAPI)loadParms);
            } else {
                loadParmsBuilder222222 = new LoadParmsAPI.Builder(LoadParmsAPI.SERVICE_METHOD.JDBC_BATCH);
                loadParmsBuilder222222.doCommit(true);
                loadParmsBuilder222222.cleanNames(LoadParmsAPI.CLEAN_NAMES.TRANSFORM);
            }
            LoadParmsAPI.PROCESS process = LoadParmsAPI.PROCESS.LOAD;
            LoadParmsAPI.DDL_OPTION ddlOpt = LoadParmsAPI.DDL_OPTION.NONE;
            if (this._isDdlShow) {
                ddlOpt = LoadParmsAPI.DDL_OPTION.SHOW;
                process = LoadParmsAPI.PROCESS.DDL_ONLY;
            } else if (this._isDdlCreate) {
                ddlOpt = LoadParmsAPI.DDL_OPTION.CREATE;
                process = LoadParmsAPI.PROCESS.DDL_ONLY;
            } else {
                ddlOpt = this._isNew ? LoadParmsAPI.DDL_OPTION.CREATE : LoadParmsAPI.DDL_OPTION.NONE;
            }
            ExitCode exitCode2 = ExitCode.EXIT_SUCCESS;
            loadParmsBuilder222222.process(process).ddlOption(ddlOpt);
            loadParms = loadParmsBuilder222222.build();
            LoadAPI loader = new LoadAPI.Builder(this._conn, this._schema, this._table, this._input, this._output).loadParms(loadParms).readParms(readParms).logger(Logger.getLogger(((Object)((Object)this)).getClass().getName())).build();
            exitCode2 = loader.scan();
            boolean isScanned = loader.checkScanned();
            if (isScanned) {
                this.closeInputStream();
                if (this._isLoad) {
                    this.getNewInputSteam();
                }
            }
            if (exitCode2 == ExitCode.EXIT_SUCCESS && this._isLoad) {
                process = LoadParmsAPI.PROCESS.LOAD;
                exitCode2 = loader.load(this._input, isScanned);
                this.closeInputStream();
                this._input = null;
            }
            loader.finish();
            exitCode = exitCode2;
            tmp = null;
            try {
                if (this._location != null) {
                    this._location.disconnect();
                    break block142;
                }
                if (this._input != null) {
                    this.closeInputStream();
                }
            }
            catch (Exception e1) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e1.getLocalizedMessage());
            }
        }
        try {
            if (this._output != null) {
                String line;
                this._output.close();
                tmp = new BufferedReader(new FileReader(this._responseFile));
                this._ctx.write(NL);
                while ((line = tmp.readLine()) != null) {
                    this._ctx.write(line + NL);
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getLocalizedMessage());
        }
        try {
            String msg = MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOAD_END"), this._schema + "." + this._table, this._fileName);
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, msg);
            if (handler == null) return exitCode;
            handler.close();
            return exitCode;
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getLocalizedMessage());
            return exitCode;
        }
        finally {
            try {
                if (tmp != null) {
                    tmp.close();
                }
            }
            catch (Exception e) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getLocalizedMessage());
            }
        }
        catch (MalformedURLException mue) {
            BufferedReader tmp2;
            ExitCode loadParmsBuilder222222;
            block143: {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, mue.getLocalizedMessage());
                this._ctx.write(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOAD_ERR") + SPACE + mue.getLocalizedMessage() + NL);
                loadParmsBuilder222222 = ExitCode.EXIT_SEVERE;
                tmp2 = null;
                try {
                    if (this._location != null) {
                        this._location.disconnect();
                        break block143;
                    }
                    if (this._input != null) {
                        this.closeInputStream();
                    }
                }
                catch (Exception e1) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e1.getLocalizedMessage());
                }
            }
            try {
                if (this._output != null) {
                    String line;
                    this._output.close();
                    tmp2 = new BufferedReader(new FileReader(this._responseFile));
                    this._ctx.write(NL);
                    while ((line = tmp2.readLine()) != null) {
                        this._ctx.write(line + NL);
                    }
                }
            }
            catch (Exception e) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getLocalizedMessage());
            }
            try {
                String msg = MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOAD_END"), this._schema + "." + this._table, this._fileName);
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, msg);
                if (handler == null) return loadParmsBuilder222222;
                handler.close();
                return loadParmsBuilder222222;
            }
            catch (Exception e) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getLocalizedMessage());
                return loadParmsBuilder222222;
            }
            finally {
                try {
                    if (tmp2 != null) {
                        tmp2.close();
                    }
                }
                catch (Exception e) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getLocalizedMessage());
                }
            }
            catch (IllegalStateException ise) {
                BufferedReader tmp3222222;
                ExitCode loadParmsBuilder222222;
                block144: {
                    this._ctx.write(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOAD_ERR") + SPACE + ise.getLocalizedMessage() + NL);
                    loadParmsBuilder222222 = ExitCode.EXIT_SEVERE;
                    tmp3222222 = null;
                    try {
                        if (this._location != null) {
                            this._location.disconnect();
                            break block144;
                        }
                        if (this._input != null) {
                            this.closeInputStream();
                        }
                    }
                    catch (Exception e1) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e1.getLocalizedMessage());
                    }
                }
                try {
                    if (this._output != null) {
                        String line;
                        this._output.close();
                        tmp3222222 = new BufferedReader(new FileReader(this._responseFile));
                        this._ctx.write(NL);
                        while ((line = tmp3222222.readLine()) != null) {
                            this._ctx.write(line + NL);
                        }
                    }
                }
                catch (Exception e) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getLocalizedMessage());
                }
                try {
                    String msg = MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOAD_END"), this._schema + "." + this._table, this._fileName);
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, msg);
                    if (handler == null) return loadParmsBuilder222222;
                    handler.close();
                    return loadParmsBuilder222222;
                }
                catch (Exception e) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getLocalizedMessage());
                    return loadParmsBuilder222222;
                }
                finally {
                    try {
                        if (tmp3222222 != null) {
                            tmp3222222.close();
                        }
                    }
                    catch (Exception e) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getLocalizedMessage());
                    }
                }
                catch (IOException se) {
                    BufferedReader tmp4;
                    ExitCode tmp3222222;
                    block145: {
                        String msg = se.getLocalizedMessage();
                        if (se.getCause() != null && se.getCause().getLocalizedMessage() != null) {
                            msg = se.getCause().getLocalizedMessage();
                        }
                        this._ctx.write(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOAD_ERR") + SPACE + msg + NL);
                        tmp3222222 = ExitCode.EXIT_SEVERE;
                        tmp4 = null;
                        try {
                            if (this._location != null) {
                                this._location.disconnect();
                                break block145;
                            }
                            if (this._input != null) {
                                this.closeInputStream();
                            }
                        }
                        catch (Exception e1) {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e1.getLocalizedMessage());
                        }
                    }
                    try {
                        if (this._output != null) {
                            String line;
                            this._output.close();
                            tmp4 = new BufferedReader(new FileReader(this._responseFile));
                            this._ctx.write(NL);
                            while ((line = tmp4.readLine()) != null) {
                                this._ctx.write(line + NL);
                            }
                        }
                    }
                    catch (Exception e) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getLocalizedMessage());
                    }
                    try {
                        String msg = MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOAD_END"), this._schema + "." + this._table, this._fileName);
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, msg);
                        if (handler == null) return tmp3222222;
                        handler.close();
                        return tmp3222222;
                    }
                    catch (Exception e) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getLocalizedMessage());
                        return tmp3222222;
                    }
                    finally {
                        try {
                            if (tmp4 != null) {
                                tmp4.close();
                            }
                        }
                        catch (Exception e) {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getLocalizedMessage());
                        }
                    }
                    catch (Exception e) {
                        BufferedReader tmp5;
                        ExitCode exitCode3;
                        block146: {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, e.getLocalizedMessage() + NL);
                            this._ctx.write(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOAD_ERR") + SPACE + e.getLocalizedMessage() + NL);
                            exitCode3 = ExitCode.EXIT_SEVERE;
                            tmp5 = null;
                            try {
                                if (this._location != null) {
                                    this._location.disconnect();
                                    break block146;
                                }
                                if (this._input != null) {
                                    this.closeInputStream();
                                }
                            }
                            catch (Exception e1) {
                                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e1.getLocalizedMessage());
                            }
                        }
                        try {
                            if (this._output != null) {
                                String line;
                                this._output.close();
                                tmp5 = new BufferedReader(new FileReader(this._responseFile));
                                this._ctx.write(NL);
                                while ((line = tmp5.readLine()) != null) {
                                    this._ctx.write(line + NL);
                                }
                            }
                        }
                        catch (Exception e2) {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e2.getLocalizedMessage());
                        }
                        try {
                            String msg = MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOAD_END"), this._schema + "." + this._table, this._fileName);
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, msg);
                            if (handler == null) return exitCode3;
                            handler.close();
                            return exitCode3;
                        }
                        catch (Exception e3) {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e3.getLocalizedMessage());
                            return exitCode3;
                        }
                        finally {
                            try {
                                if (tmp5 != null) {
                                    tmp5.close();
                                }
                            }
                            catch (Exception e4) {
                                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e4.getLocalizedMessage());
                            }
                        }
                        catch (Throwable throwable) {
                            BufferedReader tmp6;
                            block147: {
                                tmp6 = null;
                                try {
                                    if (this._location != null) {
                                        this._location.disconnect();
                                        break block147;
                                    }
                                    if (this._input != null) {
                                        this.closeInputStream();
                                    }
                                }
                                catch (Exception e1) {
                                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e1.getLocalizedMessage());
                                }
                            }
                            try {
                                if (this._output != null) {
                                    String line;
                                    this._output.close();
                                    tmp6 = new BufferedReader(new FileReader(this._responseFile));
                                    this._ctx.write(NL);
                                    while ((line = tmp6.readLine()) != null) {
                                        this._ctx.write(line + NL);
                                    }
                                }
                            }
                            catch (Exception e5) {
                                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e5.getLocalizedMessage());
                            }
                            try {
                                String msg = MessageFormat.format(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"LOAD_END"), this._schema + "." + this._table, this._fileName);
                                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, msg);
                                if (handler == null) throw throwable;
                                handler.close();
                                throw throwable;
                            }
                            catch (Exception e6) {
                                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e6.getLocalizedMessage());
                                throw throwable;
                            }
                            finally {
                                try {
                                    if (tmp6 != null) {
                                        tmp6.close();
                                    }
                                }
                                catch (Exception e7) {
                                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e7.getLocalizedMessage());
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void closeInputStream() throws IOException {
        this._input.close();
        if (this._zipFile != null) {
            this._zipFile.close();
            this._zipFile = null;
        }
    }

    private void getNewInputSteam() throws IOException {
        if (this._fileName != null) {
            String extension;
            switch (extension = this._fileName.substring(this._fileName.lastIndexOf("."))) {
                case ".gz": {
                    this._input = new GZIPInputStream(new FileInputStream(this._fileName));
                    break;
                }
                case ".zip": {
                    this._zipFile = new ZipFile(this._fileName);
                    this._input = this._zipFile.getInputStream(this._zipFile.entries().nextElement());
                    break;
                }
                default: {
                    this._input = new FileInputStream(this._fileName);
                    break;
                }
            }
        } else {
            this._ctx.getOutputStream().flush();
            this._location = CSCommon.getLocation((ScriptRunnerContext)this._ctx, (Connection)this._conn, (String)this._qualifier);
            if (this._location == null) {
                this._ctx.write(oracle.dbtools.raptor.newscriptrunner.commands.Messages.getString((String)"CS_CONNECT_ERR"));
            } else {
                this._location.connect();
                this._input = this._location.asInputStream(null, 0L, 0L);
            }
        }
    }

    private String getTableName() {
        if (this._schema != null && this._schema.length() > 0) {
            return this._schema + "." + this._table;
        }
        return this._table;
    }

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public boolean needsConnection() {
        return true;
    }
}

