/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.core.apexlang;

import java.util.Objects;
import oracle.apexlang.core.APEXLangSyntaxError;
import oracle.apexlang.core.APEXLangWarning;

public class APEXLangMessage {
    private final int startLine;
    private final int startCharacter;
    private final int endLine;
    private final int endCharacter;
    private final String filename;
    private final String message;
    private final Status status;
    private final APEXLangSyntaxError.ErrorType errorType;
    private final APEXLangWarning.WarningType warningType;

    private APEXLangMessage(Builder builder) {
        this.startLine = builder.startLine;
        this.startCharacter = builder.startCharacter;
        this.endLine = Objects.requireNonNullElse(builder.endLine, this.startLine);
        this.endCharacter = Objects.requireNonNullElseGet(builder.endCharacter, () -> this.startCharacter + 3);
        this.status = Objects.requireNonNullElse(builder.status, Status.Error);
        this.message = builder.message;
        this.filename = builder.filename;
        this.errorType = builder.errorType;
        this.warningType = builder.warningType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int startLine() {
        return this.startLine;
    }

    public int startCharacter() {
        return this.startCharacter;
    }

    public int endLine() {
        return this.endLine;
    }

    public int endCharacter() {
        return this.endCharacter;
    }

    public String filename() {
        return this.filename;
    }

    public String message() {
        return this.message;
    }

    APEXLangSyntaxError.ErrorType errorType() {
        return this.errorType;
    }

    APEXLangWarning.WarningType warningType() {
        return this.warningType;
    }

    public static final class Builder {
        private int startLine;
        private int startCharacter;
        private int endLine;
        private int endCharacter;
        private String filename;
        private String message;
        private Status status;
        private APEXLangSyntaxError.ErrorType errorType;
        private APEXLangWarning.WarningType warningType;

        private Builder() {
        }

        public Builder startLine(int startLine) {
            this.startLine = startLine;
            return this;
        }

        public Builder startCharacter(int startCharacter) {
            this.startCharacter = startCharacter;
            return this;
        }

        public Builder endLine(int startLine) {
            this.endLine = startLine;
            return this;
        }

        public Builder endCharacter(int startCharacter) {
            this.endCharacter = startCharacter;
            return this;
        }

        public Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder errorType(APEXLangSyntaxError.ErrorType errorType) {
            this.errorType = errorType;
            return this;
        }

        public Builder warningType(APEXLangWarning.WarningType warningType) {
            this.warningType = warningType;
            return this;
        }

        public APEXLangMessage build() {
            return new APEXLangMessage(this);
        }
    }

    public static enum Status {
        Error,
        Warning;

    }
}

