/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.core.apexlang;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import oracle.apexlang.APEXLangCompiler;
import oracle.apexlang.core.APEXLangAlert;
import oracle.apexlang.core.APEXLangCompilationResult;
import oracle.apexlang.core.APEXLangSuggestion;
import oracle.apexlang.core.APEXLangSyntaxError;
import oracle.apexlang.core.Component;
import oracle.apexlang.core.ComponentGroup;
import oracle.apexlang.core.ComponentParameter;
import oracle.apexlang.core.Location;
import oracle.apexlang.core.Position;
import oracle.apexlang.core.Range;
import oracle.apexlang.metametadata.ComponentType;
import oracle.apexlang.metametadata.Group;
import oracle.apexlang.metametadata.LOV;
import oracle.apexlang.metametadata.Metametadata;
import oracle.apexlang.metametadata.Property;
import oracle.apexlang.metametadata.PropertyType;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangApplicationState;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangCodeActionItem;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangCompletionItem;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangDocumentNode;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangFileUpdate;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangHoverItem;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangLocation;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangMessage;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangPosition;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangRange;
import oracle.dbtools.extension.apex.core.apexlang.ApexLangMessages;

public class APEXLangDocumentState {
    private static final int CompletionItemKind_Snippet = 15;
    private static final int CompletionItemKind_EnumMember = 20;
    private static final int CompletionItemKind_Constant = 21;
    private static final int InsertTextFormat_Snippet = 2;
    private static final String DEFAULT = "DEFAULT";
    private static final String PAGE = "page";
    private static final String ALIAS = "alias";
    private static final String QUICKFIX = "quickfix";
    private static final String REFACTOR = "refactor";
    private static final String EXTRACT_EMBEDDED_KEY = "extract:";
    private static final String INLINE_EMBEDDED_KEY = "inline:";
    private static final String PLSQL_LANGUAGE = "plsql";
    private static final String PLSQL_FILE_EXTENSION = "pls";
    private static final String JAVASCRIPT_LANGUAGE = "javascript";
    private static final String JAVASCRIPT_FILE_EXTENSION = "js";
    private static final String FILE_REFERENCE_PROPERTY_SUFFIX = "File";
    private final int version;
    private final List<APEXLangDocumentNode> languageNodes;
    private final Integer pageId;
    private final String text;
    private final URI uri;
    private final APEXLangApplicationState applicationState;
    private final List<Integer> offsets;
    private APEXLangCompilationResult compilationResult;
    private final Metametadata metaMetaData;
    private final String pageAliasPropertyId;
    private APEXLangDocumentNode rootNode;

    public APEXLangDocumentState(String text, int version, URI uri, APEXLangApplicationState applicationState, System.Logger logger) {
        APEXLangDocumentNode node;
        this.text = text;
        this.offsets = this.buildOffsets(text);
        this.version = version;
        this.uri = uri;
        this.applicationState = applicationState;
        this.metaMetaData = applicationState.getMetaMetaData();
        this.compilationResult = applicationState.compile(uri, text, logger);
        APEXLangDocumentNode.Builder builder = APEXLangDocumentNode.builder();
        this.buildNodes(builder, null);
        this.rootNode = builder.build();
        this.languageNodes = new ArrayList<APEXLangDocumentNode>();
        this.addLanguageNodes(this.rootNode);
        Integer pageId = null;
        if (this.rootNode.children().size() == 1 && PAGE.equals((node = this.rootNode.children().get(0)).name())) {
            String id = node.detail();
            if (id.length() > 1 && id.startsWith("\"") && id.endsWith("\"")) {
                id = node.detail().substring(1, node.detail().length() - 1);
            }
            try {
                Double d = Double.parseDouble(id);
                pageId = d.intValue();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.pageId = pageId;
        String pageAliasPropertyId = "";
        ComponentType pageCompType = this.metaMetaData.getComponentTypes().entrySet().stream().filter(e -> PAGE.equals(((ComponentType)e.getValue()).getName().getSingular())).map(e -> (ComponentType)e.getValue()).findFirst().orElse(null);
        if (pageCompType != null) {
            pageAliasPropertyId = pageCompType.getProperties().entrySet().stream().filter(e -> ALIAS.equals(((ComponentType.ComponentProperty)e.getValue()).getPropertyName())).map(e -> (String)e.getKey()).findFirst().orElse(null);
        }
        this.pageAliasPropertyId = pageAliasPropertyId;
    }

    private List<Integer> buildOffsets(String text) {
        if (text != null) {
            String[] lines = this.text.split("\n");
            AtomicInteger atomicInteger = new AtomicInteger(0);
            return Arrays.stream(lines).map(line -> atomicInteger.getAndAdd(line.length() + 1)).collect(Collectors.toUnmodifiableList());
        }
        return null;
    }

    protected APEXLangDocumentState(int version, String text) {
        this.text = text;
        this.offsets = this.buildOffsets(text);
        this.version = version;
        this.languageNodes = null;
        this.pageId = null;
        this.uri = null;
        this.applicationState = null;
        this.compilationResult = null;
        this.metaMetaData = null;
        this.pageAliasPropertyId = null;
    }

    public int getVersion() {
        return this.version;
    }

    Collection<Component> getComponents() {
        if (this.compilationResult != null) {
            return this.compilationResult.getComponentsParameters();
        }
        return List.of();
    }

    public List<APEXLangDocumentNode> getLanguageNodes() {
        return Collections.unmodifiableList(this.languageNodes);
    }

    public Integer getPageId() {
        return this.pageId;
    }

    public APEXLangDocumentNode getRootNode() {
        return this.rootNode;
    }

    Position getPosition(int offset) {
        int line;
        for (line = 0; line < this.offsets.size() - 1 && this.offsets.get(line + 1) <= offset; ++line) {
        }
        int column = offset - this.offsets.get(line);
        return new Position(Integer.valueOf(line + 1), Integer.valueOf(column));
    }

    public int getOffset(int line, int column) {
        return this.offsets.get(line - 1) + column;
    }

    private void buildNodes(APEXLangDocumentNode.Builder parentNode, Component component) {
        if (component != null) {
            List<Component> relatedComponents = this.getAllRelatedComponents(component);
            HashMap<String, APEXLangDocumentNode.Builder> groupNodes = new HashMap<String, APEXLangDocumentNode.Builder>();
            for (Component relatedComponent : relatedComponents) {
                List componentGroups = relatedComponent.getComponentGroups();
                if (componentGroups == null) continue;
                for (ComponentGroup componentGroup : componentGroups) {
                    String groupName = componentGroup.getName();
                    APEXLangDocumentNode.Builder groupNode = parentNode.newChild().nodeType(APEXLangDocumentNode.NodeType.GROUP).name(groupName).range(this.convertRange(componentGroup.getRange())).startOffset(componentGroup.getRange().getStart()).endOffset(componentGroup.getRange().getEnd()).component(relatedComponent);
                    groupNode.newChild().nodeType(APEXLangDocumentNode.NodeType.GROUP_NAME).name(groupName).range(this.convertRange(componentGroup.getNameRange())).startOffset(componentGroup.getNameRange().getStart()).endOffset(componentGroup.getNameRange().getEnd()).component(relatedComponent);
                    groupNodes.put(groupName, groupNode);
                }
            }
            for (Component relatedComponent : relatedComponents) {
                for (Map.Entry entry : relatedComponent.getParameters().entrySet()) {
                    String nodePropName;
                    String srcPropName;
                    String propertyId = (String)entry.getKey();
                    ComponentParameter componentParameter = (ComponentParameter)entry.getValue();
                    if (!componentParameter.isInSource() || componentParameter.isExternalIdentifier().booleanValue()) continue;
                    Property property = componentParameter.getProperty();
                    Group group = (Group)this.metaMetaData.getGroups().get(property.getGroupId());
                    String groupName = group == null ? null : group.getName();
                    APEXLangDocumentNode.Builder propParentNode = componentParameter.isImplicitGroup() ? parentNode : (APEXLangDocumentNode.Builder)groupNodes.get(groupName);
                    if (propParentNode == null) continue;
                    APEXLangDocumentNode.Builder propNode = propParentNode.newChild().component(relatedComponent).componentParameter(componentParameter).propertyId(propertyId).property(property).name(property.getName()).range(this.convertRange(componentParameter.getRange())).startOffset(componentParameter.getRange().getStart()).endOffset(componentParameter.getRange().getEnd());
                    Range valueRange = componentParameter.getValueRange();
                    String value = this.text.substring(valueRange.getStart(), valueRange.getEnd());
                    String multiValueDelimiter = property.getMultiValueDelimiter();
                    if (multiValueDelimiter == null) {
                        multiValueDelimiter = ((PropertyType)this.metaMetaData.getPropertyTypes().get(property.getType())).getDefaultMultiValueDelimiter();
                    }
                    propNode.newChild().range(this.convertRange(componentParameter.getKeyRange())).startOffset(componentParameter.getKeyRange().getStart()).endOffset(componentParameter.getKeyRange().getEnd()).component(relatedComponent).componentParameter(componentParameter).propertyId(propertyId).property(property).nodeType(APEXLangDocumentNode.NodeType.PROPERTY_NAME).name(property.getName());
                    if (value.startsWith("[") && value.endsWith("]") && multiValueDelimiter != null) {
                        propNode.nodeType(APEXLangDocumentNode.NodeType.ARRAY_PROPERTY);
                        String[] chunks = value.substring(1, value.length() - 1).split(multiValueDelimiter);
                        int additionalOffset = componentParameter.getValueRange().getStart() + 1;
                        for (String chunk : chunks) {
                            Pattern p;
                            Matcher m;
                            if (!chunk.trim().isEmpty() && (m = (p = Pattern.compile("^\\s*(.).*")).matcher(chunk)).matches()) {
                                String name = chunk.trim();
                                int start = additionalOffset + m.start(1);
                                int end = start + name.length();
                                propNode.newChild().nodeType(APEXLangDocumentNode.NodeType.TEXT_PROPERTY).component(relatedComponent).componentParameter(componentParameter).propertyId(propertyId).property(property).name(name).range(this.convertRange(new Range(Integer.valueOf(start), Integer.valueOf(end)))).startOffset(start).endOffset(end);
                            }
                            additionalOffset = additionalOffset + chunk.length() + multiValueDelimiter.length();
                        }
                        continue;
                    }
                    propNode.nodeType(APEXLangDocumentNode.NodeType.TEXT_PROPERTY).detail(value);
                    if (property.getLov() != null) {
                        propNode.nodeType(APEXLangDocumentNode.NodeType.LOV_PROPERTY);
                    } else {
                        String dataType = ((PropertyType)this.metaMetaData.getPropertyTypes().get(property.getType())).getDataType();
                        if ("integer".equals(dataType) || "number".equals(dataType)) {
                            propNode.nodeType(APEXLangDocumentNode.NodeType.NUMERIC_PROPERTY);
                        } else if ("boolean".equals(dataType)) {
                            propNode.nodeType(APEXLangDocumentNode.NodeType.BOOLEAN_PROPERTY);
                        }
                    }
                    String language = ((PropertyType)this.metaMetaData.getPropertyTypes().get(property.getType())).getLanguage();
                    boolean languageFileRef = false;
                    if (language != null && (srcPropName = this.text.substring(componentParameter.getKeyRange().getStart(), componentParameter.getKeyRange().getEnd())).equals((nodePropName = componentParameter.getProperty().getName()) + FILE_REFERENCE_PROPERTY_SUFFIX)) {
                        languageFileRef = true;
                    }
                    propNode.newChild().range(this.convertRange(componentParameter.getValueRange())).startOffset(componentParameter.getValueRange().getStart()).endOffset(componentParameter.getValueRange().getEnd()).component(relatedComponent).componentParameter(componentParameter).property(property).propertyId(propertyId).language(language).languageFileRef(languageFileRef).nodeType(APEXLangDocumentNode.NodeType.PROPERTY_VALUE).name(componentParameter.getValue());
                }
            }
        }
        this.getComponents().forEach(childComponent -> {
            if (!(childComponent.getParent() != component || childComponent.getFilename() == null || component != null && component.getRelatedComponentsFound().contains(childComponent))) {
                APEXLangDocumentNode.Builder componentNode = parentNode.newChild();
                componentNode.component((Component)childComponent);
                componentNode.nodeType(APEXLangDocumentNode.NodeType.COMPONENT);
                String name = ((ComponentType)this.metaMetaData.getComponentTypes().get(childComponent.getTypeId())).getName().getSingular();
                componentNode.name(name);
                Integer start = childComponent.getRange().getStart();
                Integer end = childComponent.getRange().getEnd();
                String fullText = this.text.substring(start, end + 1);
                String compText = fullText.trim();
                start = start + fullText.indexOf(compText);
                end = start + compText.length();
                componentNode.range(this.convertRange(new Range(start, end)));
                componentNode.startOffset(start);
                componentNode.endOffset(end);
                ComponentParameter componentParameter = (ComponentParameter)childComponent.getParameters().get(childComponent.getExternalIdentifierPropertyId());
                if (componentParameter != null) {
                    Range range = componentParameter.getValueRange();
                    componentNode.detail(this.text.substring(range.getStart(), range.getEnd()));
                    componentNode.newChild().range(this.convertRange(componentParameter.getKeyRange())).startOffset(componentParameter.getKeyRange().getStart()).endOffset(componentParameter.getKeyRange().getEnd()).componentParameter(componentParameter).component((Component)childComponent).nodeType(APEXLangDocumentNode.NodeType.COMPONENT_TYPE).name(name);
                    componentNode.newChild().range(this.convertRange(componentParameter.getValueRange())).startOffset(componentParameter.getValueRange().getStart()).endOffset(componentParameter.getValueRange().getEnd()).componentParameter(componentParameter).component((Component)childComponent).nodeType(APEXLangDocumentNode.NodeType.COMPONENT_NAME).name(componentParameter.getValue());
                } else {
                    componentNode.detail(childComponent.getExternalIdentifier());
                }
                this.buildNodes(componentNode, (Component)childComponent);
            }
        });
    }

    private List<Component> getAllRelatedComponents(Component component) {
        ArrayList<Component> list = new ArrayList<Component>();
        this.addRelatedComponents(component, list);
        return list;
    }

    private void addRelatedComponents(Component component, List<Component> list) {
        list.add(component);
        component.getRelatedComponentsFound().forEach(c -> this.addRelatedComponents((Component)c, list));
    }

    public APEXLangDocumentNode getNodeAtOffset(int offset) {
        return this.getNodeAtOffset(offset, this.getRootNode());
    }

    private APEXLangDocumentNode getNodeAtOffset(int offset, APEXLangDocumentNode parent) {
        Optional<APEXLangDocumentNode> node = parent.children().stream().filter(n -> n.startOffset() <= offset && n.endOffset() >= offset).findFirst();
        if (node.isPresent()) {
            return this.getNodeAtOffset(offset, node.get());
        }
        return parent;
    }

    private void addLanguageNodes(APEXLangDocumentNode node) {
        String lang = node.language();
        List<APEXLangDocumentNode> children = node.children();
        if (lang != null && !node.languageFileRef()) {
            this.languageNodes.add(node);
        } else if (children != null && children.size() > 0) {
            children.forEach(c -> this.addLanguageNodes((APEXLangDocumentNode)c));
        }
    }

    public APEXLangLocation getReferencedLocationAt(int offset) {
        Location location;
        APEXLangDocumentNode nodeAtOffset = this.getNodeAtOffset(offset);
        if (nodeAtOffset.language() == null && nodeAtOffset.nodeType() == APEXLangDocumentNode.NodeType.PROPERTY_VALUE && nodeAtOffset.parent().nodeType() == APEXLangDocumentNode.NodeType.LOV_PROPERTY && this.isComponentReference(nodeAtOffset.property()) && (location = this.applicationState.getReferenceLocation(nodeAtOffset.propertyId(), nodeAtOffset.componentParameter())) != null) {
            int line = location.getPostion().getLine() - 1;
            Integer character = location.getPostion().getCharacter();
            Range apexlangRange = nodeAtOffset.componentParameter().getRange();
            int endChar = character + apexlangRange.getEnd() - apexlangRange.getStart();
            APEXLangRange range = APEXLangRange.builder().start(APEXLangPosition.builder().line(line).character(character).build()).end(APEXLangPosition.builder().line(line).character(endChar).build()).build();
            return APEXLangLocation.builder().path(location.getFilePath()).range(range).build();
        }
        return null;
    }

    public List<APEXLangCompletionItem> getCompletionItems(int offset) {
        APEXLangDocumentNode nodeAtOffset = this.getNodeAtOffset(offset);
        if (nodeAtOffset.language() == null) {
            ArrayList<APEXLangCompletionItem> results = new ArrayList<APEXLangCompletionItem>();
            List<APEXLangSuggestion> suggestions = this.applicationState.getSuggestions(this.uri, this.text, offset);
            if (!suggestions.isEmpty()) {
                for (APEXLangSuggestion suggestion : suggestions) {
                    APEXLangCompletionItem.Builder builder = APEXLangCompletionItem.builder().choice(suggestion.getValue()).detail(suggestion.getDetail());
                    APEXLangSuggestion.SuggestionType suggestionType = suggestion.getType();
                    StringBuilder insertTextBuilder = new StringBuilder();
                    if (suggestionType == APEXLangSuggestion.SuggestionType.VALUE) {
                        builder.type(20);
                        insertTextBuilder.append(suggestion.getValue());
                    } else {
                        builder.type(15).insertTextFormat(2);
                        if (suggestionType == APEXLangSuggestion.SuggestionType.PROPERTY_IN_CURRENT_GROUP || suggestionType == APEXLangSuggestion.SuggestionType.PROPERTY_IN_NEW_GROUP || suggestionType == APEXLangSuggestion.SuggestionType.PROPERTY_IN_EXISTING_GROUP) {
                            this.addPropertyToSnippet(insertTextBuilder, 0, suggestion);
                            if (suggestionType == APEXLangSuggestion.SuggestionType.PROPERTY_IN_EXISTING_GROUP) {
                                String[] groupAndProp = suggestion.getValue().split("\\.");
                                String groupName = groupAndProp[0];
                                String propertyName = groupAndProp[1];
                                APEXLangDocumentNode groupNode = null;
                                for (APEXLangDocumentNode node : nodeAtOffset.children()) {
                                    if (node.nodeType() == APEXLangDocumentNode.NodeType.GROUP && node.children().stream().filter(n -> n.nodeType().equals((Object)APEXLangDocumentNode.NodeType.GROUP_NAME) && n.name().equals(groupName)).findFirst().isPresent()) {
                                        groupNode = node;
                                        break;
                                    }
                                    if (groupNode == null) continue;
                                    break;
                                }
                                if (groupNode != null) {
                                    Position pos = this.getPosition(groupNode.startOffset());
                                    int line = pos.getLine() + 1;
                                    int character = pos.getCharacter() + 4;
                                    for (APEXLangDocumentNode n2 : groupNode.children()) {
                                        Position pos2 = this.getPosition(n2.startOffset());
                                        line = pos2.getLine() + 1;
                                        character = pos2.getCharacter();
                                    }
                                    builder.commandTitle("Move To Group").commandId("sqldeveloper.apexlang.moveToGroup").addCommandArgs(line).addCommandArgs(character).addCommandArgs(propertyName);
                                    if (!suggestion.getChildren().isEmpty()) {
                                        builder.addCommandArgs("true");
                                    }
                                }
                            }
                        } else if (suggestionType == APEXLangSuggestion.SuggestionType.GROUP) {
                            insertTextBuilder.append(suggestion.getValue()).append(" {\n\t$0\n}");
                        } else if (suggestionType == APEXLangSuggestion.SuggestionType.COMPONENT) {
                            insertTextBuilder.append(suggestion.getValue()).append(" ${1:new").append(suggestion.getValue().substring(0, 1).toUpperCase(Locale.ROOT)).append(suggestion.getValue().substring(1)).append("Id} (");
                            int tabStop = 1;
                            for (APEXLangSuggestion sub : suggestion.getChildren()) {
                                if (sub.getType() != APEXLangSuggestion.SuggestionType.PROPERTY_IN_CURRENT_GROUP) continue;
                                insertTextBuilder.append("\n\t");
                                tabStop = this.addPropertyToSnippet(insertTextBuilder, tabStop, sub);
                            }
                            for (APEXLangSuggestion sub : suggestion.getChildren()) {
                                if (sub.getType() != APEXLangSuggestion.SuggestionType.GROUP) continue;
                                insertTextBuilder.append("\n\t").append(sub.getValue()).append(" {");
                                for (APEXLangSuggestion sub2 : sub.getChildren()) {
                                    insertTextBuilder.append("\n\t\t");
                                    tabStop = this.addPropertyToSnippet(insertTextBuilder, tabStop, sub2);
                                }
                                insertTextBuilder.append("\n\t}");
                            }
                            insertTextBuilder.append("\n)");
                        } else {
                            throw new IllegalStateException("Unknown SuggestionType");
                        }
                    }
                    results.add(builder.insertText(insertTextBuilder.toString()).build());
                }
            } else {
                SubstitutionToken substitutionToken = this.getSubstitutionToken(nodeAtOffset, offset);
                if (substitutionToken != null) {
                    ArrayList<String> matches = new ArrayList<String>();
                    this.applicationState.getApexSubstitutionDefinitions().forEach((key, options) -> {
                        String leftOfOffset = substitutionToken.token.substring(0, offset - substitutionToken.startOffset);
                        if (key.startsWith(leftOfOffset)) {
                            switch (substitutionToken.type.ordinal()) {
                                case 0: {
                                    if (!Boolean.TRUE.equals(options.get("bind"))) break;
                                    matches.add((String)key);
                                    break;
                                }
                                case 1: {
                                    if (!Boolean.TRUE.equals(options.get(PLSQL_LANGUAGE))) break;
                                    matches.add((String)key);
                                    break;
                                }
                                case 2: {
                                    if (!Boolean.TRUE.equals(options.get("substitution"))) break;
                                    matches.add((String)key);
                                    break;
                                }
                                case 3: {
                                    if (!Boolean.TRUE.equals(options.get("template"))) break;
                                    matches.add((String)key);
                                }
                            }
                        }
                    });
                    matches.forEach(match -> {
                        String messageKey = match;
                        if (messageKey.matches("APP_AJAX_X(0[1-9]|10)")) {
                            messageKey = "APP_AJAX_Xnn";
                        }
                        APEXLangCompletionItem.Builder builder = APEXLangCompletionItem.builder().type(21).choice((String)match).detail(ApexLangMessages.get(messageKey));
                        switch (substitutionToken.type.ordinal()) {
                            case 0: {
                                builder.insertText((String)match);
                                break;
                            }
                            case 1: {
                                builder.insertText(match + "')");
                                break;
                            }
                            case 2: {
                                builder.insertText(match + ".");
                                break;
                            }
                            case 3: {
                                builder.insertText(match + "#");
                            }
                        }
                        results.add(builder.build());
                    });
                }
            }
            return results;
        }
        return List.of();
    }

    private int addPropertyToSnippet(StringBuilder stringBuilder, int startTabStop, APEXLangSuggestion suggestion) {
        int tabStop = startTabStop;
        String groupName = "";
        String propName = suggestion.getValue();
        boolean addGroup = false;
        APEXLangSuggestion.SuggestionType suggestionType = suggestion.getType();
        if (suggestionType == APEXLangSuggestion.SuggestionType.PROPERTY_IN_NEW_GROUP || suggestionType == APEXLangSuggestion.SuggestionType.PROPERTY_IN_EXISTING_GROUP) {
            int dotPos = propName.indexOf(".");
            groupName = propName.substring(0, dotPos);
            propName = propName.substring(dotPos + 1);
            addGroup = true;
            stringBuilder.append(groupName).append(" {\n\t");
        }
        stringBuilder.append(propName).append(": ");
        if (suggestion.getChildren().isEmpty()) {
            Property property = suggestion.getProperty();
            PropertyType propertyType = null;
            if (property != null) {
                propertyType = (PropertyType)this.applicationState.getMetaMetaData().getPropertyTypes().get(property.getType());
            }
            if (propertyType != null) {
                if (propertyType.getLanguage() != null && propertyType.isMultiLine()) {
                    stringBuilder.append("```").append(propertyType.getLanguage()).append("\n\t$").append(++tabStop).append("\n```");
                } else if (property.getMultiValueDelimiter() != null || propertyType.getDefaultMultiValueDelimiter() != null) {
                    stringBuilder.append("[").append("\n\t$").append(++tabStop).append("\n]");
                } else {
                    stringBuilder.append("$").append(++tabStop);
                }
            } else {
                stringBuilder.append("$").append(++tabStop);
            }
        } else {
            stringBuilder.append("${").append(++tabStop);
            String sep = "|";
            for (APEXLangSuggestion sub : suggestion.getChildren()) {
                stringBuilder.append(sep).append(sub.getValue());
                sep = ",";
            }
            stringBuilder.append("|}");
        }
        if (addGroup) {
            stringBuilder.append("\n}");
        }
        return tabStop;
    }

    public List<APEXLangDocumentNode> getOutlineNodes() {
        Set<APEXLangDocumentNode.NodeType> skip = Set.of(APEXLangDocumentNode.NodeType.COMPONENT_NAME, APEXLangDocumentNode.NodeType.GROUP_NAME, APEXLangDocumentNode.NodeType.PROPERTY_NAME, APEXLangDocumentNode.NodeType.PROPERTY_VALUE);
        APEXLangDocumentNode clonedRoot = this.getRootNode().clone(node -> {
            boolean skipNode = node.nodeType() != null && (skip.contains((Object)node.nodeType()) || node.componentParameter() != null && !node.componentParameter().isInSource() || node.componentParameter() != null && node.componentParameter().isExternalIdentifier() != false);
            return !skipNode;
        });
        return clonedRoot.children();
    }

    public String addLanguageTags() {
        boolean addLanguages = true;
        StringBuilder stringBuilder = new StringBuilder();
        boolean inMLT = false;
        String[] lines = this.text.split("\n");
        for (int lineNo = 0; lineNo < lines.length; ++lineNo) {
            Object line = lines[lineNo];
            int mltPos = ((String)line).indexOf("```");
            if (mltPos >= 0) {
                boolean bl = inMLT = !inMLT;
                if (inMLT) {
                    APEXLangDocumentNode node;
                    String language;
                    int offset = this.getOffset(lineNo + 2, 0);
                    String lang = "";
                    if (addLanguages && (language = (node = this.getNodeAtOffset(offset)).language()) != null) {
                        lang = language;
                    }
                    line = ((String)line).substring(0, mltPos + 3) + lang;
                }
            }
            stringBuilder.append((String)line);
            if (lineNo >= lines.length - 1) continue;
            stringBuilder.append("\n");
        }
        if (this.text.endsWith("\n")) {
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public List<APEXLangMessage> getMessages(APEXLangMessage.Status status) {
        ArrayList<APEXLangSyntaxError> errors = new ArrayList<APEXLangSyntaxError>();
        if (status == APEXLangMessage.Status.Error || status == null) {
            for (APEXLangSyntaxError aPEXLangSyntaxError : this.compilationResult.getErrors()) {
                errors.add(aPEXLangSyntaxError);
            }
            List<APEXLangSyntaxError> importErrors = this.applicationState.getImportErrors(this.applicationState.getRelativeFilePath(this.uri.getPath()));
            if (importErrors.size() > 0) {
                errors.addAll(importErrors);
            }
        }
        if (status == APEXLangMessage.Status.Warning || status == null) {
            for (APEXLangSyntaxError aPEXLangSyntaxError : this.compilationResult.getWarnings()) {
                errors.add(aPEXLangSyntaxError);
            }
        }
        return errors.stream().map(alert -> this.applicationState.convertAlertToMessage((APEXLangAlert)alert)).collect(Collectors.toUnmodifiableList());
    }

    public List<APEXLangLocation> getReferences(int offset, Map<URI, String> openFiles) {
        ArrayList<APEXLangLocation> references = new ArrayList<APEXLangLocation>();
        APEXLangDocumentNode nodeAtOffset = this.getNodeAtOffset(offset);
        if (nodeAtOffset.nodeType() == APEXLangDocumentNode.NodeType.COMPONENT_TYPE || nodeAtOffset.nodeType() == APEXLangDocumentNode.NodeType.COMPONENT_NAME || nodeAtOffset.nodeType() == APEXLangDocumentNode.NodeType.PROPERTY_NAME || nodeAtOffset.nodeType() == APEXLangDocumentNode.NodeType.PROPERTY_VALUE) {
            APEXLangCompilationResult result = this.applicationState.compileApplication(openFiles);
            if (nodeAtOffset.nodeType() == APEXLangDocumentNode.NodeType.PROPERTY_VALUE && nodeAtOffset.parent().nodeType() == APEXLangDocumentNode.NodeType.LOV_PROPERTY && this.isComponentReference(nodeAtOffset.parent().property())) {
                boolean found = false;
                APEXLangLocation loc = this.getReferencedLocationAt(offset);
                if (loc != null) {
                    for (Component component : result.getComponentsParameters()) {
                        if (this.applicationState.getUri(component.getFilename()).toString().equals(loc.path())) {
                            String externalIdentifierPropertyId = component.getExternalIdentifierPropertyId();
                            for (Map.Entry d : component.getParameters().entrySet()) {
                                String propId = (String)d.getKey();
                                ComponentParameter cp = (ComponentParameter)d.getValue();
                                Property property = cp.getProperty();
                                if (!propId.equals(externalIdentifierPropertyId) || !cp.getValue().equals(nodeAtOffset.componentParameter().getValue())) continue;
                                nodeAtOffset = APEXLangDocumentNode.builder().component(component).componentParameter((ComponentParameter)d.getValue()).nodeType(APEXLangDocumentNode.NodeType.COMPONENT_NAME).property(property).propertyId(propId).build();
                                found = true;
                                break;
                            }
                        }
                        if (!found) continue;
                        break;
                    }
                }
            }
            if (nodeAtOffset.nodeType() == APEXLangDocumentNode.NodeType.COMPONENT_NAME) {
                this.addToReferences(references, nodeAtOffset.component(), nodeAtOffset.componentParameter());
            }
            for (Component component : result.getComponentsParameters()) {
                for (Map.Entry d : component.getParameters().entrySet()) {
                    ComponentParameter componentParameter = (ComponentParameter)d.getValue();
                    Property property = componentParameter.getProperty();
                    LOV lov = property.getLov();
                    switch (nodeAtOffset.nodeType()) {
                        case COMPONENT_NAME: {
                            if (lov == null || lov.getComponentTypeId() == null || !lov.getComponentTypeId().equals(nodeAtOffset.component().getTypeId()) || componentParameter.getValue() == null || !componentParameter.getValue().equals(nodeAtOffset.componentParameter().getValue())) break;
                            this.addToReferences(references, component, componentParameter);
                            break;
                        }
                        case LOV_PROPERTY: {
                            if (lov == null || lov.getValues() == null || lov.getValues().isEmpty() || nodeAtOffset.property().getLov() != lov || !componentParameter.getValue().equals(nodeAtOffset.componentParameter().getValue())) break;
                            this.addToReferences(references, component, componentParameter);
                            break;
                        }
                        case PROPERTY_VALUE: {
                            if (!nodeAtOffset.property().getType().equals(property.getType()) || !componentParameter.getValue().equals(nodeAtOffset.componentParameter().getValue())) break;
                            this.addToReferences(references, component, componentParameter);
                            break;
                        }
                        case PROPERTY_NAME: {
                            if (!nodeAtOffset.property().equals(property) || !componentParameter.getValue().equals(nodeAtOffset.componentParameter().getValue())) break;
                            this.addToReferences(references, component, componentParameter, true);
                        }
                    }
                }
            }
        }
        return references;
    }

    public APEXLangRange getRenameRangeAtOffset(int offset) {
        APEXLangDocumentNode nodeAtOffset = this.getNodeAtOffset(offset);
        Integer startOffset = null;
        Integer endOffset = null;
        if (nodeAtOffset.nodeType() == APEXLangDocumentNode.NodeType.COMPONENT_NAME) {
            startOffset = nodeAtOffset.startOffset();
            endOffset = nodeAtOffset.endOffset();
        } else if (nodeAtOffset.nodeType() == APEXLangDocumentNode.NodeType.PROPERTY_VALUE && nodeAtOffset.parent().nodeType() == APEXLangDocumentNode.NodeType.LOV_PROPERTY && this.isComponentReference(nodeAtOffset.property())) {
            startOffset = nodeAtOffset.startOffset();
            endOffset = nodeAtOffset.endOffset();
            String text = this.text;
            if (text.substring(startOffset, startOffset + 1).equals("@") && !text.substring(startOffset, startOffset + 2).equals("@/")) {
                Integer n = startOffset;
                startOffset = startOffset + 1;
            } else {
                startOffset = null;
                endOffset = null;
            }
        }
        if (startOffset != null && endOffset != null) {
            Position start = this.getPosition(startOffset);
            Position end = this.getPosition(endOffset);
            return APEXLangRange.of(start.getLine() - 1, start.getCharacter(), end.getLine() - 1, end.getCharacter());
        }
        return null;
    }

    public List<APEXLangLocation> getRenameLocations(int offset, Map<URI, String> openFiles) {
        Object idLine;
        APEXLangLocation idLocation = this.getReferencedLocationAt(offset);
        List<APEXLangLocation> refs = this.getReferences(offset, openFiles);
        if (idLocation == null) {
            APEXLangDocumentNode nodeAtOffset = this.getNodeAtOffset(offset);
            if (nodeAtOffset.nodeType() == APEXLangDocumentNode.NodeType.COMPONENT_NAME) {
                int line = nodeAtOffset.range().start().line();
                idLine = this.uri.toString() + ":" + line;
            } else {
                idLine = "";
            }
        } else {
            idLine = idLocation.path() + ":" + idLocation.range().start().line();
        }
        ArrayList<APEXLangLocation> ret = new ArrayList<APEXLangLocation>();
        refs.forEach(arg_0 -> APEXLangDocumentState.lambda$getRenameLocations$14((String)idLine, ret, arg_0));
        return ret;
    }

    public String sanitizeName(String newName, APEXLangRange range) {
        int startOffset = this.getOffset(range.start().line() + 1, range.start().character());
        int endOffset = this.getOffset(range.end().line() + 1, range.end().character());
        String oldName = this.text.substring(startOffset, endOffset);
        Object sanitizedName = !this.valueIsQuoted(newName) && this.valueNeedsQuotes(newName) ? "\"" + newName + "\"" : newName;
        if (this.valueIsQuoted((String)sanitizedName)) {
            return sanitizedName;
        }
        if (this.valueIsQuoted(oldName) && !this.valueNeedsQuotes(oldName.substring(1, oldName.length() - 2))) {
            return "\"" + (String)sanitizedName + "\"";
        }
        return sanitizedName;
    }

    private boolean valueIsQuoted(String newName) {
        return newName.startsWith("\"") && newName.endsWith("\"") && newName.length() > 1;
    }

    private boolean valueNeedsQuotes(String newName) {
        return !this.valueIsQuoted(newName) && (newName.startsWith("\"") || newName.endsWith("\"") || newName.contains("]") || newName.contains("```") || newName.contains("//"));
    }

    private APEXLangRange getValueRange(ComponentParameter componentParameter) {
        return APEXLangRange.of(componentParameter.getLine() - 1, componentParameter.getColumn() + componentParameter.getValueRange().getStart() - componentParameter.getRange().getStart(), componentParameter.getLine() - 1, componentParameter.getColumn() + componentParameter.getValueRange().getEnd() - componentParameter.getRange().getStart());
    }

    private APEXLangRange getKeyRange(ComponentParameter componentParameter) {
        return APEXLangRange.of(componentParameter.getLine() - 1, componentParameter.getColumn() + componentParameter.getKeyRange().getStart() - componentParameter.getRange().getStart(), componentParameter.getLine() - 1, componentParameter.getColumn() + componentParameter.getKeyRange().getEnd() - componentParameter.getRange().getStart());
    }

    private void addToReferences(List<APEXLangLocation> references, Component component, ComponentParameter componentParameter) {
        this.addToReferences(references, component, componentParameter, false);
    }

    private void addToReferences(List<APEXLangLocation> references, Component component, ComponentParameter componentParameter, boolean key) {
        APEXLangRange range = key ? this.getKeyRange(componentParameter) : this.getValueRange(componentParameter);
        String path = this.applicationState.getUri(component.getFilename()).toString();
        APEXLangLocation loc = APEXLangLocation.builder().path(path).range(range).build();
        references.add(loc);
    }

    private boolean isComponentReference(Property property) {
        LOV lov = property.getLov();
        LOV.LOVType lovType = lov == null ? null : lov.getType();
        String value = lovType == null ? null : lovType.getValue();
        return "COMPONENT".equals(value);
    }

    private APEXLangRange convertRange(Range range) {
        if (range != null) {
            Position start = this.getPosition(range.getStart());
            Position end = this.getPosition(range.getEnd());
            return APEXLangRange.of(start.getLine() - 1, start.getCharacter(), end.getLine() - 1, end.getCharacter());
        }
        return null;
    }

    public APEXLangHoverItem getHoverItem(int offset) {
        APEXLangDocumentNode nodeAtOffset = this.getNodeAtOffset(offset);
        SubstitutionToken substitutionToken = this.getSubstitutionToken(nodeAtOffset, offset);
        if (substitutionToken != null && substitutionToken.complete) {
            substitutionToken.token = this.applicationState.getApexSubstitutionDefinitionKey(substitutionToken.token);
            String contents = null;
            if (substitutionToken.type == SubstitutionType.TEMPLATE_SUBSTITUTION && DEFAULT.equals(substitutionToken.token)) {
                String templateType = this.getDefaultTemplateOptionType(nodeAtOffset);
                if (templateType != null) {
                    contents = ApexLangMessages.format(DEFAULT, templateType);
                }
            } else if (substitutionToken.type != null && this.applicationState.getApexSubstitutionDefinitions().containsKey(substitutionToken.token)) {
                contents = ApexLangMessages.get(substitutionToken.token);
            }
            if (contents != null) {
                Position startPos = this.getPosition(substitutionToken.startOffset);
                Position endPos = this.getPosition(substitutionToken.startOffset + substitutionToken.token.length());
                APEXLangRange range = APEXLangRange.builder().start(APEXLangPosition.builder().line(startPos.getLine() - 1).character(startPos.getCharacter() - 1).build()).end(APEXLangPosition.builder().line(endPos.getLine() - 1).character(endPos.getCharacter() - 1).build()).build();
                return APEXLangHoverItem.builder().range(range).markdownText(contents).build();
            }
        }
        return null;
    }

    private SubstitutionToken getSubstitutionToken(APEXLangDocumentNode nodeAtOffset, int offset) {
        String dataType;
        Property property;
        SubstitutionToken substitutionToken = null;
        if (nodeAtOffset != null && nodeAtOffset.range() != null && (nodeAtOffset.nodeType() == APEXLangDocumentNode.NodeType.PROPERTY_VALUE || nodeAtOffset.nodeType() == APEXLangDocumentNode.NodeType.ARRAY_PROPERTY) && (property = nodeAtOffset.property()) != null && (dataType = ((PropertyType)this.metaMetaData.getPropertyTypes().get(property.getType())).getDataType()).equals("string")) {
            int pos;
            String token;
            int start = nodeAtOffset.startOffset();
            int end = nodeAtOffset.endOffset();
            String nodeString = this.text.substring(start, end);
            StringTokenizer tokenizer = new StringTokenizer(nodeString, " \t\n\r:;.,<>{}[]()~'\"&^%#@!+-=*/", true);
            String[] tokens = new String[]{"", "", "", "", "", ""};
            for (pos = start; tokenizer.hasMoreTokens() && pos < offset && pos < end; pos += token.length()) {
                token = tokenizer.nextToken();
                if (token.matches("\\s")) continue;
                tokens[0] = tokens[1];
                tokens[1] = tokens[2];
                tokens[2] = tokens[3];
                tokens[3] = token;
            }
            int i = 4;
            while (i < 6 && tokenizer.hasMoreTokens()) {
                String token2 = tokenizer.nextToken();
                if (token2.matches("\\s")) continue;
                tokens[i++] = token2;
            }
            SubstitutionType type = null;
            boolean complete = false;
            if (":".equals(tokens[2])) {
                type = SubstitutionType.BIND_VARIABLE;
                complete = true;
            } else if (("V".equals(tokens[0].toUpperCase(Locale.ROOT)) || "NV".equals(tokens[0].toUpperCase(Locale.ROOT))) && "(".equals(tokens[1]) && "'".equals(tokens[2])) {
                type = SubstitutionType.PLSQL_ARG;
                if ("'".equals(tokens[4]) && ")".equals(tokens[5])) {
                    complete = true;
                }
            } else if ("&".equals(tokens[2])) {
                type = SubstitutionType.SUBSTITUTION;
                if (".".equals(tokens[4])) {
                    complete = true;
                }
            } else if ("#".equals(tokens[2])) {
                type = SubstitutionType.TEMPLATE_SUBSTITUTION;
                if ("#".equals(tokens[4])) {
                    complete = true;
                }
            }
            if (type != null) {
                substitutionToken = new SubstitutionToken();
                substitutionToken.token = tokens[3];
                substitutionToken.startOffset = pos - substitutionToken.token.length();
                substitutionToken.type = type;
                substitutionToken.complete = complete;
            }
        }
        return substitutionToken;
    }

    private String getDefaultTemplateOptionType(APEXLangDocumentNode nodeAtOffset) {
        String propertyId = this.metaMetaData.getProperties().keySet().stream().filter(k -> this.metaMetaData.getProperties().get(k) == nodeAtOffset.property()).findFirst().orElse(null);
        if (propertyId != null) {
            ComponentType.ComponentProperty componentProperty = (ComponentType.ComponentProperty)nodeAtOffset.component().getComponentType().getProperties().get(propertyId);
            ComponentType.Parents[] parents = componentProperty == null ? null : componentProperty.getParents();
            String par0propId = parents == null && parents.length > 0 ? null : parents[0].getPropertyId();
            Property par0prop = par0propId == null ? null : (Property)this.metaMetaData.getProperties().get(par0propId);
            String compTypeId = par0prop == null ? null : par0prop.getLov().getComponentTypeId();
            ComponentType componentType = compTypeId == null ? null : (ComponentType)this.metaMetaData.getComponentTypes().get(compTypeId);
            return componentType == null ? null : (String)componentType.getTitle().getSingular().get("en");
        }
        return null;
    }

    public List<APEXLangCodeActionItem> getCodeActionItems(APEXLangRange range, List<String> only) {
        List<APEXLangMessage> diagnostics;
        ArrayList<APEXLangCodeActionItem> results = new ArrayList<APEXLangCodeActionItem>();
        if (this.acceptableActionType(only, QUICKFIX) && (diagnostics = this.getMessages(null)) != null && !diagnostics.isEmpty()) {
            for (APEXLangMessage diagnostic : diagnostics) {
                APEXLangCodeActionItem updateItem;
                APEXLangFileUpdate edit;
                PageInfo pageInfo;
                if (diagnostic.startLine() != range.start().line()) continue;
                if (diagnostic.errorType() == APEXLangSyntaxError.ErrorType.VALUE_NOT_LOWERCASE || diagnostic.errorType() == APEXLangSyntaxError.ErrorType.VALUE_NOT_UPPERCASE) {
                    String title;
                    String newText;
                    Integer startLine = this.offsets.get(range.start().line());
                    int endLine = this.offsets.get(range.start().line() + 1) - 1;
                    String line = this.text.substring(startLine, endLine);
                    int colonPos = line.indexOf(":");
                    if (colonPos <= 0) continue;
                    String originalText = this.text.substring(startLine + colonPos, endLine);
                    Range valueRange = new Range(Integer.valueOf(startLine + colonPos), Integer.valueOf(endLine));
                    if (diagnostic.errorType() == APEXLangSyntaxError.ErrorType.VALUE_NOT_LOWERCASE) {
                        newText = originalText.toLowerCase(Locale.ROOT);
                        title = ApexLangMessages.get("REPLACE_WITH_LOWERCASE");
                    } else {
                        newText = originalText.toUpperCase(Locale.ROOT);
                        title = ApexLangMessages.get("REPLACE_WITH_UPPERCASE");
                    }
                    APEXLangFileUpdate edit2 = APEXLangFileUpdate.builder().uri(this.uri).version(this.version).updateType(APEXLangFileUpdate.UpdateType.EDIT).range(this.convertRange(valueRange)).text(newText).build();
                    APEXLangCodeActionItem updateItem2 = APEXLangCodeActionItem.builder().title(title).kind(QUICKFIX).addUpdate(edit2).build();
                    results.add(updateItem2);
                    continue;
                }
                String message = diagnostic.message();
                if (!APEXLangCompiler.PAGE_ALIAS_DOES_NOT_MATCH.equals(message) && !APEXLangCompiler.PAGE_NUMBER_DOES_NOT_MATCH.equals(message) || (pageInfo = this.getPageInfo()) == null || pageInfo.pageNumberNode == null) continue;
                String newName = this.getExpectedFilename(pageInfo);
                APEXLangFileUpdate rename = APEXLangFileUpdate.builder().uri(this.uri).updateType(APEXLangFileUpdate.UpdateType.RENAME).newUri(this.uri.resolve(newName)).build();
                APEXLangCodeActionItem renameFileItem = APEXLangCodeActionItem.builder().title(ApexLangMessages.get("RENAME_FILE")).kind(QUICKFIX).addUpdate(rename).build();
                results.add(renameFileItem);
                if (APEXLangCompiler.PAGE_NUMBER_DOES_NOT_MATCH.equals(message)) {
                    edit = APEXLangFileUpdate.builder().uri(this.uri).version(this.version).updateType(APEXLangFileUpdate.UpdateType.EDIT).range(pageInfo.pageNumberNode.range()).text(pageInfo.pageNumberInFileName.toString()).build();
                    updateItem = APEXLangCodeActionItem.builder().title(ApexLangMessages.get("UPDATE_PAGE_NUMBER")).kind(QUICKFIX).addUpdate(edit).build();
                    results.add(updateItem);
                    continue;
                }
                if (!APEXLangCompiler.PAGE_ALIAS_DOES_NOT_MATCH.equals(message)) continue;
                edit = APEXLangFileUpdate.builder().uri(this.uri).version(this.version).updateType(APEXLangFileUpdate.UpdateType.EDIT).range(pageInfo.pageAliasNode.range()).text(pageInfo.pageAliasInFileName.toUpperCase(Locale.ROOT)).build();
                updateItem = APEXLangCodeActionItem.builder().title(ApexLangMessages.get("UPDATE_PAGE_ALIAS")).kind(QUICKFIX).addUpdate(edit).build();
                results.add(updateItem);
            }
        }
        if (this.acceptableActionType(only, REFACTOR)) {
            APEXLangCodeActionItem outlineAction;
            int offset = this.getOffset(range.start().line() + 1, range.start().character());
            APEXLangDocumentNode node = this.getNodeAtOffset(offset);
            if (node.language() != null && node.range().end().line() - node.range().start().line() > 2) {
                outlineAction = APEXLangCodeActionItem.builder().title(ApexLangMessages.get("EXTRACT_EMBEDDED")).kind(REFACTOR).resolveData(EXTRACT_EMBEDDED_KEY + offset).build();
                results.add(outlineAction);
            } else if (node.languageFileRef()) {
                outlineAction = APEXLangCodeActionItem.builder().title(ApexLangMessages.get("INLINE_EMBEDDED")).kind(REFACTOR).resolveData(INLINE_EMBEDDED_KEY + offset).build();
                results.add(outlineAction);
            }
        }
        return results;
    }

    public APEXLangCodeActionItem codeActionResolve(APEXLangCodeActionItem incomplete) {
        Path contentFilePath;
        File contentFile;
        int offset;
        APEXLangDocumentNode node;
        String resolveData = incomplete.resolveData();
        if (resolveData != null && resolveData.startsWith(EXTRACT_EMBEDDED_KEY)) {
            int offset2 = Integer.parseInt(resolveData.substring(EXTRACT_EMBEDDED_KEY.length()));
            APEXLangDocumentNode node2 = this.getNodeAtOffset(offset2);
            if (node2.language() != null && !node2.languageFileRef() && node2.range().end().line() - node2.range().start().line() > 2) {
                String extension = node2.language().equals(PLSQL_LANGUAGE) ? PLSQL_FILE_EXTENSION : (node2.language().startsWith(JAVASCRIPT_LANGUAGE) ? JAVASCRIPT_FILE_EXTENSION : node2.language());
                String owningFilename = Path.of(this.uri).toFile().getName();
                if (owningFilename.indexOf(".") > 0) {
                    owningFilename = owningFilename.substring(0, owningFilename.lastIndexOf("."));
                }
                String propName = node2.parent().name();
                String prefix = owningFilename + propName.substring(0, 1).toUpperCase(Locale.ROOT) + propName.substring(1);
                List existingFiles = Arrays.stream(Path.of(this.uri).getParent().toFile().list()).collect(Collectors.toUnmodifiableList());
                int suffix = 1;
                String filename = prefix + "." + extension;
                while (existingFiles.contains(filename)) {
                    filename = prefix + String.format("%02d", ++suffix) + "." + extension;
                }
                String newPropNameValue = node2.property().getName() + "File: " + filename;
                URI newUri = this.uri.resolve(filename);
                return APEXLangCodeActionItem.builder().title(incomplete.title()).kind(incomplete.kind()).addUpdate(APEXLangFileUpdate.builder().uri(newUri).updateType(APEXLangFileUpdate.UpdateType.CREATE).build()).addUpdate(APEXLangFileUpdate.builder().uri(newUri).version(1).updateType(APEXLangFileUpdate.UpdateType.EDIT).range(APEXLangRange.of(0, 0, 0, 0)).text(node2.componentParameter().getValue()).build()).addUpdate(APEXLangFileUpdate.builder().uri(this.uri).version(this.version).updateType(APEXLangFileUpdate.UpdateType.EDIT).range(node2.parent().range()).text(newPropNameValue).build()).build();
            }
        } else if (resolveData != null && resolveData.startsWith(INLINE_EMBEDDED_KEY) && (node = this.getNodeAtOffset(offset = Integer.parseInt(resolveData.substring(INLINE_EMBEDDED_KEY.length())))).languageFileRef() && (contentFile = (contentFilePath = Path.of(this.uri.resolve(".")).resolve(node.parent().detail())).toFile()).exists()) {
            List<String> lines = null;
            try {
                lines = Files.readAllLines(contentFilePath);
            }
            catch (IOException e) {
                lines = null;
            }
            if (lines != null) {
                APEXLangRange range = this.convertRange(node.componentParameter().getRange());
                int indent = range.start().character() + 4;
                String padding = String.format("%" + indent + "s", "");
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(node.property().getName()).append(": ```").append(node.language()).append("\n");
                for (String line : lines) {
                    stringBuilder.append(padding).append(line).append("\n");
                }
                stringBuilder.append(padding).append("```");
                return APEXLangCodeActionItem.builder().title(incomplete.title()).kind(incomplete.kind()).addUpdate(APEXLangFileUpdate.builder().uri(contentFilePath.toUri()).updateType(APEXLangFileUpdate.UpdateType.DELETE).build()).addUpdate(APEXLangFileUpdate.builder().uri(this.uri).version(this.version).updateType(APEXLangFileUpdate.UpdateType.EDIT).range(node.parent().range()).text(stringBuilder.toString()).build()).build();
            }
        }
        return null;
    }

    private PageInfo getPageInfo() {
        Integer pageInSource = this.getPageId();
        if (pageInSource != null) {
            String filename;
            Matcher matcher;
            PageInfo info = new PageInfo();
            info.pageNumberInSource = pageInSource;
            if (this.rootNode.children().size() == 1) {
                APEXLangDocumentNode pageNode = this.rootNode.children().get(0);
                info.pageNumberNode = pageNode.children().stream().filter(n -> n.nodeType() == APEXLangDocumentNode.NodeType.COMPONENT_NAME).findFirst().orElse(null);
                ComponentParameter aliasComParam = (ComponentParameter)pageNode.component().getParameters().get(this.pageAliasPropertyId);
                if (aliasComParam != null) {
                    APEXLangDocumentNode aliasNode = this.getNodeAtOffset(this.getOffset(aliasComParam.getLine(), aliasComParam.getColumn()));
                    info.pageAliasNode = aliasNode.parent().children().stream().filter(n -> n.nodeType() == APEXLangDocumentNode.NodeType.PROPERTY_VALUE).findFirst().orElse(null);
                    String string = info.pageAliasInSource = info.pageAliasNode == null ? null : info.pageAliasNode.name();
                }
            }
            if ((matcher = APEXLangCompiler.PAGE_FILENAME_PATTERN.matcher(filename = Path.of(this.uri).getFileName().toString())).matches()) {
                try {
                    info.pageNumberInFileName = Integer.parseInt(matcher.group(1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                info.pageAliasInFileName = matcher.group(2);
            }
            return info;
        }
        return null;
    }

    private String getExpectedFilename(PageInfo pageInfo) {
        Integer pageId = this.getPageId();
        String pageIdString = pageId.toString();
        if (pageIdString.length() < 5) {
            pageIdString = String.format("%05d", pageId);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("p").append(pageIdString);
        if (pageInfo.pageAliasInSource != null) {
            stringBuilder.append("-").append(pageInfo.pageAliasInSource.toLowerCase(Locale.ROOT));
        }
        stringBuilder.append(".apx");
        return stringBuilder.toString();
    }

    private boolean acceptableActionType(List<String> only, String type) {
        return only == null || only.size() == 0 || only.contains(type);
    }

    private static /* synthetic */ void lambda$getRenameLocations$14(String idLine, List ret, APEXLangLocation identifierLocation) {
        String refLine = identifierLocation.path() + ":" + identifierLocation.range().start().line();
        int charOffset = 0;
        if (!refLine.equals(idLine)) {
            charOffset = 1;
        }
        APEXLangRange range = APEXLangRange.of(identifierLocation.range().start().line(), identifierLocation.range().start().character() + charOffset, identifierLocation.range().end().line(), identifierLocation.range().end().character());
        ret.add(APEXLangLocation.builder().path(identifierLocation.path()).range(range).build());
    }

    private static class SubstitutionToken {
        String token;
        int startOffset;
        SubstitutionType type;
        boolean complete;

        private SubstitutionToken() {
        }
    }

    private static enum SubstitutionType {
        BIND_VARIABLE,
        PLSQL_ARG,
        SUBSTITUTION,
        TEMPLATE_SUBSTITUTION;

    }

    private class PageInfo {
        private Integer pageNumberInFileName;
        private Integer pageNumberInSource;
        private String pageAliasInFileName;
        private String pageAliasInSource;
        private APEXLangDocumentNode pageNumberNode;
        private APEXLangDocumentNode pageAliasNode;

        private PageInfo() {
        }
    }
}

