/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.core.apexlang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import oracle.apexlang.core.Component;
import oracle.apexlang.core.ComponentParameter;
import oracle.apexlang.metametadata.Property;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangRange;

public class APEXLangDocumentNode {
    private final NodeType nodeType;
    private final Component component;
    private final ComponentParameter componentParameter;
    private final String propertyId;
    private final Property property;
    private final APEXLangRange range;
    private final int startOffset;
    private final int endOffset;
    private final String name;
    private final String detail;
    private final String language;
    private final APEXLangDocumentNode parent;
    private final List<APEXLangDocumentNode> children;
    private final boolean languageFileRef;

    public NodeType nodeType() {
        return this.nodeType;
    }

    Component component() {
        return this.component;
    }

    ComponentParameter componentParameter() {
        return this.componentParameter;
    }

    String propertyId() {
        return this.propertyId;
    }

    Property property() {
        return this.property;
    }

    public APEXLangRange range() {
        return this.range;
    }

    @Deprecated
    public APEXLangRange range2() {
        return this.range;
    }

    public int startOffset() {
        return this.startOffset;
    }

    public int endOffset() {
        return this.endOffset;
    }

    public String name() {
        return this.name;
    }

    public String detail() {
        return this.detail;
    }

    public String language() {
        return this.language;
    }

    public boolean languageFileRef() {
        return this.languageFileRef;
    }

    public boolean isOracleSql() {
        return ("sql".equals(this.language) || "plsql".equals(this.language)) && !this.languageFileRef;
    }

    public APEXLangDocumentNode parent() {
        return this.parent;
    }

    public List<APEXLangDocumentNode> children() {
        return Collections.unmodifiableList(this.children);
    }

    private APEXLangDocumentNode(Builder builder) {
        this.nodeType = builder.nodeType;
        this.component = builder.component;
        this.componentParameter = builder.componentParameter;
        this.propertyId = builder.propertyId;
        this.property = builder.property;
        this.range = builder.range;
        this.startOffset = builder.startOffset;
        this.endOffset = builder.endOffset;
        this.name = builder.name;
        this.detail = builder.detail;
        this.language = builder.language;
        this.languageFileRef = builder.languageFileRef;
        this.parent = builder.parent;
        this.children = new ArrayList<APEXLangDocumentNode>();
        builder.children.forEach(childBuilder -> this.children.add(childBuilder.parent(this).build()));
        this.children.sort(Comparator.comparingInt(o -> o.startOffset));
        if (this.property == null != (this.propertyId == null)) {
            throw new IllegalStateException("property/propertyId mismatch");
        }
    }

    private APEXLangDocumentNode(APEXLangDocumentNode node) {
        this.nodeType = node.nodeType;
        this.component = node.component;
        this.componentParameter = node.componentParameter;
        this.propertyId = node.propertyId;
        this.property = node.property;
        this.range = node.range;
        this.startOffset = node.startOffset;
        this.endOffset = node.endOffset;
        this.name = node.name;
        this.detail = node.detail;
        this.language = node.language;
        this.parent = node.parent;
        this.languageFileRef = node.languageFileRef;
        this.children = new ArrayList<APEXLangDocumentNode>();
    }

    APEXLangDocumentNode clone(Function<APEXLangDocumentNode, Boolean> checkFn) {
        APEXLangDocumentNode cloned = null;
        if (checkFn.apply(this).booleanValue()) {
            cloned = new APEXLangDocumentNode(this);
            for (APEXLangDocumentNode child : this.children) {
                APEXLangDocumentNode cloneChild = child.clone(checkFn);
                if (cloneChild == null) continue;
                cloned.children.add(cloneChild);
            }
        }
        return cloned;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum NodeType {
        COMPONENT,
        GROUP,
        TEXT_PROPERTY,
        NUMERIC_PROPERTY,
        BOOLEAN_PROPERTY,
        LOV_PROPERTY,
        ARRAY_PROPERTY,
        COMPONENT_TYPE,
        COMPONENT_NAME,
        GROUP_NAME,
        PROPERTY_NAME,
        PROPERTY_VALUE;

    }

    public static class Builder {
        private NodeType nodeType;
        private Component component;
        private ComponentParameter componentParameter;
        private String propertyId;
        private Property property;
        private APEXLangRange range;
        private int startOffset;
        private int endOffset;
        private String name;
        private String detail;
        private String language;
        private boolean languageFileRef;
        private APEXLangDocumentNode parent;
        private final List<Builder> children = new ArrayList<Builder>();

        private Builder() {
        }

        public APEXLangDocumentNode build() {
            return new APEXLangDocumentNode(this);
        }

        public Builder newChild() {
            Builder childBuilder = new Builder();
            this.children.add(childBuilder);
            return childBuilder;
        }

        private Builder parent(APEXLangDocumentNode parent) {
            this.parent = parent;
            return this;
        }

        public Builder nodeType(NodeType nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        Builder component(Component component) {
            this.component = component;
            return this;
        }

        Builder componentParameter(ComponentParameter componentParameter) {
            this.componentParameter = componentParameter;
            return this;
        }

        Builder propertyId(String propertyId) {
            this.propertyId = propertyId;
            return this;
        }

        Builder property(Property property) {
            this.property = property;
            return this;
        }

        public Builder range(APEXLangRange range) {
            this.range = range;
            return this;
        }

        @Deprecated
        public Builder range2(APEXLangRange range) {
            this.range = range;
            return this;
        }

        public Builder startOffset(int startOffset) {
            this.startOffset = startOffset;
            return this;
        }

        public Builder endOffset(int endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder detail(String detail) {
            this.detail = detail;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder languageFileRef(boolean languageFileRef) {
            this.languageFileRef = languageFileRef;
            return this;
        }
    }
}

