/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.core.apexlang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangEditItem;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangFileChange;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangFileUpdate;

public class APEXLangCodeActionItem {
    private final String title;
    private final String kind;
    private final List<APEXLangFileUpdate> updates;
    private final String resolveData;
    private final String commandId;
    private final List<Object> commandArguments;
    private final List<APEXLangEditItem> edits;
    private final List<APEXLangFileChange> fileChanges;

    private APEXLangCodeActionItem(Builder builder) {
        this.title = builder.title;
        this.kind = builder.kind;
        this.updates = builder.updates == null ? null : Collections.unmodifiableList(builder.updates);
        this.resolveData = builder.resolveData;
        this.commandId = builder.commandId;
        this.commandArguments = builder.commandArguments == null ? null : Collections.unmodifiableList(builder.commandArguments);
        this.edits = builder.edits;
        this.fileChanges = builder.fileChanges;
    }

    public String title() {
        return this.title;
    }

    public String kind() {
        return this.kind;
    }

    public List<APEXLangFileUpdate> updates() {
        return this.updates;
    }

    public String resolveData() {
        return this.resolveData;
    }

    public String commandId() {
        return this.commandId;
    }

    public List<Object> commandArguments() {
        return this.commandArguments;
    }

    @Deprecated
    public List<APEXLangEditItem> edits() {
        return this.edits;
    }

    @Deprecated
    public List<APEXLangFileChange> fileChanges() {
        return this.fileChanges;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String title;
        private String kind;
        private final List<APEXLangFileUpdate> updates = new ArrayList<APEXLangFileUpdate>();
        private String resolveData;
        private String commandId;
        private List<Object> commandArguments;
        private List<APEXLangEditItem> edits;
        private List<APEXLangFileChange> fileChanges;

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        public Builder addUpdate(APEXLangFileUpdate update) {
            this.updates.add(update);
            return this;
        }

        public Builder resolveData(String resolveData) {
            this.resolveData = resolveData;
            return this;
        }

        public Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public Builder commandArguments(List<Object> commandArguments) {
            this.commandArguments = commandArguments;
            return this;
        }

        @Deprecated
        public Builder edits(List<APEXLangEditItem> edits) {
            this.edits = edits;
            return this;
        }

        @Deprecated
        public Builder fileChanges(List<APEXLangFileChange> fileChanges) {
            this.fileChanges = fileChanges;
            return this;
        }

        public APEXLangCodeActionItem build() {
            return new APEXLangCodeActionItem(this);
        }
    }
}

