/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.core.apexlang;

import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oracle.apexlang.APEXAppFile;
import oracle.apexlang.FileLoader;
import oracle.apexlang.core.APEXLangAlert;
import oracle.apexlang.core.APEXLangCompilationResult;
import oracle.apexlang.core.APEXLangCompilerContext;
import oracle.apexlang.core.APEXLangManifestObject;
import oracle.apexlang.core.APEXLangSuggestion;
import oracle.apexlang.core.APEXLangSyntaxError;
import oracle.apexlang.core.APEXLangWarning;
import oracle.apexlang.core.Component;
import oracle.apexlang.core.ComponentParameter;
import oracle.apexlang.core.Location;
import oracle.apexlang.metametadata.ComponentType;
import oracle.apexlang.metametadata.Metametadata;
import oracle.apexlang.metametadata.Property;
import oracle.dbtools.extension.apex.core.apexlang.APEXApplicationInstallOverrides;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangDocumentState;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangImporter;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangMessage;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangTranspiler;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class APEXLangApplicationState {
    private static final APEXAppFile EMPTY_APEX_APP_FILE = new APEXAppFile("");
    private final Path rootPath;
    private BigDecimal applicationId;
    private final APEXLangTranspiler apexLangTranspiler;
    private final APEXLangCompilerContext apexLangCompilerContext;
    private final Map<String, Map<String, Boolean>> apexSubstitutionDefinitions;
    private final Map<String, String> legacySubstitutionVariableNames;
    private APEXLangSyntaxError[] importErrors;

    public APEXLangApplicationState(Path rootPath) {
        this.rootPath = rootPath;
        this.apexLangTranspiler = new APEXLangTranspiler();
        this.applicationId = null;
        this.importErrors = new APEXLangSyntaxError[0];
        if (rootPath != null) {
            Map<String, APEXAppFile> fileMap = this.getApplicationFileMap(null);
            this.processManifest(fileMap);
            this.apexLangCompilerContext = this.apexLangTranspiler.getCompiler().getCompilerContext(fileMap);
        } else {
            this.apexLangCompilerContext = new APEXLangCompilerContext();
        }
        HashMap substDefns = new HashMap();
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            try (InputStream is = classLoader.getResourceAsStream("oracle/dbtools/extension/apex/core/apexlang/SubstitutionDefinitions.json");){
                Map parsed = JSON.std.mapFrom((Object)is);
                parsed.forEach((k, v) -> {
                    if (v instanceof Map) {
                        HashMap map = new HashMap();
                        ((Map)v).forEach((k2, v2) -> map.put((String)k2, (Boolean)v2));
                        substDefns.put(k, map);
                    }
                });
            }
            this.apexSubstitutionDefinitions = Collections.unmodifiableMap(substDefns);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.legacySubstitutionVariableNames = new HashMap<String, String>();
        this.legacySubstitutionVariableNames.put("IMAGE_PREFIX", "APEX_FILES");
        this.legacySubstitutionVariableNames.put("SESSION", "APP_SESSION");
        this.legacySubstitutionVariableNames.put("APP_IMAGES", "APP_FILES");
        this.legacySubstitutionVariableNames.put("THEME_DB_IMAGES", "THEME_DB_FILES");
        this.legacySubstitutionVariableNames.put("THEME_IMAGES", "THEME_FILES");
        this.legacySubstitutionVariableNames.put("WORKSPACE_IMAGE", "WORKSPACE_FILES");
    }

    public Map<String, APEXAppFile> getApplicationFileMap(Map<URI, String> openFiles) {
        FileLoader fileLoader = new FileLoader();
        HashMap<String, APEXAppFile> fileMap = new HashMap();
        try {
            fileMap = fileLoader.getFilesFromDirectory(this.rootPath.toString());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        HashMap<String, APEXAppFile> finalMap = fileMap;
        if (openFiles != null) {
            openFiles.forEach((uri, source) -> {
                String osIndepPath = Path.of(uri).toUri().getPath();
                String osIndepRoot = this.rootPath.toUri().getPath();
                String key = osIndepPath.substring(osIndepRoot.length());
                finalMap.put(key, new APEXAppFile(source));
            });
        }
        return fileMap;
    }

    public APEXLangCompilationResult compileApplication(Map<URI, String> openFiles) {
        return this.apexLangTranspiler.transpile(this.getApplicationFileMap(openFiles), new APEXLangCompilerContext());
    }

    public APEXLangCompilationResult compile(URI uri, String source, System.Logger logger) {
        APEXLangCompilationResult result;
        block4: {
            String relativePath = this.getRelativeFilePath(uri.getPath());
            HashMap<String, APEXAppFile> fileMap = new HashMap<String, APEXAppFile>();
            try {
                this.addNonApexFiles(fileMap, this.rootPath);
                this.processManifest(fileMap);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            fileMap.put(relativePath, new APEXAppFile(source));
            result = null;
            try {
                result = this.apexLangTranspiler.transpile(fileMap, this.apexLangCompilerContext);
            }
            catch (Exception e) {
                if (logger == null) break block4;
                logger.log(System.Logger.Level.ERROR, e);
            }
        }
        return result;
    }

    public APEXLangDocumentState newDocumentState(String text, int version, URI uri, System.Logger logger) {
        return new APEXLangDocumentState(text, version, uri, this, logger);
    }

    String getRelativeFilePath(String uri) {
        String root = this.rootPath.toUri().getPath();
        if (uri.startsWith(root)) {
            return uri.substring(root.length());
        }
        return uri;
    }

    public URI getUri(String relativeFilePath) {
        if (this.rootPath != null) {
            return this.rootPath.resolve(relativeFilePath).toUri();
        }
        return null;
    }

    public Path getRootPath() {
        return this.rootPath;
    }

    public List<String> getAvailableReferences(String propertyId, ComponentParameter componentParameter) {
        Objects.requireNonNull(propertyId);
        Objects.requireNonNull(componentParameter);
        return this.apexLangTranspiler.getCompiler().getAvailableReferences(propertyId, componentParameter.getComponent(), this.apexLangCompilerContext);
    }

    public Location getReferenceLocation(String propertyId, ComponentParameter componentParameter) {
        if (propertyId != null && componentParameter != null) {
            Location loc;
            Object reference = componentParameter.getValue();
            if (reference != null && !((String)reference).startsWith("@")) {
                reference = "@" + (String)reference;
            }
            if ((loc = this.apexLangTranspiler.getCompiler().getReferenceLocation(propertyId, componentParameter.getComponent(), this.apexLangCompilerContext, (String)reference)) != null) {
                return new Location(this.getUri(loc.getFilePath()).toString(), loc.getPostion());
            }
        }
        return null;
    }

    public List<ComponentType> getAvailableChildComponentTypes(Component component) {
        Metametadata mmd = this.getMetaMetaData();
        ArrayList<ComponentType> ret = new ArrayList<ComponentType>();
        String parentComponentTypeId = component.getTypeId();
        if (parentComponentTypeId != null) {
            for (Map.Entry entry : mmd.getComponentTypes().entrySet()) {
                ComponentType componentType = (ComponentType)entry.getValue();
                ComponentType.Parent parent = componentType.getParent();
                if (parent == null || !parentComponentTypeId.equals(parent.getComponentTypeId())) continue;
                ret.add(componentType);
            }
        }
        return ret;
    }

    public List<Property> getAvailableProperties(Component component) {
        Metametadata mmd = this.getMetaMetaData();
        Set setPropIds = component.getParameters().keySet();
        ComponentType componentType = (ComponentType)mmd.getComponentTypes().get(component.getTypeId());
        Set availablePropIds = componentType.getProperties().keySet();
        ArrayList<Property> ret = new ArrayList<Property>();
        for (Map.Entry entry : mmd.getProperties().entrySet()) {
            if (!availablePropIds.contains(entry.getKey()) || setPropIds.contains(entry.getKey())) continue;
            ret.add((Property)entry.getValue());
        }
        return ret;
    }

    public List<APEXLangSuggestion> getSuggestions(URI uri, String source, int offset) {
        HashMap<String, APEXAppFile> fileMap = new HashMap<String, APEXAppFile>();
        String relativePath = this.getRelativeFilePath(uri.getPath());
        fileMap.put(relativePath, new APEXAppFile(source));
        try {
            this.addNonApexFiles(fileMap, this.rootPath);
            this.processManifest(fileMap);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        List suggestions = this.apexLangTranspiler.getCompiler().getSuggestions(fileMap, this.apexLangCompilerContext, relativePath, offset);
        if (suggestions == null) {
            return List.of();
        }
        return suggestions;
    }

    public BigDecimal getApplicationId() {
        return this.applicationId;
    }

    public Metametadata getMetaMetaData() {
        return this.apexLangTranspiler.getMetaMetaData();
    }

    private void addNonApexFiles(Map<String, APEXAppFile> fileMap, Path path) throws IOException {
        try (Stream<Path> stream = Files.list(path);){
            for (Path childPath : stream.collect(Collectors.toList())) {
                if (Files.isDirectory(childPath, new LinkOption[0])) {
                    this.addNonApexFiles(fileMap, childPath);
                    continue;
                }
                String relativePath = this.getRelativeFilePath(childPath.toString());
                if (relativePath.equals("config.json")) {
                    fileMap.put(relativePath, new APEXAppFile(Files.readString(childPath)));
                    continue;
                }
                if (relativePath.endsWith(".apx")) continue;
                fileMap.put(relativePath, EMPTY_APEX_APP_FILE);
            }
        }
    }

    private void processManifest(Map<String, APEXAppFile> fileMap) {
        this.applicationId = null;
        if (fileMap.containsKey("config.json")) {
            try {
                String configContent = fileMap.get("config.json").getContentString();
                APEXLangManifestObject manifestObject = (APEXLangManifestObject)JSON.std.beanFrom(APEXLangManifestObject.class, (Object)configContent);
                if (manifestObject != null && manifestObject.getApp_id() != null) {
                    this.applicationId = new BigDecimal(manifestObject.getApp_id());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    Map<String, Map<String, Boolean>> getApexSubstitutionDefinitions() {
        return this.apexSubstitutionDefinitions;
    }

    String getApexSubstitutionDefinitionKey(String name) {
        if (name.matches("APP_AJAX_X(0[1-9]|10)")) {
            return "APP_AJAX_Xnn";
        }
        if (this.legacySubstitutionVariableNames.containsKey(name)) {
            return this.legacySubstitutionVariableNames.get(name);
        }
        return name;
    }

    public List<APEXLangMessage> importApplication(Connection connection, APEXApplicationInstallOverrides installOverrides) {
        APEXLangSyntaxError[] errors;
        APEXLangCompilationResult result = this.compileApplication(null);
        if (result.getErrors().length > 0) {
            errors = result.getErrors();
        } else {
            ScriptRunnerContext context = new ScriptRunnerContext();
            APEXApplicationInstallOverrides overrides = installOverrides != null ? installOverrides : APEXApplicationInstallOverrides.builder().build();
            APEXLangImporter importer = new APEXLangImporter(connection, context, overrides);
            try {
                APEXLangSyntaxError[] aPEXLangSyntaxErrorArray;
                APEXLangSyntaxError plsError = importer.importResult(result);
                if (plsError == null) {
                    aPEXLangSyntaxErrorArray = new APEXLangSyntaxError[]{};
                } else {
                    APEXLangSyntaxError[] aPEXLangSyntaxErrorArray2 = new APEXLangSyntaxError[1];
                    aPEXLangSyntaxErrorArray = aPEXLangSyntaxErrorArray2;
                    aPEXLangSyntaxErrorArray2[0] = plsError;
                }
                errors = aPEXLangSyntaxErrorArray;
                this.importErrors = errors;
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }
        return Arrays.stream(errors).map(e -> this.convertAlertToMessage((APEXLangAlert)e)).collect(Collectors.toUnmodifiableList());
    }

    APEXLangMessage convertAlertToMessage(APEXLangAlert alert) {
        APEXLangMessage.Status status = alert instanceof APEXLangSyntaxError ? APEXLangMessage.Status.Error : APEXLangMessage.Status.Warning;
        APEXLangSyntaxError.ErrorType errorType = alert instanceof APEXLangSyntaxError ? ((APEXLangSyntaxError)alert).getErrorType() : null;
        APEXLangWarning.WarningType warningType = alert instanceof APEXLangWarning ? ((APEXLangWarning)alert).getWarningType() : null;
        APEXLangMessage.Builder builder = APEXLangMessage.builder();
        return builder.status(status).errorType(errorType).warningType(warningType).startLine(alert.getLine() - 1).startCharacter(alert.getColumn()).filename(this.getUri(alert.getFilename()).toString()).message(alert.getMsg()).endLine(alert.getLine() - 1).endCharacter(alert.getColumn() + alert.getOffendingSymbol().length()).build();
    }

    List<APEXLangSyntaxError> getImportErrors(String filename) {
        if (this.importErrors != null) {
            return Arrays.stream(this.importErrors).filter(e -> filename.equals(e.getFilename())).collect(Collectors.toUnmodifiableList());
        }
        return List.of();
    }
}

