/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.versions;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

class FallbackVersion {
    private static final DateTimeFormatter VERSION_PATTERN = DateTimeFormatter.ofPattern("yy.q.0.0");
    private static final DateTimeFormatter SHORT_VERSION_PATTERN = DateTimeFormatter.ofPattern("yy.q");
    private static final DateTimeFormatter BUILD_VERSION = DateTimeFormatter.ofPattern("yy.q.0.D.HHmm");
    private final String version;
    private final String shortVersion;
    private final String buildVersion;

    private FallbackVersion(LocalDateTime now) {
        this.version = VERSION_PATTERN.format(now);
        this.shortVersion = SHORT_VERSION_PATTERN.format(now);
        this.buildVersion = BUILD_VERSION.format(now);
    }

    public static FallbackVersion of(LocalDateTime now) {
        return new FallbackVersion(now);
    }

    public String buildVersion() {
        return this.buildVersion;
    }

    public String shortVersion() {
        return this.shortVersion;
    }

    public String version() {
        return this.version;
    }
}

