/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands.editor;

import java.sql.Connection;
import oracle.dbtools.plusplus.FileSystem;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.HelpMessages;
import oracle.dbtools.raptor.scriptrunner.commands.editor.Messages;

public class SaveCommand
extends CommandListener
implements IHelp {
    private static final String CMD = "save";
    private static final String FILE = "file";

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String suffix;
        String sqlpcmd = cmd.getSql().trim();
        String[] cmds = sqlpcmd.split("\\s+");
        Object filename = "";
        FileSystem.State fileCreate = FileSystem.State.UNKNOWN;
        switch (cmds.length) {
            case 1: {
                ctx.write(Messages.getString("SaveCommand.6"));
                ctx.write(this.getHelp());
                return true;
            }
            case 2: {
                filename = ctx.prependCD(cmds[1]);
                fileCreate = FileSystem.State.CREATE;
                break;
            }
            case 3: {
                if (cmds[1].toLowerCase().equals(FILE)) {
                    filename = ctx.prependCD(cmds[2]);
                    fileCreate = FileSystem.State.CREATE;
                    break;
                }
                filename = ctx.prependCD(cmds[1]);
                fileCreate = this.getMode(cmds[2]);
                break;
            }
            case 4: {
                filename = ctx.prependCD(cmds[2]);
                fileCreate = this.getMode(cmds[3]);
                break;
            }
        }
        if (((String)filename).lastIndexOf(".") == -1 && (suffix = (String)ctx.getProperty("script.runner.file.suffix")).length() > 0) {
            filename = (String)filename + "." + suffix;
        }
        switch (fileCreate) {
            case UNKNOWN: {
                ctx.write(Messages.getString("SaveCommand.0"));
                return true;
            }
            case CREATE: {
                ctx.write(ctx.getSQLPlusBuffer().save((String)filename, FileSystem.State.CREATE, (String)ctx.getProperty("script.runner.file.suffix")));
                break;
            }
            case APPEND: {
                ctx.write(ctx.getSQLPlusBuffer().save((String)filename, FileSystem.State.APPEND, (String)ctx.getProperty("script.runner.file.suffix")));
                break;
            }
            case REPLACE: {
                ctx.write(ctx.getSQLPlusBuffer().save((String)filename, FileSystem.State.REPLACE, (String)ctx.getProperty("script.runner.file.suffix")));
                break;
            }
            case BADMODE: {
                ctx.write(Messages.getString("SaveCommand.0"));
                ctx.write(this.getHelp());
                break;
            }
        }
        return true;
    }

    private FileSystem.State getMode(String string) {
        if (string == null) {
            return FileSystem.State.UNKNOWN;
        }
        if (string.toLowerCase().trim().equals("cre") || string.toLowerCase().trim().equals("create") || string.toLowerCase().trim().equals("crea") || string.toLowerCase().trim().equals("creat")) {
            return FileSystem.State.CREATE;
        }
        if (string.toLowerCase().trim().equals("app") || string.toLowerCase().trim().equals("append") || string.toLowerCase().trim().equals("appe") || string.toLowerCase().trim().equals("appen")) {
            return FileSystem.State.APPEND;
        }
        if (string.toLowerCase().trim().equals("rep") || string.toLowerCase().trim().equals("replace") || string.toLowerCase().trim().equals("repl") || string.toLowerCase().trim().equals("repla") || string.toLowerCase().trim().equals("replac")) {
            return FileSystem.State.REPLACE;
        }
        return FileSystem.State.BADMODE;
    }

    @Override
    public String getCommand() {
        return CMD.toUpperCase();
    }

    @Override
    public String getHelp() {
        return HelpMessages.getString(this.getCommand());
    }

    @Override
    public boolean isSqlPlus() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Saves the contents of the SQL buffer in a script";
    }
}

