/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import java.util.ArrayList;
import oracle.dbtools.raptor.console.ConsoleService;
import oracle.dbtools.raptor.console.StatusBarComponent;
import oracle.dbtools.raptor.console.StatusBarService;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class SetStatusBar
extends CommandListener
implements IShowCommand,
IStoreCommand {
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ConsoleService consoleService = (ConsoleService)ctx.getProperty("script.runner.jline");
        StatusBarService statusBarService = consoleService.getStatusBarService();
        if (cmd.getSql().trim().toLowerCase().replaceAll(" ", "").startsWith("setstatusbar") || cmd.getSql().trim().toLowerCase().replaceAll(" ", "").startsWith("setstatus")) {
            String[] parts = cmd.getSQLOrig().split("\\s+");
            boolean unrecognized = false;
            if (parts.length >= 3) {
                try {
                    switch (parts[2].toLowerCase()) {
                        case "on": {
                            if (parts.length == 3) {
                                statusBarService.setEnabled(true);
                                break;
                            }
                            unrecognized = true;
                            break;
                        }
                        case "off": {
                            if (parts.length == 3) {
                                statusBarService.setEnabled(false);
                                break;
                            }
                            unrecognized = true;
                            break;
                        }
                        case "add": {
                            if (parts.length == 4) {
                                String componentName = parts[3].toLowerCase();
                                if ("all".equals(componentName)) {
                                    statusBarService.addAllComponents();
                                    break;
                                }
                                statusBarService.addComponent(componentName);
                                break;
                            }
                            if (parts.length > 4) {
                                ArrayList<String> componentNames = new ArrayList<String>();
                                for (int p = 3; p < parts.length; ++p) {
                                    componentNames.add(parts[p].toLowerCase());
                                }
                                statusBarService.addComponents(componentNames);
                                break;
                            }
                            unrecognized = true;
                            break;
                        }
                        case "remove": {
                            if (parts.length == 4) {
                                String componentName = parts[3].toLowerCase();
                                statusBarService.removeComponent(componentName);
                                break;
                            }
                            if (parts.length > 4) {
                                ArrayList<String> componentNames = new ArrayList<String>();
                                for (int p = 3; p < parts.length; ++p) {
                                    componentNames.add(parts[p].toLowerCase());
                                }
                                statusBarService.removeComponents(componentNames);
                                break;
                            }
                            unrecognized = true;
                            break;
                        }
                        case "default": {
                            if (parts.length == 3) {
                                statusBarService.setToDefault();
                                break;
                            }
                            ArrayList<String> componentNames = new ArrayList<String>();
                            for (int p = 3; p < parts.length; ++p) {
                                componentNames.add(parts[p]);
                            }
                            statusBarService.setDefaultComponents(componentNames);
                            boolean wasEnabled = statusBarService.isEnabled();
                            statusBarService.setComponents(componentNames);
                            statusBarService.setEnabled(wasEnabled);
                            break;
                        }
                        default: {
                            ArrayList<String> componentNames = new ArrayList<String>();
                            for (int p = 2; p < parts.length; ++p) {
                                componentNames.add(parts[p]);
                            }
                            statusBarService.setComponents(componentNames);
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    ctx.write("Statusbar: " + ex.getMessage() + "\n");
                    return true;
                }
            } else {
                unrecognized = true;
            }
            if (unrecognized) {
                ctx.write("Statusbar: unrecognized command\n");
                return true;
            }
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"status", "statusbar"};
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ConsoleService consoleService = (ConsoleService)ctx.getProperty("script.runner.jline");
        StatusBarService statusBarService = consoleService.getStatusBarService();
        ctx.write("STATUS BAR: " + (statusBarService.isEnabled() ? "on" : "off") + "\n");
        ctx.write("Used components:\n");
        for (StatusBarComponent component : statusBarService.getUsedComponents()) {
            ctx.write(String.format("\t%1$-22s %2$s\n", component.getName().toUpperCase(), component.getDescription()));
        }
        ctx.write("Unused components:\n");
        for (StatusBarComponent component : statusBarService.getAvailableComponents()) {
            ctx.write(String.format("\t%1$-22s %2$s\n", component.getName().toUpperCase(), component.getDescription()));
        }
        ctx.write("Default components:\n");
        for (StatusBarComponent component : statusBarService.getDefaultComponents()) {
            ctx.write(String.format("\t%1$-22s\n", component.getName().toUpperCase()));
        }
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        ConsoleService consoleService = (ConsoleService)ctx.getProperty("script.runner.jline");
        StatusBarService statusBarService = consoleService.getStatusBarService();
        StringBuilder sb = new StringBuilder();
        if (!statusBarService.getUsedComponents().isEmpty()) {
            sb.append("set statusbar");
            for (StatusBarComponent component : statusBarService.getUsedComponents()) {
                sb.append(' ').append(component.getName());
            }
            sb.append('\n');
        }
        if (!statusBarService.getDefaultComponents().isEmpty()) {
            sb.append("set statusbar default");
            for (StatusBarComponent component : statusBarService.getDefaultComponents()) {
                sb.append(' ').append(component.getName());
            }
            sb.append('\n');
        }
        if (!statusBarService.isEnabled() && !statusBarService.getUsedComponents().isEmpty()) {
            sb.append("set statusbar off\n");
        }
        return sb.toString();
    }
}

