/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import oracle.dbtools.raptor.console.ConsoleService;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.scriptrunner.commands.Messages;

public class SetLineNumbers
extends CommandListener
implements IShowCommand,
IStoreCommand {
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ConsoleService consoleService = (ConsoleService)ctx.getProperty("script.runner.jline");
        if (cmd.getSql().trim().toLowerCase().replaceAll(" ", "").startsWith("setlinenumbers")) {
            String[] parts = cmd.getSQLOrig().split("\\s+");
            if (parts.length >= 3) {
                String value;
                switch (value = parts[2].toLowerCase()) {
                    case "on": 
                    case "true": {
                        consoleService.setLineNumbers(true);
                        break;
                    }
                    case "off": 
                    case "false": {
                        consoleService.setLineNumbers(false);
                        break;
                    }
                    default: {
                        ctx.write("Line numbers: invalid value '" + value + "'. Use ON or OFF.\n");
                        return true;
                    }
                }
            } else {
                ctx.write("Line numbers: missing ON/OFF parameter\n");
                return true;
            }
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"linenumbers"};
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ConsoleService consoleService = (ConsoleService)ctx.getProperty("script.runner.jline");
        boolean enabled = consoleService.getLineNumbers();
        ctx.write(Messages.getString(enabled ? "LINENUMBERS_CURRENT_ON" : "LINENUMBERS_CURRENT_OFF") + "\n");
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        ConsoleService consoleService = (ConsoleService)ctx.getProperty("script.runner.jline");
        boolean enabled = consoleService.getLineNumbers();
        return enabled ? "set linenumbers on\n" : "set linenumbers off\n";
    }
}

