/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import oracle.dbtools.raptor.console.ConsoleService;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.scriptrunner.commands.Messages;

public class SetAutosuggestion
extends CommandListener
implements IShowCommand,
IStoreCommand {
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ConsoleService consoleService = (ConsoleService)ctx.getProperty("script.runner.jline");
        if (cmd.getSql().trim().toLowerCase().replaceAll(" ", "").startsWith("setautosuggestions")) {
            String[] parts = cmd.getSQLOrig().split("\\s+");
            if (parts.length >= 3) {
                String value;
                switch (value = parts[2].toLowerCase()) {
                    case "on": 
                    case "true": {
                        consoleService.setAutosuggestion(true);
                        ctx.writeln("Autosuggestion enabled");
                        break;
                    }
                    case "off": 
                    case "false": {
                        consoleService.setAutosuggestion(false);
                        ctx.writeln("Autosuggestion disabled");
                        break;
                    }
                    default: {
                        ctx.write("Autosuggestion: invalid value '" + value + "'. Use ON or OFF.\n");
                        return true;
                    }
                }
            } else {
                ctx.write("Autosuggestion: missing ON/OFF parameter\n");
                return true;
            }
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        ConsoleService consoleService = (ConsoleService)ctx.getProperty("script.runner.jline");
        boolean enabled = consoleService.getAutoSuggestions();
        return enabled ? "set Autosuggestions on\n" : "set Autosuggestions off\n";
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"autosuggestions"};
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ConsoleService consoleService = (ConsoleService)ctx.getProperty("script.runner.jline");
        boolean enabled = consoleService.getAutoSuggestions();
        ctx.write(Messages.getString(enabled ? "AUTOSUGGESTION_CURRENT_ON" : "AUTOSUGGESTION_CURRENT_OFF") + "\n");
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }
}

