/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.console.impl;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import oracle.dbtools.plusplus.IBuffer;
import oracle.dbtools.raptor.console.ConsoleService;
import oracle.dbtools.raptor.console.HistoryItem;
import oracle.dbtools.raptor.console.StatusBarComponent;
import oracle.dbtools.raptor.console.impl.KeyMapSupplier;
import oracle.dbtools.raptor.console.impl.NavigableLess;
import oracle.dbtools.raptor.console.impl.ParseUtil;
import oracle.dbtools.raptor.console.impl.SqlclAggregateCompleter;
import oracle.dbtools.raptor.console.impl.SqlclHighlighter;
import oracle.dbtools.raptor.console.impl.SqlclHistory;
import oracle.dbtools.raptor.console.impl.SqlclParser;
import oracle.dbtools.raptor.console.impl.SqlclStatusBar;
import oracle.dbtools.raptor.console.impl.SqlclWidgets;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import org.jline.builtins.Source;
import org.jline.keymap.KeyMap;
import org.jline.reader.Buffer;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.CompletionMatcher;
import org.jline.reader.EndOfFileException;
import org.jline.reader.Highlighter;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.CompletionMatcherImpl;
import org.jline.reader.impl.LineReaderImpl;
import org.jline.reader.impl.ReaderUtils;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.terminal.impl.DumbTerminal;
import org.jline.utils.InfoCmp;
import org.jline.utils.InputStreamReader;
import org.jline.utils.Log;
import org.jline.widget.AutopairWidgets;
import org.jline.widget.AutosuggestionWidgets;

public class SqlclConsole
implements ConsoleService {
    public static final String CLEAR_SCREEN_POSITION = "clear-screen-position";
    private SqlclHistory history;
    private SqlclHighlighter highlighter;
    private Terminal terminal;
    private LineReaderImpl reader;
    private SqlclWidgets widgets;
    private SqlclStatusBar statusBar;
    private final boolean interactive;
    private final boolean system;
    private Runnable interruptHandler;
    private IBuffer sqlclBuffer;
    private ScriptRunnerContext scriptRunnerContext;
    private static final String PATTERN_WITH_NUMBERS = "%5P %N%* ";
    private static final String PATTERN_WITHOUT_NUMBERS = "%5P ";
    private boolean lineNumbersEnabled = true;
    private boolean autosuggestionEnabled = false;
    private AutopairWidgets autopairWidgets;
    private AutosuggestionWidgets autosuggestionWidgets;

    /*
     * Unable to fully structure code
     */
    private SqlclConsole(String name, InputStream input, OutputStream output, ScriptRunnerContext scriptRunnerContext, IBuffer sqlclBuffer) {
        super();
        try {
            this.scriptRunnerContext = scriptRunnerContext;
            this.sqlclBuffer = sqlclBuffer;
            this.system = input == null && output == null;
            this.interactive = Boolean.parseBoolean(System.getProperty("force.interactive")) != false || System.in.available() == 0;
            parser = new SqlclParser();
            this.highlighter = new SqlclHighlighter();
            this.history = new SqlclHistory();
            if (this.system) {
                terminalChars = this.getTerminalChars();
                createPaused = this.interactive == false && terminalChars.canPauseResume != false;
                isStdoutRedirected = System.console() == null;
                this.terminal = isStdoutRedirected != false ? TerminalBuilder.builder().encoding(StandardCharsets.UTF_8).type(terminalChars.type).system(true).dumb(false).exec(true).jni(true).paused(createPaused).systemOutput(TerminalBuilder.SystemOutput.ForcedSysOut).build() : TerminalBuilder.builder().encoding(StandardCharsets.UTF_8).type(terminalChars.type).system(true).dumb(false).exec(true).paused(createPaused).nativeSignals(false).build();
                try {
                    terminalOut = new PrintStream((OutputStream)new BufferedOutputStream(this.terminal.output()), true, StandardCharsets.UTF_8.name());
                    System.setOut(terminalOut);
                    if (scriptRunnerContext == null) ** GOTO lbl41
                    terminalOutputStream = this.terminal.output();
                    bufferedTerminalOutput = new BufferedOutputStream(terminalOutputStream);
                    scriptRunnerContext.setOutputStreamWrapper(bufferedTerminalOutput);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to configure terminal output: " + e.getMessage(), e);
                }
            } else {
                try {
                    this.terminal = new DumbTerminal(name, "dumb", input, output, StandardCharsets.UTF_8);
                    this.terminal.setSize(new Size(200, 24));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                try {
                    if (scriptRunnerContext != null) {
                        terminalOutputStream = this.terminal.output();
                        bufferedTerminalOutput = new BufferedOutputStream(terminalOutputStream);
                        scriptRunnerContext.setOutputStreamWrapper(bufferedTerminalOutput);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to configure test-terminal output: " + e.getMessage(), e);
                }
            }
lbl41:
            // 3 sources

            this.terminal.handle(Terminal.Signal.INT, (Terminal.SignalHandler)LambdaMetafactory.metafactory(null, null, null, (Lorg/jline/terminal/Terminal$Signal;)V, lambda$new$0(org.jline.terminal.Terminal$Signal ), (Lorg/jline/terminal/Terminal$Signal;)V)((SqlclConsole)this));
            this.reader = (LineReaderImpl)LineReaderBuilder.builder().terminal(this.terminal).appName(name).parser((Parser)parser).highlighter((Highlighter)this.highlighter).history((History)this.history).completionMatcher((CompletionMatcher)new SqlclCompletionMatcher()).option(LineReader.Option.CASE_INSENSITIVE, true).option(LineReader.Option.HISTORY_INCREMENTAL, true).option(LineReader.Option.HISTORY_IGNORE_SPACE, false).option(LineReader.Option.HISTORY_IGNORE_DUPS, true).option(LineReader.Option.DISABLE_EVENT_EXPANSION, true).option(LineReader.Option.DISABLE_HIGHLIGHTER, false).variable("secondary-prompt-pattern", (Object)"%5P %N%* ").variable("line-offset", (Object)1).variable("features-max-buffer-size", (Object)"5000").variable("history-file", (Object)System.getProperty("console.history.file")).variable("list-max", (Object)0).variable("ConsoleTracer", (Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$new$1(java.lang.String ), (Ljava/lang/String;)V)((SqlclConsole)this)).build();
            this.doSetDefaultEditMode(ConsoleService.Editor.VI);
            this.widgets = new SqlclWidgets(this, this.reader);
            parser.jLineBuffer(this.reader.getBuffer()).widgets(this.widgets).scriptRunnerContext(scriptRunnerContext);
            this.history.highlighter(this.highlighter).reader(this.reader);
            this.highlighter.reader((LineReader)this.reader);
            if (SqlclConsole.isInteractive()) {
                this.highlighter.setEnabled(true);
            }
            completer = new SqlclAggregateCompleter(scriptRunnerContext);
            this.reader.setCompleter((Completer)completer);
            this.statusBar = new SqlclStatusBar(this, this.reader, scriptRunnerContext);
            if (SqlclConsole.isInteractive()) {
                this.autopairWidgets = new AutopairWidgets((LineReader)this.reader, true);
                this.autopairWidgets.enable();
                this.autosuggestionWidgets = new AutosuggestionWidgets((LineReader)this.reader);
                this.reader.setAutosuggestion(LineReader.SuggestionType.NONE);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public void setLineNumbers(boolean enabled) {
        this.lineNumbersEnabled = enabled;
        String pattern = enabled ? PATTERN_WITH_NUMBERS : PATTERN_WITHOUT_NUMBERS;
        this.reader.setVariable("secondary-prompt-pattern", (Object)pattern);
    }

    @Override
    public boolean getLineNumbers() {
        return this.lineNumbersEnabled;
    }

    private static boolean isInteractive() {
        return !Boolean.parseBoolean(System.getProperty("dev.flag")) && !Boolean.parseBoolean(System.getProperty("dev")) && !Boolean.parseBoolean(System.getProperty("force.interactive"));
    }

    @Override
    public void close() throws IOException {
        this.terminal.close();
        this.terminal = null;
    }

    @Override
    public ConsoleService.Command readCommand() {
        return this.readCommand(() -> this.reader.readLine());
    }

    @Override
    public ConsoleService.Command readCommand(Character mask) {
        return this.readCommand(() -> this.reader.readLine(mask));
    }

    @Override
    public ConsoleService.Command readCommand(String prompt) {
        return this.readCommand(() -> this.reader.readLine(prompt));
    }

    @Override
    public ConsoleService.Command readCommand(String prompt, Character mask) {
        return this.readCommand(() -> this.reader.readLine(prompt, mask));
    }

    @Override
    public ConsoleService.Command readCommand(String prompt, String buffer) {
        return this.readCommand(() -> this.reader.readLine(prompt, null, buffer));
    }

    @Override
    public ConsoleService.Command readCommand(String prompt, Character mask, String buffer) {
        return this.readCommand(() -> this.reader.readLine(prompt, mask, buffer));
    }

    @Override
    public String readInput() {
        return this.readInput(() -> this.reader.readLine());
    }

    @Override
    public String readInput(Character mask) {
        return this.readInput(() -> this.reader.readLine(mask));
    }

    @Override
    public String readInput(String prompt) {
        return this.readInput(() -> this.reader.readLine(prompt));
    }

    @Override
    public String readInput(String prompt, Character mask) {
        return this.readInput(() -> this.reader.readLine(prompt, mask));
    }

    @Override
    public String readInput(String prompt, String buffer) {
        return this.readInput(() -> this.reader.readLine(prompt, null, buffer));
    }

    @Override
    public String readInput(String prompt, Character mask, String buffer) {
        return this.readInput(() -> this.reader.readLine(prompt, mask, buffer));
    }

    @Override
    public boolean interactive() {
        return this.interactive;
    }

    @Override
    public String readPiped() {
        if (this.interactive()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        try {
            int ch = System.in.read();
            while (ch >= 0) {
                sb.append((char)ch);
                ch = System.in.read();
            }
        }
        catch (IOException ex) {
            Log.warn((Object[])new Object[]{"error reading piped input", ex});
        }
        return sb.toString();
    }

    @Override
    public SqlclHistory getHistoryService() {
        return this.history;
    }

    @Override
    public SqlclHighlighter getHighlighterService() {
        return this.highlighter;
    }

    @Override
    public SqlclStatusBar getStatusBarService() {
        return this.statusBar;
    }

    @Override
    public void setInterruptHandler(Runnable handler) {
        this.interruptHandler = handler;
    }

    @Override
    public void registerStatusBarComponent(StatusBarComponent component) {
        this.statusBar.register(component);
    }

    @Override
    public boolean clearScreen() {
        return this.clearScreen(this.getDefaultClearScreenPosition());
    }

    @Override
    public boolean clearScreen(ConsoleService.ClearScreenPosition position) {
        if (this.terminal.puts(InfoCmp.Capability.clear_screen, new Object[0])) {
            if ("windows-conemu".equals(this.terminal.getType()) && !Boolean.getBoolean("org.jline.terminal.conemu.disable-activate")) {
                this.terminal.writer().write("\u001b[9999E");
            }
            if (position != null) {
                switch (position) {
                    case TOP: {
                        break;
                    }
                }
            }
        } else {
            this.terminal.puts(InfoCmp.Capability.carriage_return, new Object[0]);
            this.terminal.writer().write("\n");
        }
        this.reader.redrawLine();
        this.statusBar.refresh(true);
        return true;
    }

    @Override
    public void pause(boolean pause) {
        if (pause) {
            this.terminal.pause();
        } else {
            this.terminal.resume();
        }
    }

    @Override
    public boolean canPause() {
        return this.terminal.canPauseResume();
    }

    @Override
    public int getWidth() {
        return this.terminal.getWidth();
    }

    @Override
    public int getHeight() {
        return this.terminal.getHeight();
    }

    @Override
    public ConsoleService.Editor getDefaultEditor() {
        String mainKeyMap = "emacs";
        KeyMap keyMap = (KeyMap)this.reader.getKeyMaps().get("main");
        if (keyMap != null) {
            for (String name : this.reader.getKeyMaps().keySet()) {
                if (name.equals("main") || keyMap != this.reader.getKeyMaps().get(name)) continue;
                mainKeyMap = name;
            }
        }
        return mainKeyMap.equals("emacs") ? ConsoleService.Editor.EMACS : ConsoleService.Editor.VI;
    }

    @Override
    public void setDefaultEditor(ConsoleService.Editor newValue) {
        this.doSetDefaultEditMode(newValue);
    }

    @Override
    public ConsoleService.ClearScreenPosition getDefaultClearScreenPosition() {
        String positionRep = ReaderUtils.getString((LineReader)this.reader, (String)CLEAR_SCREEN_POSITION, null);
        if (positionRep == null || positionRep.equals("")) {
            return null;
        }
        try {
            return ConsoleService.ClearScreenPosition.valueOf(ConsoleService.ClearScreenPosition.class, positionRep);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    @Override
    public void setDefaultClearScreenPosition(ConsoleService.ClearScreenPosition newValue) {
        this.reader.setVariable(CLEAR_SCREEN_POSITION, (Object)(newValue == null ? "" : newValue.toString()));
    }

    @Override
    public SortedMap<String, String> getKeyMapHelp(ConsoleService.KeyMapType keyMapType) {
        String jLineMapName;
        switch (keyMapType) {
            case VI_COMMAND: {
                jLineMapName = "vicmd";
                break;
            }
            case VI_INSERT: {
                jLineMapName = "viins";
                break;
            }
            case VISUAL: {
                jLineMapName = "visual";
                break;
            }
            default: {
                jLineMapName = "emacs";
            }
        }
        KeyMapSupplier keyMapSupplier = this.createKeyMapSupplier();
        TreeMap<String, String> keyMapHelp = new TreeMap<String, String>();
        keyMapSupplier.supply(jLineMapName, entry -> keyMapHelp.put(entry.getTranslatedKeySeq(), entry.getDoc()));
        return keyMapHelp;
    }

    @Override
    public ConsoleService.BellStyle getBellStyle() {
        ConsoleService.BellStyle bellStyle = null;
        switch (ReaderUtils.getString((LineReader)this.reader, (String)"bell-style", (String)"off").toLowerCase()) {
            case "none": 
            case "off": {
                bellStyle = ConsoleService.BellStyle.OFF;
                break;
            }
            case "audible": {
                bellStyle = ConsoleService.BellStyle.AUDIBLE;
                break;
            }
            case "visible": {
                bellStyle = ConsoleService.BellStyle.VISIBLE;
                break;
            }
            case "on": {
                bellStyle = ReaderUtils.getBoolean((LineReader)this.reader, (String)"prefer-visible-bell", (boolean)false) ? ConsoleService.BellStyle.VISIBLE : ConsoleService.BellStyle.AUDIBLE;
            }
        }
        return bellStyle;
    }

    @Override
    public void setBellStyle(ConsoleService.BellStyle newValue) {
        String bellStyleRep;
        switch (newValue) {
            case AUDIBLE: {
                bellStyleRep = "audible";
                break;
            }
            case VISIBLE: {
                bellStyleRep = "visible";
                break;
            }
            default: {
                bellStyleRep = "none";
            }
        }
        this.reader.setVariable("bell-style", (Object)bellStyleRep);
    }

    @Override
    public boolean isEventExpansionDisabled() {
        return this.reader.isSet(LineReader.Option.DISABLE_EVENT_EXPANSION);
    }

    @Override
    public void setEventExpansionDisabled(boolean newValue) {
        if (newValue) {
            this.reader.setOpt(LineReader.Option.DISABLE_EVENT_EXPANSION);
        } else {
            this.reader.unsetOpt(LineReader.Option.DISABLE_EVENT_EXPANSION);
        }
    }

    public KeyMapSupplier createKeyMapSupplier() {
        return new KeyMapSupplier((LineReader)this.reader);
    }

    @Override
    public void writePaginated(String content, String title) {
        this.writePaginated(content, title, 0);
    }

    @Override
    public void writePaginated(String content, String title, int startLine) {
        if (content == null) {
            return;
        }
        this.scriptRunnerContext.write(content);
        if (!this.shouldUsePager(content, this.terminal)) {
            return;
        }
        NavigableLess less = new NavigableLess(this.terminal, Paths.get(".", new String[0]));
        if (startLine > 0) {
            less.setStartLine(startLine);
        }
        Source.InputStreamSource stringSource = new Source.InputStreamSource((InputStream)new ByteArrayInputStream(content.getBytes()), false, title);
        ArrayList<Source.InputStreamSource> sources = new ArrayList<Source.InputStreamSource>(1);
        sources.add(stringSource);
        try {
            less.run(sources);
        }
        catch (IOException | InterruptedException e) {
            Log.trace((Object[])new Object[]{e});
        }
    }

    private boolean shouldUsePager(String content, Terminal terminal) {
        long terminalHeight;
        if (terminal == null || !this.interactive()) {
            return false;
        }
        long lines = content.lines().count();
        return lines > (terminalHeight = (long)terminal.getHeight()) - 3L;
    }

    public boolean system() {
        return this.system;
    }

    private void doSetDefaultEditMode(ConsoleService.Editor newValue) {
        Map keyMap = this.reader.getKeyMaps();
        keyMap.put("main", newValue == ConsoleService.Editor.EMACS ? (KeyMap)this.reader.getKeyMaps().get("emacs") : (KeyMap)this.reader.getKeyMaps().get("viins"));
    }

    private TerminalChars getTerminalChars() throws IOException {
        boolean canPauseResume;
        String terminalType;
        if (System.console() == null) {
            return new TerminalChars("dumb", false);
        }
        try (Terminal testTerminal = TerminalBuilder.builder().system(true).dumb(false).exec(true).build();){
            terminalType = testTerminal.getType();
            canPauseResume = testTerminal.canPauseResume();
        }
        if ("windows-vtp".equals(terminalType)) {
            terminalType = "sqlcl-windows-vtp";
            InfoCmp.setDefaultInfoCmp((String)terminalType, (String)this.loadInfoCmp(terminalType));
        }
        return new TerminalChars(terminalType, canPauseResume);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String loadInfoCmp(String name) {
        try (InputStream is = this.getClass().getResourceAsStream(name + ".caps");){
            String string;
            try (BufferedReader br = new BufferedReader((Reader)new InputStreamReader(is, StandardCharsets.UTF_8));){
                string = br.lines().collect(Collectors.joining("\n", "", "\n"));
            }
            return string;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private ConsoleService.Command readCommand(Supplier<String> lineSupplier) {
        ConsoleService.Command command = null;
        while (command == null) {
            String line;
            while (true) {
                try {
                    Runtime.getRuntime().gc();
                    line = lineSupplier.get();
                }
                catch (UserInterruptException ex) {
                    this.terminal.flush();
                    continue;
                }
                catch (EndOfFileException ex) {
                    return null;
                }
                catch (Exception ex) {
                    Log.error((Object[])new Object[]{ex});
                    continue;
                }
                break;
            }
            List words = this.reader.getParsedLine().words();
            String blockTerminator = "\n" + this.getBlockTerminator();
            if (words.size() > 0 && !((String)words.get(words.size() - 1)).equals(blockTerminator)) {
                command = this.createCommand(line);
                continue;
            }
            if (this.scriptRunnerContext == null || line == null || line.trim().isEmpty()) continue;
            this.scriptRunnerContext.getSQLPlusBuffer().getBufferSafe().resetBuffer(this.removeBlockTerminator(line));
        }
        if (this.sqlclBuffer != null) {
            this.sqlclBuffer.clear();
            for (String multiLineItem : command.multiLine()) {
                this.sqlclBuffer.add(multiLineItem);
            }
        }
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readInput(Supplier<String> lineSupplier) {
        String line;
        block8: {
            boolean historyDisabled = this.history.isDisabled();
            boolean syntaxHighlightingEnabled = this.highlighter.isEnabled();
            try {
                this.history.setDisabled(true);
                this.highlighter.setEnabled(false);
                this.reader.setOpt(LineReader.Option.DISABLE_HIGHLIGHTER);
                try {
                    line = lineSupplier.get();
                }
                catch (EndOfFileException ex) {
                    Buffer jlineBuffer = this.reader.getBuffer();
                    if (jlineBuffer.length() > 0) {
                        line = jlineBuffer.toString();
                        jlineBuffer.clear();
                        break block8;
                    }
                    throw ex;
                }
                catch (UserInterruptException ex) {
                    line = "";
                }
                catch (Exception ex) {
                    Log.error((Object[])new Object[]{ex});
                    line = "";
                }
            }
            finally {
                this.history.setDisabled(historyDisabled);
                this.highlighter.setEnabled(syntaxHighlightingEnabled);
                this.reader.unsetOpt(LineReader.Option.DISABLE_HIGHLIGHTER);
            }
        }
        return line;
    }

    private String getCompletedLine(String line) {
        Object completedLine = line;
        ISQLCommand cmd = ParseUtil.parseLast(line);
        if (cmd != null && (cmd.getStatementTerminator() == null || cmd.getStatementTerminator().isEmpty())) {
            if (cmd.getStmtType() == SQLCommand.StmtType.G_C_SQL) {
                completedLine = (String)completedLine + ";";
            } else if (cmd.getStmtType() == SQLCommand.StmtType.G_C_PLSQL) {
                completedLine = (String)completedLine + "\n/";
            }
        }
        return completedLine;
    }

    private List<String> getMultiLine(String line) {
        String[] multiLine = line.split("\\r?\\n");
        return Arrays.asList(multiLine);
    }

    private char getBlockTerminator() {
        return this.scriptRunnerContext != null ? this.scriptRunnerContext.getCharProperty("BLOCKTERMINATOR", '.') : (char)'.';
    }

    private String removeBlockTerminator(String line) {
        char blockTerminator = this.getBlockTerminator();
        int index = line.length() - 1;
        block3: while (index >= 0) {
            char ch = line.charAt(index);
            switch (ch) {
                case '\t': 
                case ' ': {
                    --index;
                    continue block3;
                }
            }
            if (ch == blockTerminator) {
                line = line.substring(0, index);
            }
            index = -1;
        }
        return line;
    }

    private ConsoleService.Command createCommand(final String line) {
        final ParsedLine parsedLine = this.reader.getParsedLine();
        HistoryItem pendingItem = this.history.getPendingItem();
        final UUID historyUuid = pendingItem != null ? pendingItem.uuid() : null;
        return new ConsoleService.Command(){

            @Override
            public String line() {
                return line;
            }

            @Override
            public String completedLine() {
                return SqlclConsole.this.getCompletedLine(line);
            }

            @Override
            public List<String> multiLine() {
                return SqlclConsole.this.getMultiLine(SqlclConsole.this.getCompletedLine(line));
            }

            @Override
            public List<String> words() {
                return parsedLine.words();
            }

            @Override
            public void onComplete(String modifiedLine, long durationMillis, boolean successful) {
                if (historyUuid != null) {
                    SqlclConsole.this.history.addAudit(historyUuid, modifiedLine, durationMillis, successful);
                }
            }
        };
    }

    private void trace(String event) {
        Log.info((Object[])new Object[]{event + " -> [" + (this.widgets.isEditing() ? "edit" : "") + "]"});
    }

    @Override
    public boolean getAutoSuggestions() {
        return this.autosuggestionEnabled;
    }

    @Override
    public boolean setAutosuggestion(boolean enabled) {
        if (!SqlclConsole.isInteractive()) {
            return false;
        }
        if (enabled) {
            if (this.autosuggestionWidgets != null) {
                this.autosuggestionWidgets.enable();
            }
        } else if (this.autosuggestionWidgets != null) {
            this.autosuggestionWidgets.disable();
        }
        this.autosuggestionEnabled = enabled;
        return this.autosuggestionEnabled;
    }

    private /* synthetic */ void lambda$new$1(String event) {
        this.trace(event);
    }

    private /* synthetic */ void lambda$new$0(Terminal.Signal signal) {
        if (this.interruptHandler != null) {
            this.interruptHandler.run();
        }
    }

    private class TerminalChars {
        String type;
        boolean canPauseResume;

        TerminalChars(String type, boolean canPauseResume) {
            this.type = type;
            this.canPauseResume = canPauseResume;
        }
    }

    private static class SqlclCompletionMatcher
    extends CompletionMatcherImpl {
        private List<Candidate> candidates;

        private SqlclCompletionMatcher() {
        }

        public List<Candidate> matches(List<Candidate> candidates) {
            this.candidates = super.matches(candidates);
            return this.candidates;
        }

        public String getCommonPrefix() {
            String commonPrefix = null;
            for (Candidate candidate : this.candidates) {
                String displayValue = candidate.displ();
                commonPrefix = commonPrefix == null ? displayValue : this.getCommonStart(commonPrefix, displayValue);
            }
            return commonPrefix;
        }

        private String getCommonStart(String str1, String str2) {
            int len;
            int[] s1 = str1.codePoints().toArray();
            int[] s2 = str2.codePoints().toArray();
            for (len = 0; len < Math.min(s1.length, s2.length); ++len) {
                int ch1 = s1[len];
                int ch2 = s2[len];
                if (ch1 != ch2 && (ch1 = Character.toUpperCase(ch1)) != (ch2 = Character.toUpperCase(ch2))) {
                    ch1 = Character.toLowerCase(ch1);
                    ch2 = Character.toLowerCase(ch2);
                }
                if (ch1 != ch2) break;
            }
            return new String(s1, 0, len);
        }
    }

    public static class SqlclConsoleBuilder
    implements ConsoleService.Builder {
        private String name = "Default";
        private InputStream input;
        private OutputStream output;
        private ScriptRunnerContext scriptRunnerContext;
        private IBuffer sqlclBuffer;

        @Override
        public SqlclConsoleBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public SqlclConsoleBuilder streams(InputStream input, OutputStream output) {
            this.input = input;
            this.output = output;
            return this;
        }

        @Override
        public ConsoleService.Builder scriptRunnerContext(ScriptRunnerContext scriptRunnerContext) {
            this.scriptRunnerContext = scriptRunnerContext;
            return this;
        }

        @Override
        public ConsoleService.Builder sqlclBuffer(IBuffer sqlclBuffer) {
            this.sqlclBuffer = sqlclBuffer;
            return this;
        }

        @Override
        public SqlclConsole build() {
            return new SqlclConsole(this.name, this.input, this.output, this.scriptRunnerContext, this.sqlclBuffer);
        }
    }
}

