/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.save;

import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.dbtools.plusplus.connections.db.save.DatabaseProviderFactory;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.PropertyValues;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.PasswordProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.RoleProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.URLProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.UserProperty;

public abstract class StandardConnectionDefinitionFactory
implements DatabaseProviderFactory {
    @Override
    public final DatabaseProvider createDatabaseProvider(String name, boolean savePwd, PropertyValues props) {
        String role;
        String spec;
        DatabaseProvider.Builder builder = DatabaseProvider.builder(name);
        String user = props.getValueOf(UserProperty.USER);
        if (user != null) {
            TextSecret pwd;
            builder = builder.property("user", user);
            if (savePwd && (pwd = props.getValueOf(PasswordProperty.PASSWORD)) != null) {
                builder = builder.credential("password", pwd);
            }
        }
        if ((spec = props.getValueOf(URLProperty.URL)) != null) {
            builder = builder.property("customUrl", spec);
        }
        if ((role = props.getValueOf(RoleProperty.ROLE)) != null) {
            builder = builder.property("role", role);
        }
        builder = builder.property("subtype", "oraJDBC");
        builder = this.configureDatabaseProvider(props, builder);
        return builder.build();
    }

    protected abstract DatabaseProvider.Builder configureDatabaseProvider(PropertyValues var1, DatabaseProvider.Builder var2);
}

