/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.imp;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.core.connections.api.Connections;
import oracle.dbtools.core.util.MessageLogger;
import oracle.dbtools.plusplus.connections.db.imp.BaseOracleConverter;
import oracle.dbtools.plusplus.connections.db.imp.ConnectionsConverter;
import oracle.dbtools.plusplus.connections.db.imp.ConnectionsConverterFactory;

public class TNSConverterFactory
implements ConnectionsConverterFactory {
    @Override
    public boolean canConvert(DatabaseProvider provider) {
        return "oraJDBC".equals(provider.getProperty("subtype")) && "TNS".equals(provider.getProperty("OracleConnectionType"));
    }

    @Override
    public ConnectionsConverter createConverter(DatabaseProvider provider, MessageLogger logging, Connections.Identifier identifier) {
        return new TNSConverter(provider, logging, identifier);
    }

    private static class TNSConverter
    extends BaseOracleConverter {
        TNSConverter(DatabaseProvider provider, MessageLogger logging) {
            super(provider, logging);
        }

        TNSConverter(DatabaseProvider provider, MessageLogger logging, Connections.Identifier identifier) {
            super(provider, logging, identifier);
        }

        @Override
        protected String processConnectionSpec() {
            String connectString;
            String spec = this.definition.getProperty("customUrl");
            Matcher matcher = UrlMatcher.INSTANCE.match(spec);
            if (matcher.find()) {
                int idx = matcher.end();
                connectString = spec.substring(idx);
            } else {
                connectString = spec;
            }
            this.addDBToolsProperty("type", "ORACLE_DATABASE");
            this.addDBToolsProperty("connectionString", connectString);
            return connectString;
        }
    }

    private static class UrlMatcher {
        private static final String JDBC_URL_PATTERN = "jdbc:oracle:\\w+:@";
        private static final UrlMatcher INSTANCE = new UrlMatcher();
        private final Pattern pattern = Pattern.compile("jdbc:oracle:\\w+:@");

        private UrlMatcher() {
        }

        Matcher match(String url) {
            return this.pattern.matcher(url);
        }
    }
}

