/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.imp;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import oracle.dbtools.core.oci.connections.OCIStoredConnectionSupport;
import oracle.dbtools.core.oci.search.ResourceQuery;
import oracle.dbtools.core.oci.search.SearchResult;
import oracle.dbtools.core.util.DbtoolsException;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreOptions;
import oracle.dbtools.plusplus.connections.db.imp.ImportedConnectionResult;
import oracle.dbtools.plusplus.connections.db.imp.Importer;
import oracle.dbtools.plusplus.util.CommandContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class OCIImporter
extends Importer<SearchResult> {
    private final String displayName;
    private final OCIStoredConnectionSupport connectionSupport;

    public static Builder builder() {
        return new Builder();
    }

    private OCIImporter(Builder builder) {
        super(builder.duplicatesPolicy, builder.existingConnection, builder.commandContext);
        this.displayName = builder.displayName;
        this.connectionSupport = builder.connectionSupport;
    }

    @Override
    protected Map<String, SearchResult> loadConnections() {
        ScriptRunnerContext ctx = this.cmdCtx.getScriptRunnerContext();
        ResourceQuery.ResourceQueryConstraint constraint = ResourceQuery.matchConstraint((String)"displayName", (String)this.displayName);
        Map<String, SearchResult> connections = this.connectionSupport.listConnections(constraint).stream().collect(Collectors.toMap(searchResult -> searchResult.getDisplayName(), Function.identity()));
        return connections;
    }

    @Override
    protected String getConnectionName(SearchResult connectionDefinition) {
        return connectionDefinition.getDisplayName();
    }

    @Override
    protected ImportedConnectionResult importConnection(SearchResult searchResult, String name) {
        try {
            this.connectionSupport.storeConnection(searchResult, name);
        }
        catch (DbtoolsException ex) {
            return ImportedConnectionResult.failure(name, ex.getLocalizedMessage());
        }
        return ImportedConnectionResult.success(name);
    }

    public static class Builder {
        private String displayName;
        private OCIStoredConnectionSupport connectionSupport;
        private ConnectionStoreOptions.DuplicatesPolicy duplicatesPolicy;
        private Collection<String> existingConnection;
        private CommandContext commandContext;

        private Builder() {
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder connectionSupport(OCIStoredConnectionSupport connectionSupport) {
            this.connectionSupport = connectionSupport;
            return this;
        }

        public Builder duplicatesPolicy(ConnectionStoreOptions.DuplicatesPolicy duplicatesPolicy) {
            this.duplicatesPolicy = duplicatesPolicy;
            return this;
        }

        public Builder existingConnections(Collection<String> existingConnection) {
            this.existingConnection = existingConnection;
            return this;
        }

        public Builder commandContext(CommandContext ctx) {
            this.commandContext = ctx;
            return this;
        }

        public OCIImporter build() {
            return new OCIImporter(this);
        }
    }
}

