/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.imp;

import java.io.IOException;
import java.util.Properties;
import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.core.connections.api.Connections;
import oracle.dbtools.core.connections.storage.ConnectionStorage;
import oracle.dbtools.core.util.MessageLogger;
import oracle.dbtools.plusplus.connections.db.imp.ConnectionsConverter;
import oracle.dbtools.plusplus.connections.db.imp.ImportedConnectionResult;

public abstract class BaseOracleConverter
extends ConnectionsConverter {
    protected BaseOracleConverter(DatabaseProvider provider, MessageLogger logger) {
        super(provider, logger);
    }

    protected BaseOracleConverter(DatabaseProvider provider, MessageLogger logger, Connections.Identifier identifier) {
        super(provider, logger, identifier);
    }

    @Override
    public final ImportedConnectionResult convert() throws IOException {
        this.processDisplayName();
        String spec = this.processConnectionSpec();
        this.processCredentials(spec);
        this.processAdvancedProperties();
        this.processCustomProperties();
        this.output(ConnectionStorage.instance());
        return ImportedConnectionResult.success(this.definition.getName());
    }

    protected void processCustomProperties() {
    }

    protected abstract String processConnectionSpec() throws IOException;

    protected String processBasicConfiguration() {
        String hostname = this.definition.getProperty("hostname");
        String port = this.definition.getProperty("port");
        String sid = this.definition.getProperty("sid");
        String servicename = this.definition.getProperty("serviceName");
        this.addDBToolsProperty("host", hostname);
        this.addDBToolsProperty("port", port);
        if (servicename != null) {
            this.addDBToolsProperty("serviceName", servicename);
        } else {
            this.addDBToolsProperty("sid", sid);
        }
        return hostname != null ? (servicename != null ? this.getConnectionSpecWithServiceName(hostname, port, servicename) : this.getConnectionSpecWithSID(hostname, port, sid)) : null;
    }

    protected final String processCustomURL() {
        String spec = this.definition.getProperty("customUrl");
        this.addDBToolsProperty("connectionString", spec);
        return spec;
    }

    protected void processAdvancedProperties() {
        Properties allProps = this.definition.getProperties();
        for (Object o : allProps.keySet()) {
            String key = o.toString();
            if (!key.startsWith("sqldev.advanced.")) continue;
            String oracleKey = key.substring("sqldev.advanced.".length());
            String value = this.definition.getProperty(key);
            this.addAdvancedProperty(oracleKey, value);
        }
    }
}

