/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.stripe;

import java.util.UUID;
import oracle.cloudstorage.io.Bytes;

public class StripeSegmentConfig {
    public static final int DEFAULT_WIDTH = Bytes.kilo.bytes(100);
    public static final int DEFAULT_COUNT = 10;
    public static final int DEFAULT_BUFFER_SIZE = Bytes.mega.bytes(1);
    private int width = DEFAULT_WIDTH;
    private int count = 10;
    private int bufferSize = DEFAULT_BUFFER_SIZE;

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int widthInBytes) {
        this.width = widthInBytes;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int countPerStripe) {
        this.count = countPerStripe;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bytesPerSegment) {
        this.bufferSize = bytesPerSegment;
    }

    public static String calculateStripedObjectUuid() {
        String uuid = UUID.randomUUID().toString();
        return uuid;
    }

    public static String calculateSegmentSuffix(String stripedObjectUuid, int segment) {
        return '/' + stripedObjectUuid + '/' + segment;
    }
}

