/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.jaxrs;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import oracle.cloudstorage.api.ISessionBuilder;
import oracle.cloudstorage.api.jaxrs.IClientProvider;
import oracle.cloudstorage.api.jaxrs.IJaxrsImplementation;
import oracle.cloudstorage.api.jaxrs.JaxrsSender;
import oracle.cloudstorage.api.jaxrs.JerseyImplementation;
import oracle.cloudstorage.api.session.SessionBuilder;

public class JaxrsSessionBuilder
extends SessionBuilder {
    private final Session session;

    public JaxrsSessionBuilder() {
        this(new Session());
    }

    private JaxrsSessionBuilder(Session session) {
        super(session);
        this.session = session;
        session.setImplementation(new JerseyImplementation());
    }

    public IClient implementation(IJaxrsImplementation implementation) {
        this.session.setImplementation(implementation);
        return new ClientProvider();
    }

    public ISessionBuilder.RetryStrategy client(Client client) {
        return new ClientProvider().client(client);
    }

    public ISessionBuilder.RetryStrategy clientProvider(IClientProvider clientProvider) {
        return new ClientProvider().clientProvider(clientProvider);
    }

    private static class Session
    extends oracle.cloudstorage.api.session.Session
    implements IClientProvider {
        private IClientProvider clientProvider = null;
        private Client client = null;
        private final Object clientLock = new Object();

        private Session() {
        }

        private void setImplementation(IJaxrsImplementation implementation) {
            JaxrsSender sender = new JaxrsSender(this, implementation);
            super.setSender(sender);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Client getClient() {
            if (this.client != null) {
                return this.client;
            }
            Object object = this.clientLock;
            synchronized (object) {
                if (this.client != null) {
                    return this.client;
                }
                this.client = this.clientProvider == null ? ClientBuilder.newClient() : this.clientProvider.getClient();
                return this.client;
            }
        }
    }

    private class ClientProvider
    extends SessionBuilder
    implements IClient {
        protected ClientProvider() {
            super(JaxrsSessionBuilder.this.session);
        }

        @Override
        public ISessionBuilder.Sender client(Client client) {
            JaxrsSessionBuilder.this.session.client = client;
            return this.createSenderBuilder();
        }

        @Override
        public ISessionBuilder.Sender clientProvider(IClientProvider clientProvider) {
            JaxrsSessionBuilder.this.session.clientProvider = clientProvider;
            return this.createSenderBuilder();
        }
    }

    public static interface IClient
    extends ISessionBuilder.Sender {
        public ISessionBuilder.Sender client(Client var1);

        public ISessionBuilder.Sender clientProvider(IClientProvider var1);
    }
}

