/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql.doc;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.arbori.util.Service;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.doc.DocURL;
import oracle.dbtools.parser.plsql.doc.HarvestDoc;

public class Substr
implements Serializable {
    static final long serialVersionUID = 3L;
    public final int from;
    public final int to;
    public final String src;
    public final DocURL doc;
    public final long weight;

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public long getWeight() {
        return this.weight;
    }

    public String getSrc() {
        return this.src;
    }

    public DocURL getDocUrl() {
        return this.doc;
    }

    public Substr(int from, int to, String src, long weight, DocURL doc) {
        this.from = from;
        this.to = to;
        this.src = src;
        this.weight = weight;
        this.doc = doc;
    }

    public DocURL getDoc() {
        return this.doc;
    }

    public boolean le(Substr s) {
        if (this.weight != s.weight) {
            return this.weight > s.weight;
        }
        return this.to - this.from < s.to - s.from;
    }

    public String cutSrc() {
        return this.src.substring(this.from, this.to);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Substr)) {
            return false;
        }
        Substr s = (Substr)obj;
        return this.cutSrc().equals(s.cutSrc());
    }

    public int hashCode() {
        return this.cutSrc().hashCode();
    }

    public String toString() {
        return this.cutSrc();
    }

    static void add(Set<Substr> target, Substr elem) {
        String els = elem.cutSrc();
        List<LexerToken> elemSrc = Lexer.parse(els);
        Substr match = null;
        for (Substr s : target) {
            int maxLength;
            String ss = s.cutSrc();
            List<LexerToken> sSrc = Lexer.parse(ss);
            int pos = -1;
            int elemSize = elemSrc.size();
            int sSize = sSrc.size();
            int n = maxLength = elem.weight == 0L ? 16 : 32;
            if (elemSize == sSize || elemSize == sSize + 1 && elemSrc.get((int)(elemSize - 1)).content.equals(";") || sSize == elemSize + 1 && sSrc.get((int)(sSize - 1)).content.equals(";") || elemSize == sSize + 1 && elemSrc.get((int)(elemSize - 1)).content.equals("/") || sSize == elemSize + 1 && sSrc.get((int)(sSize - 1)).content.equals("/") || elemSize > maxLength && sSize > maxLength) {
                match = s;
                for (LexerToken t : sSrc) {
                    boolean matches;
                    if (++pos >= maxLength || elemSize <= pos) break;
                    Token type = elemSrc.get((int)pos).type;
                    String content = elemSrc.get((int)pos).content;
                    boolean bl = matches = type == t.type;
                    if (matches) {
                        if (type == Token.IDENTIFIER && 2 < content.length() && SqlEarley.getInstance().symbolIndexes.containsKey("'" + content + "'")) {
                            matches = content.equalsIgnoreCase(t.content);
                        } else if (type == Token.OPERATION) {
                            boolean bl2 = matches = content.equalsIgnoreCase(t.content) || "/".equals(content) && ";".equals(t.content) || ";".equals(content) && "/".equals(t.content);
                        }
                    }
                    if (matches) continue;
                    match = null;
                    break;
                }
            }
            if (match == null) continue;
            break;
        }
        if (match == null) {
            target.add(elem);
        } else if (elem.le(match)) {
            target.remove(match);
            target.add(elem);
        }
    }

    public static void generateTemplate(ParseNode root, List<LexerToken> src, String fragment, Map<Long, Set<Substr>> templates, long weight, DocURL.Manual man, String pageParagraph) {
        for (ParseNode n : root.descendants()) {
            if (n.to - n.from < 3 || n.to - n.from == 3 && ".".equals(src.get((int)(n.from + 1)).content)) continue;
            for (int s : n.content()) {
                String symb = SqlEarley.getInstance().allSymbols[s];
                if (symb.charAt(0) == '\'' || symb.contains("[") || symb.equals("iteration_scheme") || symb.equals("select_clause") || symb.equals("DECLARE_decls_opt") || symb.equals("subprg_spec") || symb.equals("with_clause") || symb.equals("table_reference")) continue;
                ParseNode parent = n.parent();
                if (parent != null) {
                    for (int j : parent.content()) {
                        long key = Service.lPair(s, j);
                        Set<Substr> tmp = templates.get(key);
                        if (tmp == null) {
                            tmp = new HashSet<Substr>();
                            templates.put(key, tmp);
                        }
                        DocURL url = null;
                        if (man != null) {
                            url = new DocURL(man, pageParagraph);
                        }
                        if (symb.equals("aggregate_function")) {
                            weight = -1L;
                        }
                        Substr.add(tmp, new Substr(src.get((int)n.from).begin, src.get((int)(n.to - 1)).end, fragment.intern(), weight, url));
                    }
                    continue;
                }
                long key = Service.lPair(s, 0);
                Set<Substr> tmp = templates.get(key);
                if (tmp == null) {
                    tmp = new HashSet<Substr>();
                    templates.put(key, tmp);
                }
                DocURL url = null;
                if (man != null) {
                    url = new DocURL(man, pageParagraph);
                }
                if (symb.equals("aggregate_function")) {
                    weight = -1L;
                }
                Substr.add(tmp, new Substr(src.get((int)n.from).begin, src.get((int)(n.to - 1)).end, fragment.intern(), weight, url));
            }
        }
    }

    public static void listSuggestions(Set<Long> symbols, String prEfIx, String follower, Map<Long, Set<Substr>> templates, Set<Substr> topSuggestions, int limit) {
        for (Long ls : symbols) {
            Set<Substr> set = templates.get(ls);
            if (set == null) continue;
            for (Substr ts : set) {
                String tsl = ts.cutSrc().toLowerCase();
                Substr tsc = ts;
                if (!tsl.startsWith(prEfIx.toLowerCase())) continue;
                if (follower != null) {
                    List<LexerToken> src = Lexer.parse(tsl);
                    if (src.size() < 2 || !src.get((int)1).content.startsWith(follower)) continue;
                    tsc = new Substr(ts.from + src.get((int)1).begin, ts.to, ts.src, ts.weight, ts.doc);
                }
                Substr max = null;
                for (Substr tmp : topSuggestions) {
                    if (max != null && !max.le(tmp)) continue;
                    max = tmp;
                }
                if (topSuggestions.size() >= limit && !tsc.le(max)) continue;
                Substr.add(topSuggestions, tsc);
                if (limit >= topSuggestions.size()) continue;
                topSuggestions.remove(max);
            }
        }
    }

    public static void main(String[] args) {
        Map<Long, Set<Substr>> templates = HarvestDoc.getTemplates();
        for (long key : templates.keySet()) {
            Set<Substr> ts = templates.get(key);
            for (Substr s : ts) {
                if (!s.toString().startsWith("WHI")) continue;
                System.out.println(Service.lX(key) + "=" + SqlEarley.getInstance().allSymbols[Service.lX(key)]);
                System.out.println(Service.lY(key) + "=" + SqlEarley.getInstance().allSymbols[Service.lY(key)]);
                System.out.println(" " + s.toString());
            }
        }
    }
}

