/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import oracle.arbori.util.IntegerMap;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.Visual;

public class Matrix {
    public Visual visual = null;
    public Parser parser = null;
    public Queue<Long> completionQueue = new LinkedList<Long>();
    private IntegerMap[] cells = null;
    private int lastY = 0;
    public int[] allXs = null;

    public boolean contains(int x, int y, int symbol) {
        Parser.EarleyCell cell = this.get(x, y);
        if (cell == null) {
            return false;
        }
        for (int i = 0; i < cell.size(); ++i) {
            Parser.Tuple tuple = this.parser.rules[cell.getRule(i)];
            if (tuple.head != symbol || tuple.rhs.length != cell.getPosition(i)) continue;
            return true;
        }
        return false;
    }

    public void enqueue(long candidate) {
        this.completionQueue.add(candidate);
    }

    public long dequeue() {
        if (this.completionQueue.isEmpty()) {
            return -1L;
        }
        return this.completionQueue.remove();
    }

    public Visual getVisual() {
        return this.visual;
    }

    public Matrix(Parser p) {
        this.parser = p;
    }

    public Parser.EarleyCell get(int x, int y) {
        return (Parser.EarleyCell)this.cells[y].get(x);
    }

    public void put(int x, int y, Parser.EarleyCell content) {
        if (this.lastY < y) {
            this.lastY = y;
        }
        this.cells[y].put(x, content);
    }

    public void initCells(int length) {
        this.cells = new IntegerMap[length + 1];
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i] = new IntegerMap();
        }
    }

    public int lastY() {
        return this.lastY;
    }

    public IntegerMap getXRange(int y) {
        return this.cells[y];
    }

    public String toString() throws RuntimeException {
        StringBuffer ret = new StringBuffer();
        for (int y = 0; y < this.cells.length; ++y) {
            for (int x : this.cells[y].keySet()) {
                Parser.EarleyCell output = this.get(x, y);
                if (output == null) {
                    System.out.println(".\n");
                    continue;
                }
                ret.append("[" + x + "," + y + ")");
                int cutover = 50;
                if (50 < output.size()) {
                    ret.append(" ... " + output.size() + " more symbols");
                } else {
                    for (int i = 0; i < output.size() && i < 51; ++i) {
                        ((Earley)this.parser).toString(output.getRule(i), output.getPosition(i), ret);
                    }
                }
                ret.append("\n\n");
            }
        }
        return ret.toString();
    }

    public List<Integer> getEarleyBackptrs(int x, int y, Cell cell, int index) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        if (x == y && x == 0) {
            ret.add(x);
            return ret;
        }
        int rule = cell.getRule(index);
        Parser.Tuple tuple = ((Earley)this.parser).rules[rule];
        int pos = cell.getPosition(index);
        if (x == y) {
            IntegerMap xRange = this.cells[y];
            block0: for (int mid : xRange.keySet()) {
                Parser.EarleyCell candidate;
                if (x < mid || (candidate = this.get(mid, x)) == null) continue;
                for (int i = 0; i < candidate.size(); ++i) {
                    Parser.Tuple candTuple = ((Earley)this.parser).rules[candidate.getRule(i)];
                    int candPos = candidate.getPosition(i);
                    if (candPos >= candTuple.rhs.length || candTuple.rhs[candPos] != tuple.head) continue;
                    if (ret.contains(mid)) continue block0;
                    ret.add(mid);
                    continue block0;
                }
            }
            return ret;
        }
        Parser.EarleyCell candidate = this.get(x, y - 1);
        if (candidate != null) {
            for (int i = 0; i < candidate.size(); ++i) {
                int candPos;
                int candRule = candidate.getRule(i);
                if (rule != candRule || (candPos = candidate.getPosition(i)) + 1 != pos) continue;
                Parser.Tuple candTuple = ((Earley)this.parser).rules[candRule];
                if (candTuple.rhs[candPos] != ((Earley)this.parser).identifier && candTuple.rhs[candPos] != ((Earley)this.parser).string_literal && candTuple.rhs[candPos] != ((Earley)this.parser).digits && this.parser.allSymbols[candTuple.rhs[candPos]].charAt(0) != '\'') continue;
                ret.add(y + 1);
                break;
            }
        }
        IntegerMap xRange = this.cells[y];
        block3: for (int mid : xRange.keySet()) {
            Parser.EarleyCell post;
            Parser.EarleyCell pre;
            if (mid < x || y < mid || (pre = this.get(x, mid)) == null || (post = this.get(mid, y)) == null) continue;
            for (int i = 0; i < pre.size(); ++i) {
                for (int j = 0; j < post.size(); ++j) {
                    int symPre;
                    int rulePre = pre.getRule(i);
                    int rulePost = post.getRule(j);
                    int dotPre = pre.getPosition(i);
                    int dotPost = post.getPosition(j);
                    Parser.Tuple tPre = ((Earley)this.parser).rules[rulePre];
                    Parser.Tuple tPost = ((Earley)this.parser).rules[rulePost];
                    if (tPost.size() != dotPost || rulePre != rule || dotPre + 1 != pos || (symPre = tPre.content(dotPre)) != tPost.head) continue;
                    ret.add(mid);
                    continue block3;
                }
            }
        }
        return ret;
    }

    public Matrix recalc() {
        Matrix matrix = new Matrix(this.parser);
        matrix.visual = this.visual;
        return matrix;
    }

    public boolean recognized(int x, int y, int rule, int pos) {
        Parser.EarleyCell cell = this.get(x, y);
        for (int i = 0; i < cell.size(); ++i) {
            int p;
            int r = cell.getRule(i);
            if (r != rule || (p = cell.getPosition(i)) != pos) continue;
            return true;
        }
        return false;
    }
}

