/*
 * Decompiled with CFR 0.152.
 */
package oracle.arbori.util;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Substitutions;
import oracle.dbtools.parser.plsql.ParsedSql;

public class DictionaryViews {
    Connection conn;
    Map<String, String> all2DbaViews = new HashMap<String, String>();
    Map<String, String> cachedQueries = new HashMap<String, String>();

    public DictionaryViews(Connection conn) {
        this.conn = conn;
    }

    public String translate(String query) {
        if (this.conn == null) {
            return query;
        }
        try {
            if (this.conn.isClosed()) {
                return query;
            }
        }
        catch (Exception e) {
            return query;
        }
        String ret = this.cachedQueries.get(query);
        if (ret != null) {
            return ret;
        }
        ret = query;
        ParsedSql parsed = new ParsedSql(query);
        if (parsed.getSyntaxError() != null) {
            return query;
        }
        Substitutions subs = new Substitutions(parsed);
        for (ParseNode node : parsed.getRoot().descendants()) {
            String token;
            if (node.from + 1 != node.to || !node.contains("identifier")) continue;
            ParseNode gParent = node.parent().parent();
            ParseNode predecessor = Attribute.getSibling(node, node.parent(), -1);
            if (!node.contains("query_table_expression") && !node.contains("query_table_expression___0") && !gParent.contains("column") && (predecessor == null || !predecessor.contains("query_table_expression")) && !node.contains("table") || !(token = parsed.getSrc().get((int)node.from).content.toLowerCase()).startsWith("dba_") && !token.startsWith("all_")) continue;
            String postfix = token.substring(4);
            Object dictView = this.all2DbaViews.get("all_" + postfix);
            if (dictView == null) {
                String probe = "select 1 from dba_" + postfix + " where 1=0";
                try (Statement stmt = this.conn.createStatement();
                     ResultSet rs = stmt.executeQuery(probe);){
                    dictView = "Dba_" + postfix;
                    this.all2DbaViews.put("all_" + postfix, (String)dictView);
                }
                catch (SQLException e) {
                    dictView = "All_" + postfix;
                    this.all2DbaViews.put("all_" + postfix, (String)dictView);
                }
            }
            subs.replace(node, (String)dictView);
        }
        ret = subs.transformInput();
        this.cachedQueries.put(query, ret);
        return ret;
    }

    public static void main(String[] args) throws Exception {
        Class<?> c = Class.forName("oracle.dbtools.app.SqlCompleterTest");
        Field f = c.getField("fullConnStr1");
        f.setAccessible(true);
        String fullConnStr = (String)f.get(null);
        Connection conn = DriverManager.getConnection(fullConnStr);
        DictionaryViews views = new DictionaryViews(conn);
        long t1 = System.currentTimeMillis();
        System.out.println(views.translate("select * from all_objects where all_objects.object_name='EMPLOYEES'"));
        System.out.println("elapsed " + (System.currentTimeMillis() - t1));
        t1 = System.currentTimeMillis();
        System.out.println(views.translate("select * from all_indexes"));
        System.out.println("elapsed " + (System.currentTimeMillis() - t1));
        t1 = System.currentTimeMillis();
        System.out.println(views.translate("select * from (SELECT * \n   FROM   all_objects) all_objects"));
        System.out.println("elapsed " + (System.currentTimeMillis() - t1));
        t1 = System.currentTimeMillis();
        System.out.println(views.translate("select * from dba_objects"));
        System.out.println("elapsed " + (System.currentTimeMillis() - t1));
        t1 = System.currentTimeMillis();
        System.out.println(views.translate("select * from all_indexes where index_name not like 'K'"));
        System.out.println("elapsed " + (System.currentTimeMillis() - t1));
        t1 = System.currentTimeMillis();
        System.out.println(views.all2DbaViews);
        System.out.println(views.cachedQueries);
    }
}

