/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.xml.navigator;

import java.util.List;
import java.util.Set;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.xml.navigator.FolderElement;
import oracle.dbtools.xml.navigator.FolderOwner;
import oracle.xml.parser.v2.XMLNode;

public final class CategoryElement
extends FolderOwner {
    private static final String REQUIRED_FEATURES = "requiredFeatures";
    private static final String REQUIRED_ACCESS_OBJECTS = "requiredAccessObjects";
    private FolderElement folder;
    private Version minimumVersion;
    private Version maximumVersion;
    private Set<String> requiredObjects;
    private Set<String> requiredFeatures;
    private boolean ignoreComparator;

    CategoryElement(XMLNode node) {
        super(node);
        List<FolderElement> folders = this.getFolders();
        if (folders.size() > 0) {
            this.folder = folders.get(0);
        }
        this.minimumVersion = CategoryElement.getVersion("", "minversion", node);
        this.maximumVersion = CategoryElement.getVersion("", "maxversion", node);
        this.requiredObjects = CategoryElement.parseSet(node, REQUIRED_ACCESS_OBJECTS);
        this.requiredFeatures = CategoryElement.parseSet(node, REQUIRED_FEATURES);
        this.ignoreComparator = FolderElement.parseIgnoreComparator(node);
    }

    public String getType() {
        return this.getID();
    }

    public FolderElement getFolder() {
        return this.folder;
    }

    public Version getMinimumVersion() {
        return this.minimumVersion;
    }

    public Version getMaximumVersion() {
        return this.maximumVersion;
    }

    public Set<String> getRequiredObjects() {
        return CategoryElement.wrapSet(this.requiredObjects);
    }

    public Set<String> getRequiredFeatures() {
        return CategoryElement.wrapSet(this.requiredFeatures);
    }

    public boolean isIgnoreComparator() {
        return this.ignoreComparator;
    }
}

