/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import oracle.dbtools.util.Messages;

public class Logger {
    private static final String NO_THROWABLE_STACK_ELEMENT = "(Internal error) No Throwable Stack Element";
    private static final String NO_THROWABLE_OBJECT_FOUND = "(Internal error) No Throwable object found";
    private static final String NO_THROWABLE_OBJECT_THREAD_DIED = "(Internal error) Thread died because there is no throwable object";

    private Logger() {
    }

    public static void ignore(Class<?> clazz, Throwable t) {
        String msg = Messages.format("Logger_ignored", Logger.format(t));
        Logger.log(clazz, Level.FINE, msg, t);
    }

    public static void finest(Class<?> clazz, Throwable t) {
        Logger.log(clazz, Level.FINEST, Logger.format(t), t);
    }

    public static void finer(Class<?> clazz, Throwable t) {
        Logger.log(clazz, Level.FINER, Logger.format(t), t);
    }

    public static void fine(Class<?> clazz, Throwable t) {
        Logger.log(clazz, Level.FINE, Logger.format(t), t);
    }

    public static void info(Class<?> clazz, Throwable t) {
        Logger.log(clazz, Level.INFO, Logger.format(t), t);
    }

    public static void warn(Class<?> clazz, Throwable t) {
        Logger.log(clazz, Level.WARNING, Logger.format(t), t);
    }

    public static void severe(Class<?> clazz, Throwable t) {
        Logger.log(clazz, Level.SEVERE, Logger.format(t), t);
    }

    public static void finest(Class<?> clazz, String msg) {
        Logger.log(clazz, Level.FINEST, msg, null);
    }

    public static void finer(Class<?> clazz, String msg) {
        Logger.log(clazz, Level.FINER, msg, null);
    }

    public static void fine(Class<?> clazz, String msg) {
        Logger.log(clazz, Level.FINE, msg, null);
    }

    public static void info(Class<?> clazz, String msg) {
        Logger.log(clazz, Level.INFO, msg, null);
    }

    public static void warn(Class<?> clazz, String msg) {
        Logger.log(clazz, Level.WARNING, msg, null);
    }

    public static void severe(Class<?> clazz, String msg) {
        Logger.log(clazz, Level.SEVERE, msg, null);
    }

    public static void finest(Class<?> clazz, String msg, Throwable t) {
        Logger.log(clazz, Level.FINEST, Logger.format(msg, t), t);
    }

    public static void finer(Class<?> clazz, String msg, Throwable t) {
        Logger.log(clazz, Level.FINER, Logger.format(msg, t), t);
    }

    public static void fine(Class<?> clazz, String msg, Throwable t) {
        Logger.log(clazz, Level.FINE, Logger.format(msg, t), t);
    }

    public static void info(Class<?> clazz, String msg, Throwable t) {
        Logger.log(clazz, Level.INFO, Logger.format(msg, t), t);
    }

    public static void warn(Class<?> clazz, String msg, Throwable t) {
        Logger.log(clazz, Level.WARNING, Logger.format(msg, t), t);
    }

    public static void severe(Class<?> clazz, String msg, Throwable t) {
        Logger.log(clazz, Level.SEVERE, Logger.format(msg, t), t);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        Logger.log(clazz, Level.INFO, sw.toString(), t);
    }

    private static String format(Throwable t) {
        if (t == null) {
            return Messages.format("Logger_exception", NO_THROWABLE_OBJECT_FOUND, NO_THROWABLE_OBJECT_THREAD_DIED);
        }
        StackTraceElement[] stes = t.getStackTrace();
        if (stes.length == 0) {
            return Messages.format("Logger_exception", t.getLocalizedMessage(), NO_THROWABLE_STACK_ELEMENT);
        }
        return Messages.format("Logger_exception", t.getLocalizedMessage(), t.getStackTrace()[0].toString());
    }

    private static String format(String msg, Throwable t) {
        return Messages.format("Logger_detail", msg, Logger.format(t));
    }

    public static void log(Class<?> clazz, Level level, String msg, Throwable t) {
        if (null == clazz) {
            clazz = Logger.class;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setThrown(t);
        Logger.inferCaller(lr);
        java.util.logging.Logger.getLogger(clazz.getName()).log(lr);
    }

    private static void inferCaller(LogRecord lr) {
        StackTraceElement frame;
        String cname;
        int ix;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (ix = 0; ix < stack.length && !(cname = (frame = stack[ix]).getClassName()).equals(Logger.class.getName()); ++ix) {
        }
        while (ix < stack.length) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (!cname.equals(Logger.class.getName())) {
                lr.setSourceClassName(cname);
                lr.setSourceMethodName(frame.getMethodName());
                return;
            }
            ++ix;
        }
    }
}

