/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorCodeChecker {
    private static final String URL_PATTERN = "https://docs.oracle.com/error-help/db/{0}-{1}/";

    private static boolean isValidOracleError(String potentialError) {
        String regex = "[A-Z]+-[0-9]+";
        Pattern pattern = Pattern.compile("[A-Z]+-[0-9]+", 2);
        Matcher matcher = pattern.matcher(potentialError);
        return matcher.matches();
    }

    private static String getErrorCodeComponent(String errorCode) {
        String[] parts = errorCode.split("-");
        if (parts != null && parts.length > 0) {
            return parts[0];
        }
        return null;
    }

    private static String getErrorCodeNumber(String errorCode, int i) {
        String[] parts = errorCode.split("-");
        if (parts != null && parts.length > 1) {
            return parts[1];
        }
        return null;
    }

    public static String getOracleErrorURL(ArrayList<String> errorCodes) {
        StringBuilder sb = new StringBuilder();
        sb.append(System.lineSeparator() + "More Details :" + System.lineSeparator());
        Iterator<String> it = errorCodes.iterator();
        while (it.hasNext()) {
            sb.append(ErrorCodeChecker.getOracleErrorURL(it.next()));
            if (!it.hasNext()) continue;
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    public static String getOracleErrorURL(String errorCode) {
        String component = "";
        String number = "";
        String url = "";
        if (ErrorCodeChecker.isValidOracleError(errorCode)) {
            component = ErrorCodeChecker.getErrorCodeComponent(errorCode);
            number = ErrorCodeChecker.getErrorCodeNumber(errorCode, 5);
            url = MessageFormat.format(URL_PATTERN, component.toLowerCase(), number);
            return url;
        }
        return null;
    }

    private static boolean containsValidOracleError(String line) {
        String regex = "[A-Z]+-[0-9]+:";
        Pattern pattern = Pattern.compile("[A-Z]+-[0-9]+:", 2);
        Matcher matcher = pattern.matcher(line);
        return matcher.find();
    }

    public static ArrayList<String> getErrorCodes(String message) {
        String[] linesParts = message.split("\n");
        ArrayList<String> codes = new ArrayList<String>();
        ArrayList<String> strList = new ArrayList<String>(Arrays.asList(linesParts));
        for (String line : strList) {
            String[] parts;
            if (!ErrorCodeChecker.containsValidOracleError(line) || (parts = line.split(":")) == null || parts.length <= 0 || !ErrorCodeChecker.isValidOracleError(parts[0]) || codes.contains(parts[0])) continue;
            codes.add(parts[0]);
        }
        return codes;
    }
}

