/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scripting;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.CommandRegistry;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.scripting.Messages;
import oracle.dbtools.scripting.Script;
import oracle.dbtools.scripting.ScriptingMessages;
import oracle.dbtools.scripting.ScriptingUtils;

public class ScriptCommand
extends CommandListener
implements IHelp {
    private static Logger LOGGER = Logger.getLogger(ScriptCommand.class.getName());

    @Override
    public String getCommand() {
        return "SCRIPT";
    }

    @Override
    public String getHelp() {
        return ScriptingMessages.getString(this.getCommand()) + "\n" + ScriptingUtils.showEngines();
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public String getDescription() {
        return ScriptingMessages.getString("SCRIPT_DESCRIPTION");
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        int noslines = cmd.getSql().split("\r\n|\r|\n").length;
        if (cmd.getSql().split("\\s+").length == 1) {
            return true;
        }
        if (null != ctx.getProperties().get("cli.conn.props") && ((Properties)ctx.getProperties().get("cli.conn.props")).containsKey("password")) {
            ((Properties)ctx.getProperties().get("cli.conn.props")).remove("password");
        }
        if (noslines > 1) {
            String code = cmd.getSql().substring(cmd.getSql().indexOf(10) + 1);
            Script s = new Script();
            s.setExtension("js");
            s.setScript(code);
            this.runScript(conn, ctx, cmd, s, new String[0]);
        } else {
            Script s = new Script();
            String fullCmd = cmd.getSql().substring(cmd.getSql().indexOf(" ")).trim();
            String regex = "\"?( |$)(?=(([^\"]*\"){2})*[^\"]*$)\"?";
            String[] parts = fullCmd.split(regex);
            parts = this.trimQuotes(parts);
            Object location = parts[0];
            String ext = "js";
            if (((String)location).indexOf(".", ((String)location).lastIndexOf(File.separator)) > 0) {
                ext = ((String)location).substring(((String)location).indexOf(".", ((String)location).lastIndexOf(File.separator)) + 1);
            } else {
                location = (String)location + ".js";
            }
            try {
                URLConnection uc = FileUtils.getFile(ctx, (String)location);
                if (uc == null) {
                    throw new IOException((String)location);
                }
                InputStream in = uc.getInputStream();
                byte[] contents = new byte[1024];
                int bytesRead = 0;
                StringBuilder strFileContents = new StringBuilder();
                while ((bytesRead = in.read(contents)) != -1) {
                    strFileContents.append(new String(contents, 0, bytesRead));
                }
                String content = strFileContents.toString();
                s.setScript(content);
            }
            catch (IOException e1) {
                ctx.write(MessageFormat.format(Messages.getString("ScriptCommand.8"), location));
                ctx.write("\n");
                return true;
            }
            if (ext != null) {
                s.setExtension(ext);
            } else {
                s.setExtension("js");
            }
            ScriptEngineManager mgr = new ScriptEngineManager();
            if (mgr.getEngineByExtension(s.getExtension()) == null) {
                ctx.write(MessageFormat.format(ScriptingMessages.getString("ScriptCommand.1"), s.getExtension()));
                return true;
            }
            this.runScript(conn, ctx, cmd, s, parts);
        }
        return true;
    }

    private String[] trimQuotes(String[] parts) {
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].startsWith("\"")) {
                parts[i] = parts[i].substring(1);
            }
            if (!parts[i].endsWith("\"")) continue;
            parts[i] = parts[i].substring(0, parts[i].length());
        }
        return parts;
    }

    private void runScript(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, Script script, String[] scriptArgs) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (conn != null) {
            map.put("conn", conn);
            map.put("isConnected", true);
        } else {
            map.put("isConnected", false);
        }
        map.put("ctx", ctx);
        map.put("out", ctx.getOutputStream());
        DBUtil dbUtil = null;
        if (conn != null) {
            dbUtil = DBUtil.getInstance(conn);
        }
        map.put("util", dbUtil);
        map.put("commands", CommandRegistry.class);
        ScriptExecutor sqlcl = new ScriptExecutor(conn);
        sqlcl.setScriptRunnerContext(ctx);
        map.put("sqlcl", sqlcl);
        map.put("args", scriptArgs);
        try {
            ScriptingUtils.runScript(ctx, script, map);
        }
        catch (ScriptException e) {
            String message = e.getMessage();
            if (message != null && e.getFileName() != null) {
                message = message.replace(" in " + e.getFileName(), "");
            }
            ctx.write(MessageFormat.format("{0}\n", message));
        }
        catch (Exception e) {
            String error = "";
            String errNo = "";
            int line = 0;
            int col = 0;
            if (e.getMessage().contains("<eval>")) {
                error = e.getMessage().split("<eval>:")[1];
                errNo = new StringTokenizer(error).nextToken();
                line = Integer.parseInt(errNo.split(":")[0]);
                col = Integer.parseInt(errNo.split(":")[1]);
                ctx.write(MessageFormat.format(Messages.getString("ScriptCommand.99"), line, col, error.substring(errNo.length())));
            } else if (e.getMessage().contains("Exception:")) {
                String message = e.getMessage().split("Exception:")[1];
                ctx.write(MessageFormat.format("ERROR:JS: {0})\n", message));
            } else {
                ctx.write(MessageFormat.format("Error: {0}", e.getMessage()));
            }
            oracle.dbtools.util.Logger.fine(this.getClass(), e.getCause());
        }
    }
}

