/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.t2format;

import java.util.ArrayList;
import java.util.HashMap;

public class T2Metrics {
    public static final String NAME = "name";
    public static final String METRICTYPE = "gauge";
    public static final String CONFIG = "config";
    public static final String SERIES = "series";
    public static final String SERIES_VALUE = "value";
    public static final String SERIES_COUNT = "count";
    private String name;
    private String metricType;
    private HashMap<String, Object> config;
    private ArrayList<Series> series = new ArrayList();

    public T2Metrics(String name, String metricType, HashMap config, Long second, String value, Integer count) {
        this.name = name;
        this.metricType = metricType;
        this.config = config;
        Series ser = new Series(second, value, count);
        this.series.add(ser);
    }

    public String getName() {
        return this.name;
    }

    public String getMetricType() {
        return this.metricType;
    }

    public HashMap<String, Object> getConfig() {
        return this.config;
    }

    public ArrayList<Series> getSeries() {
        return this.series;
    }

    class Series {
        private Long second;
        private ArrayList<HashMap<String, Object>> values = new ArrayList();

        public Series(Long second, String value, Integer count) {
            this.second = second;
            HashMap<String, Object> vmap = new HashMap<String, Object>();
            vmap.put(T2Metrics.SERIES_VALUE, value);
            vmap.put(T2Metrics.SERIES_COUNT, count);
            this.values.add(vmap);
        }

        public Long getSecond() {
            return this.second;
        }

        public ArrayList<HashMap<String, Object>> getValues() {
            return this.values;
        }
    }
}

