/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.transformer.number;

import java.util.Locale;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.TransformContext;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.Transformer;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.number.HelpMessages;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.number.Messages;

public class PositiveIntegerTransformer
implements Transformer<String, Integer> {
    @Override
    public Integer transform(String rawValue, TransformContext context, Environment environment) {
        Integer value = null;
        try {
            value = Integer.valueOf(rawValue);
            if (value < 0) {
                context.addError(Messages.getString(Messages.Key.FORMAT_ERROR, environment.getLocale()));
                return null;
            }
        }
        catch (NumberFormatException ex) {
            context.addError(Messages.getString(Messages.Key.FORMAT_ERROR, environment.getLocale()));
        }
        return value;
    }

    @Override
    public String getFormat(Locale locale) {
        return HelpMessages.getString(HelpMessages.Key.INTEGER, locale);
    }
}

