/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.transformer.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Locale;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.TransformContext;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.Transformer;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.file.HelpMessages;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.file.Messages;

public class FileNotExists
implements Transformer<String, String> {
    @Override
    public String transform(String rawValue, TransformContext context, Environment environment) {
        String expandedValue = null;
        try {
            expandedValue = this.expandTilde(rawValue);
            Path p = environment.getAbsolutePath(expandedValue).toAbsolutePath();
            if (Files.exists(p, new LinkOption[0])) {
                context.addError(MessageFormat.format(Messages.getString(Messages.Key.FILE_ALREADY_EXISTS, environment.getLocale()), rawValue));
                return null;
            }
        }
        catch (Exception e) {
            context.addError(MessageFormat.format(Messages.getString(Messages.Key.FILE_ALREADY_EXISTS, environment.getLocale()), rawValue));
            return null;
        }
        return expandedValue;
    }

    @Override
    public String getFormat(Locale locale) {
        return HelpMessages.getString(HelpMessages.Key.FILE, locale);
    }

    private String expandTilde(String path) {
        if (path.startsWith("~")) {
            String homeDir = System.getProperty("user.home");
            return homeDir + path.substring(1);
        }
        return path;
    }
}

