/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.transformer.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.TransformContext;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.Transformer;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.database.DatabaseTransformerQuery;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.database.Messages;

public abstract class AbstractDatabaseTransformer
implements Transformer<String, String> {
    private String rawValue;
    private TransformContext context;
    private Environment environment;
    DatabaseTransformerQuery dbQuery;

    protected AbstractDatabaseTransformer() {
    }

    public void init(TransformContext context, Environment environment) {
        this.context = context;
        this.environment = environment;
        this.dbQuery = new DatabaseTransformerQuery(context, environment);
    }

    protected String exists(String queryId, String rawValue) {
        this.rawValue = rawValue;
        Boolean exists = this.dbQuery.existsQuery(queryId, rawValue);
        if (exists == null || !exists.booleanValue()) {
            return null;
        }
        return rawValue;
    }

    protected String executeQuery(String queryId, Map<String, String> binds) {
        Optional<Connection> connOpt = this.environment.getConnection();
        if (connOpt.isEmpty()) {
            this.context.addError(Messages.getString(Messages.Key.CONN_REQ, this.environment.getLocale()));
            return null;
        }
        Connection conn = connOpt.get();
        String query = DatabaseTransformerQuery.getQuery(queryId, conn);
        DBUtil dBUtil = DBUtil.getInstance(conn);
        String result = dBUtil.executeReturnOneCol(query, binds);
        SQLException e = dBUtil.getLastException();
        if (e != null) {
            if (e.getErrorCode() == 44001) {
                this.context.addError(MessageFormat.format(Messages.getString(Messages.Key.BAD_PARM_VALUE, this.environment.getLocale()), this.rawValue));
            }
            if (e.getErrorCode() == 17008) {
                this.context.addError(Messages.getString(Messages.Key.CONN_CLOSED, this.environment.getLocale()));
            } else {
                this.context.addError(Messages.getString(Messages.Key.SQL_ERR_MESSAGE, this.environment.getLocale()));
            }
            return null;
        }
        return result;
    }

    protected String executeQuery(String queryId, String bind) {
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("VALUE", bind);
        return this.executeQuery(queryId, binds);
    }

    protected Boolean existsQuery(String queryId, Map<String, String> binds) {
        String result = this.executeQuery(queryId, binds);
        if (result == null) {
            this.context.addError(MessageFormat.format(Messages.getString(Messages.Key.BAD_PARM_VALUE, this.environment.getLocale()), this.rawValue));
            return null;
        }
        if (result.equals("0")) {
            this.context.addError(MessageFormat.format(Messages.getString(Messages.Key.BAD_PARM_VALUE, this.environment.getLocale()), this.rawValue));
            return false;
        }
        return true;
    }

    protected Boolean existsQuery(String queryId, String bind) {
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("VALUE", bind);
        return this.existsQuery(queryId, binds);
    }
}

