/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.provider;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.Locale;
import java.util.Optional;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.utils.NLSUtils;

class EnvironmentProvider
implements Environment {
    private final ScriptRunnerContext ctx;

    EnvironmentProvider(ScriptRunnerContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public Path getAbsolutePath(String filePath) {
        return Paths.get(this.ctx.prependCD(filePath), new String[0]);
    }

    @Override
    public Optional<Connection> getConnection() {
        return Optional.ofNullable(this.ctx.getCurrentConnection());
    }

    @Override
    public int getConsoleLineSize() {
        return Integer.parseInt(this.ctx.getProperty("script.runner.setlinesize").toString());
    }

    @Override
    public Locale getLocale() {
        Connection currentConnection = this.ctx.getCurrentConnection();
        Locale locale = currentConnection != null ? NLSUtils.getNLSSessionLocale(currentConnection) : Locale.getDefault();
        return locale;
    }

    @Override
    public ScriptRunnerContext getCtx() {
        return this.ctx;
    }
}

