/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Expression;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ExpressionBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.GrammarBuildContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Messages;
import oracle.dbtools.raptor.newscriptrunner.util.parser.NamePropertiesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.NamedExpression;
import oracle.dbtools.raptor.newscriptrunner.util.parser.NamedExpressionVisitor;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Node;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Syntax;
import oracle.dbtools.raptor.newscriptrunner.util.parser.TransformContextImpl;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.tokenizer.Token;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.Transformer;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.basic.ChainedTransformer;

public class VarBuilder
extends ExpressionBuilder {
    private final NamePropertiesBuilder namePropertiesBuilder = new NamePropertiesBuilder();
    private final Transformer<String, ?> transformer;

    public VarBuilder helpId(String helpId) {
        this.namePropertiesBuilder.setHelpId(helpId);
        return this;
    }

    public VarBuilder helpId() {
        this.namePropertiesBuilder.setHelpId(null);
        return this;
    }

    protected VarBuilder(Transformer<String, ?>[] transformers, String name) {
        this.transformer = transformers.length == 1 ? transformers[0] : new ChainedTransformer(transformers);
        this.namePropertiesBuilder.setName(Objects.requireNonNull(name));
    }

    @Override
    protected Expression build(GrammarBuildContext context) {
        return context.compose(new Var(context, this, this.namePropertiesBuilder.build(false)));
    }

    private static class Var
    implements NamedExpression {
        private final String name;
        private final Optional<String> helpId;
        private final Transformer<String, ?> transformer;

        Var(GrammarBuildContext context, VarBuilder builder, NamePropertiesBuilder.NameProperties nameProperties) {
            this.name = nameProperties.getName();
            this.helpId = nameProperties.getHelpId();
            this.transformer = builder.transformer;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Optional<String> getHelpId() {
            return this.helpId;
        }

        @Override
        public Set<String> getSynonyms() {
            return Collections.singleton(this.name);
        }

        @Override
        public Syntax getSyntax() {
            StringBuilder buff = new StringBuilder();
            buff.append('<');
            buff.append(this.name.toLowerCase());
            buff.append('>');
            return new Syntax(buff.toString(), false);
        }

        @Override
        public void visitNamedExpressions(NamedExpressionVisitor visitor) {
            if (this.helpId.isPresent()) {
                visitor.accept(this);
            }
        }

        @Override
        public void parse(Node node) {
            Token token = node.next();
            ArrayList<String> errors = new ArrayList<String>();
            ArrayList<String> completions = new ArrayList<String>();
            if (token == null) {
                node.setParseErrorUsing(token);
                if (node.hasTrailingWhiteSpace()) {
                    this.transformer.transform("", new TransformContextImpl(errors::add, completions::add), node.getEnvironment());
                    node.mergeCompletions(completions);
                }
            } else {
                Object transformedValue = this.transform(this.transformer, token, token.getValue(), errors, completions, node.getEnvironment());
                if (transformedValue != null) {
                    node.setValue(transformedValue);
                    node.setMatched();
                } else {
                    node.setParseErrorUsing(token);
                }
                if (!node.hasTrailingWhiteSpace() && !node.hasMoreTokens()) {
                    node.mergeCompletions(completions);
                }
                for (String error : errors) {
                    node.addSemanticError(error);
                }
            }
        }

        public String toString() {
            return "VAR";
        }

        private Object transform(Transformer<String, ?> transformer, Token token, String rawValue, List<String> errors, List<String> completions, Environment environment) {
            ArrayList transformerErrors = new ArrayList();
            Object value = transformer.transform(rawValue, new TransformContextImpl(transformerErrors::add, completions::add), environment);
            if (!transformerErrors.isEmpty()) {
                String detailMessage = "  " + String.join((CharSequence)"\n  ", transformerErrors);
                errors.add(MessageFormat.format(Messages.getString(Messages.Key.FORMAT_ERROR, environment.getLocale()), rawValue, token.getStart(), this.getSyntax().get(), detailMessage));
            }
            return value;
        }
    }
}

