/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import java.util.Optional;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Expression;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ExpressionBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.GrammarBuildContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.NamePropertiesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Rule;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Syntax;

public class RuleBuilder {
    private final NamePropertiesBuilder namePropertiesBuilder = new NamePropertiesBuilder();
    private final Id id;
    private ExpressionBuilder expr;
    private boolean flattened;

    public RuleBuilder name(String name) {
        this.namePropertiesBuilder.setName(name);
        return this;
    }

    public RuleBuilder helpId(String helpId) {
        this.namePropertiesBuilder.setHelpId(helpId);
        return this;
    }

    public RuleBuilder helpId() {
        this.namePropertiesBuilder.setHelpId(null);
        return this;
    }

    public RuleBuilder eq(ExpressionBuilder expr) {
        this.expr = expr;
        return this;
    }

    public RuleBuilder flattened() {
        this.flattened = true;
        return this;
    }

    protected RuleBuilder(Id id) {
        this.id = id;
    }

    protected Rule build(GrammarBuildContext context, boolean startRule) {
        return new RuleImpl(context, this, startRule, this.namePropertiesBuilder.build(this.id, false));
    }

    private static class RuleImpl
    implements Rule {
        private final Id id;
        private final String name;
        private final Optional<String> helpId;
        private final Expression rootExpression;
        private final boolean startRule;
        private final boolean flattened;

        private RuleImpl(GrammarBuildContext context, RuleBuilder builder, boolean startRule, NamePropertiesBuilder.NameProperties nameProperties) {
            if (startRule && builder.flattened) {
                throw new IllegalArgumentException("start rule cannot be flattened: " + nameProperties.getName());
            }
            this.id = builder.id;
            this.startRule = startRule;
            this.rootExpression = builder.expr.build(context);
            this.flattened = builder.flattened;
            this.name = nameProperties.getName();
            this.helpId = nameProperties.getHelpId();
        }

        @Override
        public Id getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Optional<String> getHelpId() {
            return this.helpId;
        }

        @Override
        public String asBNF() {
            return this.syntax(!this.startRule);
        }

        @Override
        public Syntax getSyntax() {
            if (this.flattened) {
                return new Syntax(this.syntax(false), true);
            }
            return new Syntax(this.nameSyntax(), false);
        }

        @Override
        public boolean isStartRule() {
            return this.startRule;
        }

        @Override
        public boolean isFlattened() {
            return this.flattened;
        }

        @Override
        public Expression getExpression() {
            return this.rootExpression;
        }

        public String toString() {
            return this.name;
        }

        private String syntax(boolean includeName) {
            StringBuilder buff = new StringBuilder();
            if (includeName) {
                buff.append(this.nameSyntax());
                buff.append(" := ");
            }
            buff.append(this.rootExpression.getSyntax().get());
            return buff.toString();
        }

        private String nameSyntax() {
            StringBuilder buff = new StringBuilder();
            buff.append('<');
            buff.append(this.name.toLowerCase());
            buff.append('>');
            return buff.toString();
        }
    }
}

